/*
 * Decompiled with CFR 0.152.
 */
package fr.mod.worldgen;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.mod.Config;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.FeatureSorter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.blending.Blender;
import org.jetbrains.annotations.NotNull;

public class OnelayerChunkGenerator
extends NoiseBasedChunkGenerator {
    public static final MapCodec<OnelayerChunkGenerator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BiomeSource.CODEC.fieldOf("biome_source").forGetter(ChunkGenerator::getBiomeSource), (App)NoiseGeneratorSettings.CODEC.fieldOf("settings").forGetter(NoiseBasedChunkGenerator::generatorSettings)).apply((Applicative)instance, OnelayerChunkGenerator::new));
    private static final BlockState BEDROCK = Blocks.BEDROCK.defaultBlockState();
    private static final BlockState STONE = Blocks.STONE.defaultBlockState();
    private static final BlockState DIRT = Blocks.DIRT.defaultBlockState();
    private static final BlockState GRASS_BLOCK = Blocks.GRASS_BLOCK.defaultBlockState();
    private final Function<Holder<Biome>, BiomeGenerationSettings> generationSettingsGetter = biome -> ((Biome)biome.value()).getGenerationSettings();
    private final Supplier<List<FeatureSorter.StepFeatureData>> featuresPerStep = Suppliers.memoize(() -> FeatureSorter.buildFeaturesPerStep(List.copyOf(biomeSource.possibleBiomes()), biome -> ((Biome)biome.value()).getGenerationSettings().features(), (boolean)true));

    public OnelayerChunkGenerator(BiomeSource biomeSource, Holder<NoiseGeneratorSettings> settings) {
        super(biomeSource, settings);
    }

    protected MapCodec<? extends ChunkGenerator> codec() {
        return CODEC;
    }

    public void applyCarvers(WorldGenRegion worldGenRegion, long l, RandomState randomState, BiomeManager biomeManager, StructureManager structureManager, ChunkAccess chunkAccess, GenerationStep.Carving carving) {
    }

    public void buildSurface(WorldGenRegion region, StructureManager structureManager, RandomState randomState, ChunkAccess chunk) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int startX = chunk.getPos().getMinBlockX();
        int startZ = chunk.getPos().getMinBlockZ();
        int bedrockY = region.getMinBuildHeight();
        int stoneY = bedrockY + Config.stoneLayers;
        int dirtY = stoneY + 2;
        int grassY = dirtY + 1;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int worldX = startX + x;
                int worldZ = startZ + z;
                for (int y = stoneY + 1; y <= dirtY; ++y) {
                    pos.set(worldX, y, worldZ);
                    chunk.setBlockState((BlockPos)pos, DIRT, false);
                }
                pos.set(worldX, grassY, worldZ);
                chunk.setBlockState((BlockPos)pos, GRASS_BLOCK, false);
            }
        }
    }

    public void spawnOriginalMobs(WorldGenRegion worldGenRegion) {
        super.spawnOriginalMobs(worldGenRegion);
    }

    public int getSeaLevel() {
        return -63;
    }

    public NoiseColumn getBaseColumn(int x, int z, LevelHeightAccessor level, RandomState randomState) {
        return new NoiseColumn(level.getMinBuildHeight(), new BlockState[0]);
    }

    public void addDebugScreenInfo(List<String> list, RandomState randomState, BlockPos pos) {
    }

    public int getMinY() {
        return -64;
    }

    public int getBaseHeight(int i, int i1, Heightmap.Types types, LevelHeightAccessor levelHeightAccessor, RandomState randomState) {
        int bedrockY = levelHeightAccessor.getMinBuildHeight();
        int stoneY = bedrockY + Config.stoneLayers;
        int dirtY = stoneY + 2;
        int grassY = dirtY + 1;
        return grassY + 1;
    }

    public int getGenDepth() {
        return 384;
    }

    @NotNull
    public CompletableFuture<ChunkAccess> fillFromNoise(Blender blender, RandomState randomState, StructureManager structureManager, ChunkAccess chunkAccess) {
        Climate.Sampler sampler = randomState.sampler();
        chunkAccess.fillBiomesFromNoise((BiomeResolver)this.getBiomeSource(), sampler);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int startX = chunkAccess.getPos().getMinBlockX();
        int startZ = chunkAccess.getPos().getMinBlockZ();
        int bedrockY = chunkAccess.getMinBuildHeight();
        int stoneY = bedrockY + Config.stoneLayers;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int worldX = startX + x;
                int worldZ = startZ + z;
                pos.set(worldX, bedrockY, worldZ);
                chunkAccess.setBlockState((BlockPos)pos, BEDROCK, false);
                for (int y = bedrockY + 1; y <= stoneY; ++y) {
                    pos.setY(y);
                    chunkAccess.setBlockState((BlockPos)pos, STONE, false);
                }
            }
        }
        return CompletableFuture.completedFuture(chunkAccess);
    }
}

