/*
 * Decompiled with CFR 0.152.
 */
package fr.mod.noise;

public class CellularNoise2D {
    private final long seed;

    public CellularNoise2D(long seed) {
        this.seed = seed;
    }

    private int hash(int x, int z) {
        long h = this.seed + (long)x * 374761393L + (long)z * 668265263L;
        h = (h ^ h >> 13) * 1274126177L;
        return (int)((h ^ h >> 16) & 0xFFL);
    }

    public double getNoise(double x, double z) {
        int ix = (int)Math.floor(x);
        int iz = (int)Math.floor(z);
        double minDistanceSq = Double.MAX_VALUE;
        int closestCellHash = 0;
        for (int dz = -1; dz <= 1; ++dz) {
            for (int dx = -1; dx <= 1; ++dx) {
                int hashValZ;
                double offsetZ;
                double pointZ;
                double vecZ;
                int cellX = ix + dx;
                int cellZ = iz + dz;
                int hashVal = this.hash(cellX, cellZ);
                double offsetX = (double)(hashVal & 0xFF) / 255.0;
                double pointX = (double)cellX + offsetX;
                double vecX = pointX - x;
                double distSq = vecX * vecX + (vecZ = (pointZ = (double)cellZ + (offsetZ = (double)((hashValZ = this.hash(cellX + 59, cellZ - 13)) & 0xFF) / 255.0)) - z) * vecZ;
                if (!(distSq < minDistanceSq)) continue;
                minDistanceSq = distSq;
                closestCellHash = hashVal;
            }
        }
        return (double)closestCellHash / 255.0;
    }
}

