/*
 * Decompiled with CFR 0.152.
 */
package fr.mod.worldgen;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fr.mod.Config;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeResolver;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.FeatureSorter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.blending.Blender;

public class OnelayerChunkGenerator
extends NoiseBasedChunkGenerator {
    public static final MapCodec<OnelayerChunkGenerator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BiomeSource.f_47888_.fieldOf("biome_source").forGetter(ChunkGenerator::m_62218_), (App)NoiseGeneratorSettings.f_64431_.fieldOf("settings").forGetter(NoiseBasedChunkGenerator::m_224341_)).apply((Applicative)instance, OnelayerChunkGenerator::new));
    private static final BlockState BEDROCK = Blocks.f_50752_.m_49966_();
    private static final BlockState STONE = Blocks.f_50069_.m_49966_();
    private static final BlockState DIRT = Blocks.f_50493_.m_49966_();
    private static final BlockState GRASS_BLOCK = Blocks.f_50440_.m_49966_();
    private final Function<Holder<Biome>, BiomeGenerationSettings> generationSettingsGetter = biome -> ((Biome)biome.m_203334_()).m_47536_();
    private final Supplier<List<FeatureSorter.StepFeatureData>> featuresPerStep = Suppliers.memoize(() -> FeatureSorter.m_220603_(List.copyOf(biomeSource.m_207840_()), biome -> ((Biome)biome.m_203334_()).m_47536_().m_47818_(), (boolean)true));

    public OnelayerChunkGenerator(BiomeSource biomeSource, Holder<NoiseGeneratorSettings> settings) {
        super(biomeSource, settings);
    }

    protected Codec<? extends ChunkGenerator> m_6909_() {
        return CODEC.codec();
    }

    public void m_213679_(WorldGenRegion worldGenRegion, long l, RandomState randomState, BiomeManager biomeManager, StructureManager structureManager, ChunkAccess chunkAccess, GenerationStep.Carving carving) {
    }

    public void m_214194_(WorldGenRegion region, StructureManager structureManager, RandomState randomState, ChunkAccess chunk) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int startX = chunk.m_7697_().m_45604_();
        int startZ = chunk.m_7697_().m_45605_();
        int bedrockY = region.m_141937_();
        int stoneY = bedrockY + Config.stoneLayers;
        int dirtY = stoneY + 2;
        int grassY = dirtY + 1;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int worldX = startX + x;
                int worldZ = startZ + z;
                pos.m_142451_(worldX);
                pos.m_142443_(worldZ);
                for (int y = stoneY + 1; y <= dirtY; ++y) {
                    pos.m_142448_(y);
                    chunk.m_6978_((BlockPos)pos, DIRT, false);
                }
                pos.m_142448_(grassY);
                chunk.m_6978_((BlockPos)pos, GRASS_BLOCK, false);
            }
        }
    }

    public void m_6929_(WorldGenRegion worldGenRegion) {
        super.m_6929_(worldGenRegion);
    }

    public int m_6337_() {
        return -63;
    }

    public NoiseColumn m_214184_(int x, int z, LevelHeightAccessor level, RandomState randomState) {
        return new NoiseColumn(level.m_141937_(), new BlockState[0]);
    }

    public void m_213600_(List<String> list, RandomState randomState, BlockPos pos) {
    }

    public int m_142062_() {
        return -64;
    }

    public int m_214096_(int i, int i1, Heightmap.Types types, LevelHeightAccessor levelHeightAccessor, RandomState randomState) {
        int bedrockY = levelHeightAccessor.m_141937_();
        int stoneY = bedrockY + Config.stoneLayers;
        int dirtY = stoneY + 2;
        int grassY = dirtY + 1;
        return grassY + 1;
    }

    public int m_6331_() {
        return 384;
    }

    public CompletableFuture<ChunkAccess> m_213974_(Executor executor, Blender blender, RandomState randomState, StructureManager structureManager, ChunkAccess chunkAccess) {
        Climate.Sampler sampler = randomState.m_224579_();
        chunkAccess.m_183442_((BiomeResolver)this.m_62218_(), sampler);
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int startX = chunkAccess.m_7697_().m_45604_();
        int startZ = chunkAccess.m_7697_().m_45605_();
        int bedrockY = chunkAccess.m_141937_();
        int stoneY = bedrockY + Config.stoneLayers;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int worldX = startX + x;
                int worldZ = startZ + z;
                pos.m_142451_(worldX);
                pos.m_142443_(worldZ);
                pos.m_142448_(bedrockY);
                chunkAccess.m_6978_((BlockPos)pos, BEDROCK, false);
                for (int y = bedrockY + 1; y <= stoneY; ++y) {
                    pos.m_142448_(y);
                    chunkAccess.m_6978_((BlockPos)pos, STONE, false);
                }
            }
        }
        return CompletableFuture.completedFuture(chunkAccess);
    }
}

