/*
 * Decompiled with CFR 0.152.
 */
package fr.mod.datagen;

import fr.mod.noise.CellularBiomeSource;
import fr.mod.worldgen.OnelayerChunkGenerator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.DimensionTypes;
import net.minecraft.data.worldgen.biome.BiomeData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.biome.MultiNoiseBiomeSourceParameterLists;
import net.minecraft.world.level.biome.TheEndBiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.presets.WorldPreset;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;

public class ModWorldGenPresetProvider
extends DatapackBuiltinEntriesProvider {
    private static final RegistrySetBuilder BUILDER = new RegistrySetBuilder().add(Registries.DIMENSION_TYPE, DimensionTypes::bootstrap).add(Registries.BIOME, BiomeData::bootstrap).add(Registries.NOISE_SETTINGS, NoiseGeneratorSettings::bootstrap).add(Registries.MULTI_NOISE_BIOME_SOURCE_PARAMETER_LIST, MultiNoiseBiomeSourceParameterLists::bootstrap).add(Registries.WORLD_PRESET, ModWorldGenPresetProvider::bootstrap);

    public ModWorldGenPresetProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries, BUILDER, Set.of("onelayer"));
    }

    private static void bootstrap(BootstrapContext<WorldPreset> context) {
        Holder.Reference overworldDimensionType = context.lookup(Registries.DIMENSION_TYPE).getOrThrow(BuiltinDimensionTypes.OVERWORLD);
        Holder.Reference netherDimensionType = context.lookup(Registries.DIMENSION_TYPE).getOrThrow(BuiltinDimensionTypes.NETHER);
        Holder.Reference endDimensionType = context.lookup(Registries.DIMENSION_TYPE).getOrThrow(BuiltinDimensionTypes.END);
        Holder.Reference overworldNoise = context.lookup(Registries.NOISE_SETTINGS).getOrThrow(NoiseGeneratorSettings.OVERWORLD);
        Holder.Reference netherNoise = context.lookup(Registries.NOISE_SETTINGS).getOrThrow(NoiseGeneratorSettings.NETHER);
        Holder.Reference endNoise = context.lookup(Registries.NOISE_SETTINGS).getOrThrow(NoiseGeneratorSettings.END);
        Holder.Reference netherBiomeParameters = context.lookup(Registries.MULTI_NOISE_BIOME_SOURCE_PARAMETER_LIST).getOrThrow(MultiNoiseBiomeSourceParameterLists.NETHER);
        MultiNoiseBiomeSource netherBiomeSource = MultiNoiseBiomeSource.createFromPreset((Holder)netherBiomeParameters);
        NoiseBasedChunkGenerator netherGenerator = new NoiseBasedChunkGenerator((BiomeSource)netherBiomeSource, (Holder)netherNoise);
        TheEndBiomeSource endBiomeSource = TheEndBiomeSource.create((HolderGetter)context.lookup(Registries.BIOME));
        NoiseBasedChunkGenerator endGenerator = new NoiseBasedChunkGenerator((BiomeSource)endBiomeSource, (Holder)endNoise);
        HolderSet.Named biomeList = context.lookup(Registries.BIOME).getOrThrow(BiomeTags.IS_OVERWORLD);
        CellularBiomeSource biomeSource = new CellularBiomeSource((HolderSet<Biome>)biomeList, 1L + (long)(Math.random() * 499.0), 0.02);
        OnelayerChunkGenerator ourChunkGenerator = new OnelayerChunkGenerator(biomeSource, (Holder<NoiseGeneratorSettings>)overworldNoise);
        LevelStem overworldStem = new LevelStem((Holder)overworldDimensionType, (ChunkGenerator)ourChunkGenerator);
        LevelStem netherStem = new LevelStem((Holder)netherDimensionType, (ChunkGenerator)netherGenerator);
        LevelStem endStem = new LevelStem((Holder)endDimensionType, (ChunkGenerator)endGenerator);
        context.register(ResourceKey.create((ResourceKey)Registries.WORLD_PRESET, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"onelayer", (String)"onelayer")), (Object)new WorldPreset(Map.of(LevelStem.OVERWORLD, overworldStem, LevelStem.NETHER, netherStem, LevelStem.END, endStem)));
    }
}

