/*
 * Decompiled with CFR 0.152.
 */
package fr.mod.noise;

import java.util.Random;

public class CellularNoise2D {
    private final int[] p = new int[512];

    public CellularNoise2D(long seed) {
        int i;
        int[] permutation = new int[256];
        for (int i2 = 0; i2 < 256; ++i2) {
            permutation[i2] = i2;
        }
        Random rand = new Random(seed);
        for (i = 255; i > 0; --i) {
            int j = rand.nextInt(i + 1);
            int temp = permutation[i];
            permutation[i] = permutation[j];
            permutation[j] = temp;
        }
        for (i = 0; i < 256; ++i) {
            int n = permutation[i];
            this.p[i + 256] = n;
            this.p[i] = n;
        }
    }

    public double getNoise(double x, double z) {
        int ix = (int)Math.floor(x);
        int iz = (int)Math.floor(z);
        double minDistanceSq = Double.MAX_VALUE;
        int closestCellHash = 0;
        for (int dz = -1; dz <= 1; ++dz) {
            for (int dx = -1; dx <= 1; ++dx) {
                int cellX = ix + dx;
                int cellX_masked = cellX & 0xFF;
                int cellZ = iz + dz;
                int cellZ_masked = cellZ & 0xFF;
                int hash = this.p[this.p[cellX_masked] + cellZ_masked] & 0xFF;
                double offsetX = (double)(this.p[hash] & 0xFF) / 255.0;
                double pointX = (double)cellX + offsetX;
                double vecX = pointX - x;
                double offsetZ = (double)(this.p[hash + 1] & 0xFF) / 255.0;
                double pointZ = (double)cellZ + offsetZ;
                double vecZ = pointZ - z;
                double distSq = vecX * vecX + vecZ * vecZ;
                if (!(distSq < minDistanceSq)) continue;
                minDistanceSq = distSq;
                closestCellHash = hash;
            }
        }
        return (double)closestCellHash / 255.0;
    }
}

