/*
 * Decompiled with CFR 0.152.
 */
package cn.thecoldworld.textfilereader;

import cn.thecoldworld.textfilereader.mod;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.Expose;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import org.jetbrains.annotations.NotNull;

public class FilePermissions {
    public static Files GlobalTextPermission = null;
    public static Files WorldTextPermission = null;

    @NotNull
    public static Files InitPermission(Path FilePath) throws IOException, JsonSyntaxException {
        Gson gson = new GsonBuilder().enableComplexMapKeySerialization().excludeFieldsWithoutExposeAnnotation().create();
        Files FP = (Files)gson.fromJson(String.join((CharSequence)"", java.nio.file.Files.readAllLines(FilePath)), Files.class);
        FP.FilePath = FilePath.toFile();
        FP.UpdateFile();
        return FP;
    }

    public static class Files {
        @Expose
        public List<File> Files;
        public transient java.io.File FilePath;

        public void UpdateFile() throws IOException {
            java.nio.file.Files.walk(this.FilePath.getParentFile().toPath(), Integer.MAX_VALUE, new FileVisitOption[0]).filter(x$0 -> java.nio.file.Files.isRegularFile(x$0, new LinkOption[0])).forEach(i -> {
                if (i.getFileName().toString().equals("permissions.json")) {
                    return;
                }
                if (this.Files.stream().anyMatch(m -> m.Name.equals(i.toFile().getName()))) {
                    return;
                }
                File fs = new File();
                fs.Name = i.toFile().getName();
                fs.Permissions = new ArrayList<Permissions>();
                mod.TickEvent.add(() -> this.Files.add(fs));
            });
        }

        public void UpToFile() throws IOException {
            Gson gson = new GsonBuilder().enableComplexMapKeySerialization().excludeFieldsWithoutExposeAnnotation().create();
            FileWriter fp = new FileWriter(this.FilePath, StandardCharsets.UTF_8, false);
            fp.write(gson.toJson((Object)this));
            fp.flush();
            fp.close();
        }

        public boolean RemovePermission(class_1297 ent, String FileName, boolean Online_Mode) {
            return this.Files.stream().filter(i -> i.Name.equals(FileName)).allMatch(file -> mod.TickEvent.add(() -> file.RemovePermission(ent, Online_Mode)));
        }

        public boolean GivePermission(@NotNull class_1297 ent, String FileName) throws Exception {
            if (!ent.method_31747()) {
                throw new Exception("Is not a Player");
            }
            return this.Files.stream().filter(i -> i.Name.equals(FileName)).findFirst().map(file -> file.GivePermission(ent)).orElse(false);
        }

        public boolean HavePermission(@NotNull class_1297 entity, String FileName, boolean Online_Mode) throws Exception {
            if (!entity.method_31747()) {
                throw new Exception("Is not a Player");
            }
            if (this.Files.stream().filter(i -> i.Name.equals(FileName)).map(i -> i.HavePermission(entity, Online_Mode)).findAny().isEmpty()) {
                return false;
            }
            return this.Files.stream().filter(i -> i.Name.equals(FileName)).allMatch(i -> i.HavePermission(entity, Online_Mode));
        }
    }

    public static class Permissions {
        @Expose
        public String Name;
        @Expose
        public String UUID;
    }

    public static class File {
        @Expose
        public String Name;
        @Expose
        public List<Permissions> Permissions;

        public boolean RemovePermission(class_1297 ent, boolean Online_Mode) {
            if (Online_Mode) {
                return this.Permissions.stream().filter(i -> i.UUID.equals(ent.method_5845())).allMatch(i -> mod.TickEvent.add(() -> this.Permissions.remove(i)));
            }
            return this.Permissions.stream().filter(i -> i.Name.equals(ent.method_5820())).allMatch(i -> mod.TickEvent.add(() -> this.Permissions.remove(i)));
        }

        public boolean GivePermission(@NotNull class_1297 ent) {
            Permissions p = new Permissions();
            p.Name = ent.method_5820();
            p.UUID = ent.method_5845();
            mod.TickEvent.add(() -> this.Permissions.add(p));
            return true;
        }

        public boolean HavePermission(class_1297 entity, boolean Online_Mode) {
            if (Online_Mode) {
                return this.Permissions.stream().map(i -> i.UUID.equals(entity.method_5845())).findAny().isPresent();
            }
            return this.Permissions.stream().map(i -> i.Name.equals(entity.method_5820())).findAny().isPresent();
        }
    }
}

