/*
 * Decompiled with CFR 0.152.
 */
package cn.thecoldworld.textfilereader;

import cn.thecoldworld.textfilereader.funcitons;
import cn.thecoldworld.textfilereader.variables;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.Expose;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1297;
import org.jetbrains.annotations.NotNull;

public class FilePermissions {
    public static Files GlobalTextPermission = null;
    public static Files WorldTextPermission = null;

    @NotNull
    public static Files InitPermission(Path FilePath) throws JsonSyntaxException {
        Files FP;
        block6: {
            if (!FilePath.toFile().exists() || !FilePath.toFile().isFile()) {
                try {
                    funcitons.CreateFile(FilePath.toFile(), "");
                }
                catch (Exception e) {
                    if (e.getMessage().equals("File exist")) break block6;
                    variables.Log.error("", (Throwable)e);
                }
            }
        }
        Gson gson = new GsonBuilder().enableComplexMapKeySerialization().excludeFieldsWithoutExposeAnnotation().create();
        try {
            FP = (Files)gson.fromJson(String.join((CharSequence)"", java.nio.file.Files.readAllLines(FilePath)), Files.class);
            if (FP == null) {
                FP = new Files();
            }
            FP.FilePath = FilePath.toFile();
            FP.UpdateFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return FP;
    }

    public static class Files {
        @Expose
        public final List<File> Files = new ArrayList<File>();
        public transient java.io.File FilePath;
        public boolean NeedUpdate = true;

        public void UpdateFile() throws IOException {
            java.nio.file.Files.walk(this.FilePath.getParentFile().toPath(), Integer.MAX_VALUE, new FileVisitOption[0]).filter(x$0 -> java.nio.file.Files.isRegularFile(x$0, new LinkOption[0])).forEach(i -> {
                if (i.getFileName().toString().equals("permissions.json")) {
                    return;
                }
                if (funcitons.GetFilePrefix(i.toFile()).equals("exe")) {
                    return;
                }
                if (this.Files.stream().anyMatch(m -> m.Name.equals(i.toFile().getName()))) {
                    return;
                }
                File fs = new File();
                fs.Name = i.toFile().getName();
                fs.Permissions = new ArrayList<Permissions>();
                variables.TickEvent.add(() -> {
                    this.Files.add(fs);
                    this.NeedUpdate = true;
                });
            });
            this.Files.forEach(i -> {
                if (!(Paths.get(this.FilePath.getParent(), i.Name).toFile().exists() && Paths.get(this.FilePath.getParent(), i.Name).toFile().isFile() || !variables.ModSettings.isRemoveInvalidFile())) {
                    variables.TickEvent.add(() -> {
                        this.Files.remove(i);
                        this.NeedUpdate = true;
                    });
                }
            });
        }

        public void UpToFile() throws IOException {
            if (!this.NeedUpdate) {
                return;
            }
            Gson gson = new GsonBuilder().enableComplexMapKeySerialization().excludeFieldsWithoutExposeAnnotation().create();
            FileWriter fp = new FileWriter(this.FilePath, StandardCharsets.UTF_8, false);
            fp.write(gson.toJson((Object)this));
            fp.flush();
            fp.close();
            this.NeedUpdate = false;
        }

        public boolean RemovePermission(class_1297 ent, String FileName, boolean Online_Mode) {
            return this.Files.stream().filter(i -> i.Name.equals(FileName)).allMatch(file -> variables.TickEvent.add(() -> file.RemovePermission(ent, Online_Mode, new SoftReference<Files>(this))));
        }

        public boolean GivePermission(@NotNull class_1297 ent, String FileName) throws Exception {
            if (!ent.method_31747()) {
                throw new Exception("Is not a Player");
            }
            return this.Files.stream().filter(i -> i.Name.equals(FileName)).findFirst().map(file -> file.GivePermission(ent, new SoftReference<Files>(this))).orElse(false);
        }

        public boolean HavePermission(@NotNull class_1297 entity, String FileName, boolean Online_Mode) throws Exception {
            if (!entity.method_31747()) {
                throw new Exception("Is not a Player");
            }
            if (this.Files.stream().filter(i -> i.Name.equals(FileName)).map(i -> i.HavePermission(entity, Online_Mode)).findAny().isEmpty()) {
                return false;
            }
            return this.Files.stream().filter(i -> i.Name.equals(FileName)).allMatch(i -> i.HavePermission(entity, Online_Mode));
        }
    }

    public static class Permissions {
        @Expose
        public String Name;
        @Expose
        public String UUID;
    }

    public static class File {
        @Expose
        public String Name;
        @Expose
        public List<Permissions> Permissions;

        public boolean RemovePermission(class_1297 ent, boolean Online_Mode, @NotNull Reference<Files> father) {
            if (Online_Mode) {
                return this.Permissions.stream().filter(i -> i.UUID.equals(ent.method_5845())).allMatch(i -> variables.TickEvent.add(() -> {
                    this.Permissions.remove(i);
                    Objects.requireNonNull((Files)father.get()).NeedUpdate = true;
                }));
            }
            return this.Permissions.stream().filter(i -> i.Name.equals(ent.method_5820())).allMatch(i -> variables.TickEvent.add(() -> {
                this.Permissions.remove(i);
                Objects.requireNonNull((Files)father.get()).NeedUpdate = true;
            }));
        }

        public boolean GivePermission(@NotNull class_1297 ent, @NotNull Reference<Files> father) {
            Permissions p = new Permissions();
            p.Name = ent.method_5820();
            p.UUID = ent.method_5845();
            variables.TickEvent.add(() -> {
                this.Permissions.add(p);
                Objects.requireNonNull((Files)father.get()).NeedUpdate = true;
            });
            return true;
        }

        public boolean HavePermission(class_1297 entity, boolean Online_Mode) {
            if (Online_Mode) {
                return this.Permissions.stream().map(i -> i.UUID.equals(entity.method_5845())).findAny().isPresent();
            }
            return this.Permissions.stream().map(i -> i.Name.equals(entity.method_5820())).findAny().isPresent();
        }
    }
}

