/*
 * Decompiled with CFR 0.152.
 */
package cn.thecoldworld.textfilereader;

import cn.thecoldworld.textfilereader.FileIO;
import cn.thecoldworld.textfilereader.variables;
import com.google.gson.annotations.SerializedName;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Objects;

public class Settings {
    public transient boolean NeedUpdate = true;
    private boolean RemoveInvalidFile;
    @SerializedName(value="Segmentedoutput")
    private boolean SegmentedOutput = false;
    private int Threads;

    public int getThreads() {
        return this.Threads;
    }

    public void setThreads(int threads) {
        this.Threads = threads;
        this.NeedUpdate = true;
    }

    public static Settings GetSettings() {
        if (!FileIO.ConfigPath.toFile().exists() || !FileIO.ConfigPath.toFile().isFile()) {
            return new Settings();
        }
        try {
            Settings set = (Settings)variables.defaultGson.fromJson(String.join((CharSequence)"", Files.readAllLines(FileIO.ConfigPath)), Settings.class);
            set.NeedUpdate = false;
            return Objects.requireNonNullElseGet(set, Settings::new);
        }
        catch (IOException e) {
            return new Settings();
        }
    }

    public void UptoFile() throws IOException {
        if (!this.NeedUpdate) {
            return;
        }
        variables.Log.debug(this.getClass().getCanonicalName() + "Updating");
        FileWriter fp = new FileWriter(FileIO.ConfigPath.toFile(), StandardCharsets.UTF_8, false);
        fp.write(variables.defaultGson.toJson((Object)this));
        fp.flush();
        fp.close();
        this.NeedUpdate = false;
    }

    public boolean isSegmentedOutput() {
        return this.SegmentedOutput;
    }

    public void setSegmentedOutput(boolean segmentedOutput) {
        this.SegmentedOutput = segmentedOutput;
        this.NeedUpdate = true;
    }

    public boolean isRemoveInvalidFile() {
        return this.RemoveInvalidFile;
    }

    public void setRemoveInvalidFile(boolean removeInvalidFile) {
        this.RemoveInvalidFile = removeInvalidFile;
        this.NeedUpdate = true;
    }
}

