/*
 * Decompiled with CFR 0.152.
 */
package cn.thecoldworld.textfilereader.client;

import cn.thecoldworld.textfilereader.FileIO;
import cn.thecoldworld.textfilereader.variables;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;

@Environment(value=EnvType.CLIENT)
public class Settings {
    public transient boolean NeedUpdate = true;
    private boolean GuiAutoUpdateFileList = false;
    private int LinesPerPage = 10;
    private boolean PauseGame;

    @Environment(value=EnvType.CLIENT)
    public static Settings GetSettings() {
        if (!FileIO.ClientConfigPath.toFile().exists() || !FileIO.ClientConfigPath.toFile().isFile()) {
            return new Settings();
        }
        try {
            Settings set = (Settings)variables.defaultGson.fromJson(String.join((CharSequence)"", Files.readAllLines(FileIO.ClientConfigPath)), Settings.class);
            return Objects.requireNonNullElseGet(set, Settings::new);
        }
        catch (IOException e) {
            return new Settings();
        }
    }

    public boolean isPauseGame() {
        return this.PauseGame;
    }

    public void setPauseGame(boolean pauseGame) {
        this.PauseGame = pauseGame;
    }

    public int getLinesPerPage() {
        return this.LinesPerPage;
    }

    public void setLinesPerPage(int linesPerPage) {
        this.LinesPerPage = linesPerPage;
        this.NeedUpdate = true;
    }

    public boolean isGuiAutoUpdateFileList() {
        return this.GuiAutoUpdateFileList;
    }

    public void setGuiAutoUpdateFileList(boolean guiAutoUpdateFileList) {
        this.GuiAutoUpdateFileList = guiAutoUpdateFileList;
        this.NeedUpdate = true;
    }

    public void UptoFile() throws IOException {
        if (!this.NeedUpdate) {
            return;
        }
        variables.Log.debug(this.getClass().getCanonicalName() + "Updating");
        FileWriter fp = new FileWriter(FileIO.ClientConfigPath.toFile(), StandardCharsets.UTF_8, false);
        fp.write(variables.defaultGson.toJson((Object)this));
        fp.flush();
        fp.close();
        this.NeedUpdate = false;
    }
}

