/*
 * Decompiled with CFR 0.152.
 */
package cn.thecoldworld.textfilereader.client;

import cn.thecoldworld.textfilereader.FileIO;
import cn.thecoldworld.textfilereader.FileSource;
import cn.thecoldworld.textfilereader.client.screen.TextGUI;
import cn.thecoldworld.textfilereader.funcitons;
import cn.thecoldworld.textfilereader.networking.ClientNetWorkingTask;
import cn.thecoldworld.textfilereader.networking.NetworkingFunctions;
import cn.thecoldworld.textfilereader.networking.jsonformats.C2SGetFileContent;
import cn.thecoldworld.textfilereader.networking.jsonformats.FailedContent;
import cn.thecoldworld.textfilereader.networking.jsonformats.NetworkPackageContent;
import cn.thecoldworld.textfilereader.networking.jsonformats.S2CGetFileContent;
import cn.thecoldworld.textfilereader.variables;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.nio.charset.StandardCharsets;
import java.nio.file.NoSuchFileException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class cFunctions {
    @Environment(value=EnvType.CLIENT)
    public static void RegisterNetworkReceivers(class_2960 ... NetworkingIdentifiers) {
        for (class_2960 i : NetworkingIdentifiers) {
            ClientPlayNetworking.registerGlobalReceiver((class_2960)i, (client2, handler, buf, responseSender) -> NetworkingFunctions.GetNetPackageCallback(client2, handler, buf, responseSender, i));
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static int GetFileFromServer(CommandContext<FabricClientCommandSource> context, FileSource fileSource) {
        try {
            ClientNetWorkingTask.Run((NetworkPackageContent)new C2SGetFileContent((String)context.getArgument("FileName", String.class), fileSource), variables.Identifiers.TextFileNetworkingIdentifier, List.of(arguments -> {
                try {
                    if (FailedContent.IsInstance(arguments.value.toString())) {
                        LinkedList<String> Keys = new LinkedList<String>(Arrays.stream(arguments.value.get("Reason").getAsString().split("\n")).toList());
                        String Key = Keys.get(0);
                        Keys.remove(0);
                        ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43469((String)Key, (Object[])Keys.toArray()));
                    }
                    if (!S2CGetFileContent.IsInstance(arguments.value.toString())) {
                        return;
                    }
                    ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)arguments.value.get("Value").getAsString()));
                }
                catch (Exception e) {
                    ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43469((String)"text.filereader.exception", (Object[])new Object[]{e.getClass().getCanonicalName(), e.getMessage()}));
                }
            }));
        }
        catch (Exception e) {
            ((FabricClientCommandSource)context.getSource()).sendError((class_2561)class_2561.method_43469((String)"text.filereader.exception", (Object[])new Object[]{e.getClass().getCanonicalName(), e.getMessage()}));
        }
        return 0;
    }

    public static void GetFileFromServer(String FileName, FileSource fileSource, TextGUI Screen) throws Exception {
        Screen.SetText((class_2561)class_2561.method_43471((String)"gui.textfilereader.read.wait"));
        ClientNetWorkingTask.Run((NetworkPackageContent)new C2SGetFileContent(FileName, fileSource), variables.Identifiers.TextFileNetworkingIdentifier, List.of(arguments -> {
            try {
                if (FailedContent.IsInstance(arguments.value.toString())) {
                    LinkedList<String> Keys = new LinkedList<String>(Arrays.stream(arguments.value.get("Reason").getAsString().split("\n")).toList());
                    String Key = Keys.get(0);
                    Keys.remove(0);
                    Screen.SetText((class_2561)class_2561.method_43469((String)Key, (Object[])new Object[]{Keys}));
                }
                if (!S2CGetFileContent.IsInstance(arguments.value.toString())) {
                    return;
                }
                String i = arguments.value.get("Value").getAsString();
                if (!i.contains("\n")) {
                    Screen.SetText(i);
                } else {
                    Scanner PageScanner = new Scanner(i);
                    LinkedList<String> Lines = new LinkedList<String>();
                    while (PageScanner.hasNextLine()) {
                        Lines.add(PageScanner.nextLine().replaceAll("[\n\r]", ""));
                    }
                    PageScanner.close();
                    if (Lines.isEmpty()) {
                        return;
                    }
                    if (Lines.size() <= variables.ClientModSettings.getLinesPerPage()) {
                        Screen.SetText(i);
                        return;
                    }
                    int Pages = funcitons.DivisibleUpwards(Lines.size(), variables.ClientModSettings.getLinesPerPage());
                    String[] pages = new String[Pages];
                    int EndRow = 0;
                    for (int k = 0; k < Pages; ++k) {
                        StringBuilder sb = new StringBuilder();
                        for (int j = 0; j < variables.ClientModSettings.getLinesPerPage() && EndRow < Lines.size(); ++j, ++EndRow) {
                            sb.append(((String)Lines.get(EndRow)).replace("\t", "    ")).append('\n');
                        }
                        pages[k] = sb.toString();
                    }
                    Screen.SetTextPage(pages);
                }
            }
            catch (Exception e) {
                Screen.SetText((class_2561)class_2561.method_43469((String)"text.filereader.exception", (Object[])new Object[]{e.getClass().getCanonicalName(), e.getMessage()}).method_27692(class_124.field_1061));
            }
        }));
    }

    @Environment(value=EnvType.CLIENT)
    public static int CGetFileContext(@NotNull CommandContext<FabricClientCommandSource> context) throws CommandSyntaxException {
        try {
            String Fileaddress = (String)context.getArgument("FileName", String.class);
            Scanner fp = new Scanner(Paths.get(FileIO.GlobalTextPath.toString(), Fileaddress), StandardCharsets.UTF_8);
            if (variables.ModSettings.isSegmentedOutput()) {
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43469((String)"text.filereader.printfile", (Object[])new Object[]{Fileaddress, ""}));
                while (fp.hasNext()) {
                    ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)fp.nextLine()));
                }
            } else {
                StringBuilder sb = new StringBuilder();
                while (fp.hasNext()) {
                    sb.append(fp.nextLine()).append('\n');
                }
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43469((String)"text.filereader.printfile", (Object[])new Object[]{Fileaddress, "\n" + sb}));
            }
            fp.close();
        }
        catch (NoSuchFileException fe) {
            throw new SimpleCommandExceptionType((Message)class_2561.method_43469((String)"text.filereader.filenotfound", (Object[])new Object[]{fe.getMessage()})).create();
        }
        catch (Exception ex) {
            throw new SimpleCommandExceptionType((Message)class_2561.method_43469((String)"text.filereader.exception", (Object[])new Object[]{ex.getClass().getCanonicalName(), ex.getMessage()})).create();
        }
        return 0;
    }
}

