/*
 * Decompiled with CFR 0.152.
 */
package cn.thecoldworld.textfilereader.client.screen;

import cn.thecoldworld.textfilereader.FileSource;
import cn.thecoldworld.textfilereader.client.cFunctions;
import cn.thecoldworld.textfilereader.client.screen.TextGUI;
import cn.thecoldworld.textfilereader.client.screen.widgets.FileListWidget;
import cn.thecoldworld.textfilereader.networking.ClientNetWorkingTask;
import cn.thecoldworld.textfilereader.networking.S2CArguments;
import cn.thecoldworld.textfilereader.networking.jsonformats.C2SGetFileList;
import cn.thecoldworld.textfilereader.networking.jsonformats.FailedContent;
import cn.thecoldworld.textfilereader.networking.jsonformats.NetworkPackageContent;
import cn.thecoldworld.textfilereader.networking.jsonformats.S2CGetFileList;
import cn.thecoldworld.textfilereader.variables;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public class MainGUI
extends class_437 {
    private final List<String> files;
    @NotNull
    private final class_437 prevScreen;
    private FileSource fileSource;
    private ScheduledFuture syncService;

    public MainGUI(@NotNull class_437 prevScreen) {
        super((class_2561)class_2561.method_43470((String)"Test"));
        this.prevScreen = prevScreen;
        this.fileSource = FileSource.global;
        this.files = new LinkedList<String>();
    }

    public boolean method_25421() {
        return false;
    }

    protected void method_25426() {
        FileListWidget widget = new FileListWidget(this.field_22787, this.field_22789, this.field_22790 / 3 * 2, 0, this.field_22790 - 25, 20, this.field_22793);
        class_4185 SwitchModeButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)(switch (this.fileSource) {
            default -> throw new IncompatibleClassChangeError();
            case FileSource.global -> "gui.filereader.main.switchbutton.global";
            case FileSource.save -> "gui.filereader.main.switchbutton.save";
            case FileSource.local -> "gui.filereader.main.switchbutton.local";
        })), button -> {
            switch (this.fileSource) {
                case save: {
                    this.UpdateFileList(FileSource.global);
                    break;
                }
                case global: {
                    this.UpdateFileList(FileSource.save);
                    break;
                }
                case local: {
                    this.UpdateFileList(FileSource.local);
                }
            }
        }).method_46434(this.field_22789 / 2 - 205, this.field_22790 - 25, 200, 20).method_46431();
        class_4185 ReadButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.filereader.main.readbutton"), button -> {
            try {
                if (widget.method_25334() == null) {
                    return;
                }
                TextGUI GUI = new TextGUI(this, this.field_22787, ((FileListWidget.Entry)widget.method_25334()).FileName);
                cFunctions.GetFileFromServer(((FileListWidget.Entry)widget.method_25334()).FileName, this.fileSource, GUI);
                this.field_22787.method_1507((class_437)GUI);
                this.field_22787.execute(GUI::method_41843);
            }
            catch (Exception e) {
                variables.Log.error("", (Throwable)e);
            }
        }).method_46434(this.field_22789 / 2, this.field_22790 - 25, 200, 20).method_46431();
        widget.AddChildren(this.files);
        this.method_37063((class_364)widget);
        this.method_37063((class_364)SwitchModeButton);
        this.method_37063((class_364)ReadButton);
    }

    public void UpdateFileList(FileSource fileSource) {
        this.fileSource = fileSource;
        this.SyncFiles();
        this.Reinit();
    }

    public void Reinit() {
        if (this.field_22787 == null) {
            return;
        }
        this.field_22787.execute(() -> this.method_41843());
    }

    public void method_49589() {
        super.method_49589();
        if (variables.ClientModSettings.isGuiAutoUpdateFileList()) {
            this.syncService = variables.scheduledExecutorService.scheduleAtFixedRate(this::SyncFiles, 100L, 10L, TimeUnit.SECONDS);
        }
        this.SyncFiles();
    }

    public void SyncFiles() {
        variables.scheduledExecutorService.schedule(() -> {
            JsonObject aReturn;
            try {
                aReturn = ((S2CArguments)ClientNetWorkingTask.Run((NetworkPackageContent)new C2SGetFileList((FileSource)this.fileSource), (class_2960)variables.Identifiers.TextFileListNetworkingIdentifier, (boolean)true).getAWaiter().GetResult()).value;
            }
            catch (NullPointerException e) {
                variables.Log.error("", (Throwable)e);
                return;
            }
            if (FailedContent.IsInstance(aReturn.toString())) {
                this.files.clear();
                LinkedList<String> Keys = new LinkedList<String>(Arrays.stream(aReturn.get("Reason").getAsString().split("\n")).toList());
                String Key = Keys.get(0);
                Keys.remove(0);
                this.files.add(class_2561.method_43469((String)Key, (Object[])new Object[]{Keys}).method_27692(class_124.field_1061).getString());
            } else {
                this.files.clear();
                if (S2CGetFileList.IsInstance(aReturn.toString())) {
                    List j = aReturn.get("files").getAsJsonArray().asList();
                    j.forEach(jx -> this.files.add(jx.getAsString()));
                } else {
                    this.files.add(class_2561.method_43470((String)"Error").method_27692(class_124.field_1061).getString());
                }
            }
            this.Reinit();
        }, 0L, TimeUnit.MICROSECONDS);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
    }

    public void method_25419() {
        this.field_22787.method_1507(this.prevScreen);
        if (variables.ClientModSettings.isGuiAutoUpdateFileList()) {
            this.syncService.cancel(true);
        }
    }
}

