/*
 * Decompiled with CFR 0.152.
 */
package cn.thecoldworld.textfilereader;

import cn.thecoldworld.textfilereader.FileIO;
import cn.thecoldworld.textfilereader.FilePermissions;
import cn.thecoldworld.textfilereader.FileSource;
import cn.thecoldworld.textfilereader.exceptions.TranslatableException;
import cn.thecoldworld.textfilereader.sender;
import cn.thecoldworld.textfilereader.variables;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Scanner;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class filereader {
    public static void Init(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"FileReader").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"Permission").requires(src -> src.method_9259(2))).then(class_2170.method_9247((String)"Clear").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"FileName", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9247((String)"Global").executes(i -> filereader.ClearFilePermission((CommandContext<class_2168>)i, FileSource.global)))).then(class_2170.method_9247((String)"Save").executes(i -> filereader.ClearFilePermission((CommandContext<class_2168>)i, FileSource.save)))))).then(class_2170.method_9247((String)"Get").then(class_2170.method_9244((String)"FileName", (ArgumentType)StringArgumentType.string()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"Player", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9247((String)"Global").executes(i -> filereader.GetPermission((CommandContext<class_2168>)i, FileSource.global)))).then(class_2170.method_9247((String)"Save").executes(i -> filereader.GetPermission((CommandContext<class_2168>)i, FileSource.save))))))).then(class_2170.method_9247((String)"Remove").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"FileName", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9247((String)"Save").executes(i -> filereader.RemovePermissionMyself((CommandContext<class_2168>)i, FileSource.save)))).then(class_2170.method_9247((String)"Global").executes(i -> filereader.RemovePermissionMyself((CommandContext<class_2168>)i, FileSource.global)))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"Player", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9247((String)"Save").executes(i -> filereader.RemovePermission((CommandContext<class_2168>)i, FileSource.save)))).then(class_2170.method_9247((String)"Global").executes(i -> filereader.RemovePermission((CommandContext<class_2168>)i, FileSource.global))))))).then(class_2170.method_9247((String)"Give").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"FileName", (ArgumentType)StringArgumentType.string()).then(class_2170.method_9247((String)"Save").executes(i -> filereader.GivePermissionMyself((CommandContext<class_2168>)i, FileSource.save)))).then(class_2170.method_9247((String)"Global").executes(i -> filereader.GivePermissionMyself((CommandContext<class_2168>)i, FileSource.global)))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"Player", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9247((String)"Save").executes(i -> filereader.GivePermission((CommandContext<class_2168>)i, FileSource.save)))).then(class_2170.method_9247((String)"Global").executes(i -> filereader.GivePermission((CommandContext<class_2168>)i, FileSource.global)))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"File").then(class_2170.method_9247((String)"Read").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"FileName", (ArgumentType)StringArgumentType.string()).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"Global").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"End_line", (ArgumentType)IntegerArgumentType.integer((int)1)).then(class_2170.method_9244((String)"Begin_line", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(i -> filereader.GetFileContextLines((CommandContext<class_2168>)i, FileSource.global, IntegerArgumentType.getInteger((CommandContext)i, (String)"End_line"), IntegerArgumentType.getInteger((CommandContext)i, (String)"Begin_line"), null)))).executes(i -> filereader.GetFileContextLines((CommandContext<class_2168>)i, FileSource.global, IntegerArgumentType.getInteger((CommandContext)i, (String)"End_line"), 1, null)))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"Player", (ArgumentType)class_2186.method_9305()).executes(i -> filereader.GetFileContext((CommandContext<class_2168>)i, FileSource.global, class_2186.method_9313((CommandContext)i, (String)"Player")))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"End_line", (ArgumentType)IntegerArgumentType.integer((int)1)).then(class_2170.method_9244((String)"Begin_line", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(i -> filereader.GetFileContextLines((CommandContext<class_2168>)i, FileSource.global, IntegerArgumentType.getInteger((CommandContext)i, (String)"End_line"), IntegerArgumentType.getInteger((CommandContext)i, (String)"Begin_line"), class_2186.method_9313((CommandContext)i, (String)"Player"))))).executes(i -> filereader.GetFileContextLines((CommandContext<class_2168>)i, FileSource.global, IntegerArgumentType.getInteger((CommandContext)i, (String)"End_line"), 1, class_2186.method_9313((CommandContext)i, (String)"Player")))))).executes(i -> filereader.GetFileContext((CommandContext<class_2168>)i, FileSource.global, null)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"Save").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"End_line", (ArgumentType)IntegerArgumentType.integer((int)1)).then(class_2170.method_9244((String)"Begin_line", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(i -> filereader.GetFileContextLines((CommandContext<class_2168>)i, FileSource.global, IntegerArgumentType.getInteger((CommandContext)i, (String)"End_line"), IntegerArgumentType.getInteger((CommandContext)i, (String)"Begin_line"), null)))).executes(i -> filereader.GetFileContextLines((CommandContext<class_2168>)i, FileSource.global, IntegerArgumentType.getInteger((CommandContext)i, (String)"End_line"), 1, null)))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"Player", (ArgumentType)class_2186.method_9305()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"End_line", (ArgumentType)IntegerArgumentType.integer((int)1)).then(class_2170.method_9244((String)"Begin_line", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(i -> filereader.GetFileContextLines((CommandContext<class_2168>)i, FileSource.save, IntegerArgumentType.getInteger((CommandContext)i, (String)"End_line"), IntegerArgumentType.getInteger((CommandContext)i, (String)"Begin_line"), class_2186.method_9313((CommandContext)i, (String)"Player"))))).executes(i -> filereader.GetFileContextLines((CommandContext<class_2168>)i, FileSource.save, IntegerArgumentType.getInteger((CommandContext)i, (String)"End_line"), 1, class_2186.method_9313((CommandContext)i, (String)"Player"))))).executes(i -> filereader.GetFileContext((CommandContext<class_2168>)i, FileSource.save, class_2186.method_9313((CommandContext)i, (String)"Player"))))).executes(i -> filereader.GetFileContext((CommandContext<class_2168>)i, FileSource.save, null)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"List").requires(src -> src.method_9259(2))).then(class_2170.method_9247((String)"Global").executes(i -> filereader.PrintFileList((CommandContext<class_2168>)i, FileSource.global)))).then(class_2170.method_9247((String)"Save").executes(i -> filereader.PrintFileList((CommandContext<class_2168>)i, FileSource.save)))))).executes(i -> {
            ((class_2168)i.getSource()).method_45068((class_2561)class_2561.method_43470((String)"TextFileReader"));
            ((class_2168)i.getSource()).method_45068((class_2561)class_2561.method_43471((String)"text.filereader.description"));
            return 0;
        }));
    }

    public static int PrintFileList(CommandContext<class_2168> context, FileSource fileSource) throws CommandSyntaxException {
        try {
            Path Path2 = fileSource == FileSource.save ? Paths.get(((class_2168)context.getSource()).method_9225().method_8503().method_27050(class_5218.field_24188).getParent().toString(), "Texts") : FileIO.GlobalTextPath;
            if (!Path2.toFile().exists() || !Path2.toFile().isDirectory()) {
                variables.Log.info("Missing server text data directory,starting crate");
                Files.createDirectory(Path2, new FileAttribute[0]);
            }
            if (variables.ModSettings.isSegmentedOutput()) {
                class_2168 src = (class_2168)context.getSource();
                CompletableFuture.supplyAsync(() -> {
                    src.method_45068((class_2561)class_2561.method_43469((String)"text.filereader.printcurrentpath", (Object[])new Object[]{""}));
                    try {
                        Files.walk(Path2, Integer.MAX_VALUE, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(i -> {
                            if (i.getFileName().toString().equals("permissions.json")) {
                                return;
                            }
                            src.method_45068((class_2561)class_2561.method_43470((String)i.getFileName().toString()));
                        });
                    }
                    catch (IOException e) {
                        variables.Log.error("", (Throwable)e);
                        src.method_9213((class_2561)class_2561.method_43469((String)"text.filereader.exception", (Object[])new Object[]{e.getClass().getCanonicalName(), e.getMessage()}));
                    }
                    return 0;
                });
            } else {
                StringBuilder sb = new StringBuilder();
                Files.walk(Path2, Integer.MAX_VALUE, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(i -> {
                    if (i.getFileName().toString().equals("permissions.json")) {
                        return;
                    }
                    sb.append(i.getFileName()).append("\n");
                });
                ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"text.filereader.printcurrentpath", (Object[])new Object[]{"\n" + sb}));
            }
            return 0;
        }
        catch (Exception ex) {
            throw new SimpleCommandExceptionType((Message)class_2561.method_43469((String)"text.filereader.exception", (Object[])new Object[]{ex.getClass().getCanonicalName(), ex.getMessage()})).create();
        }
    }

    public static List<String> GetFileList(MinecraftServer server, class_3222 player, FileSource fileSource) throws TranslatableException {
        FilePermissions.Files files = switch (fileSource) {
            default -> throw new IncompatibleClassChangeError();
            case FileSource.global -> FilePermissions.GlobalTextPermission;
            case FileSource.save -> FilePermissions.WorldTextPermission;
            case FileSource.local -> throw new TranslatableException("text.filereader.internalexception", new Object[0]);
        };
        LinkedList<String> FileList = new LinkedList<String>();
        files.Files.forEach(file -> {
            if (file.HavePermission((class_1297)player, server.method_3828())) {
                FileList.add(file.Name);
            }
        });
        return FileList;
    }

    public static int GetFileContextLines(CommandContext<class_2168> context, FileSource fileSource, int end, int start, @Nullable class_1297 ent) throws CommandSyntaxException {
        try {
            class_1297 entity;
            boolean self;
            String FileAddress;
            class_2168 source;
            block11: {
                if (end < start) {
                    throw new SimpleCommandExceptionType((Message)class_2561.method_43469((String)"text.filereader.printfile.wrongrange", (Object[])new Object[]{start, end})).create();
                }
                sender sender2 = filereader.GetSender(context);
                source = (class_2168)context.getSource();
                FileAddress = (String)context.getArgument("FileName", String.class);
                if (sender2 == sender.console) {
                    return filereader.PrintConsole(context, FileAddress, fileSource);
                }
                self = ent == null || ((class_2168)context.getSource()).method_9228() == ent;
                entity = ent == null ? source.method_9229() : ent;
                switch (fileSource) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case global: {
                        if (!FilePermissions.GlobalTextPermission.HavePermission(entity, FileAddress, source.method_9211().method_3828())) break;
                        break block11;
                    }
                    case save: {
                        if (!FilePermissions.WorldTextPermission.HavePermission(entity, FileAddress, source.method_9211().method_3828())) break;
                        break block11;
                    }
                    case local: {
                        throw new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"text.filereader.internalexception")).create();
                    }
                }
                if (self) {
                    throw new SimpleCommandExceptionType((Message)class_2561.method_43469((String)"text.filereader.printfile.nopermission", (Object[])new Object[]{FileAddress})).create();
                }
                throw new SimpleCommandExceptionType((Message)class_2561.method_43469((String)"text.filereader.printfile.others.nopermission", (Object[])new Object[]{ent.method_5820(), FileAddress})).create();
            }
            CompletableFuture.supplyAsync(() -> {
                try {
                    return FileIO.PrintFileLines(entity, (class_1937)source.method_9225(), FileAddress, fileSource, self, context, start, end);
                }
                catch (IOException e) {
                    variables.Log.error("", (Throwable)e);
                    ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43469((String)"text.filereader.exception", (Object[])new Object[]{e.getClass().getCanonicalName(), e.getMessage()}));
                    return -1;
                }
            });
            variables.Log.info("Command FileReader File Get from player " + entity.method_5820());
        }
        catch (CommandSyntaxException syntaxException) {
            throw syntaxException;
        }
        catch (Exception ex) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43469((String)"text.filereader.exception", (Object[])new Object[]{ex.getClass().getCanonicalName(), ex.getMessage()}));
            throw new SimpleCommandExceptionType((Message)class_2561.method_43470((String)ex.getMessage())).create();
        }
        return 0;
    }

    public static int ClearFilePermission(CommandContext<class_2168> context, FileSource fileSource) throws CommandSyntaxException {
        if (((class_2168)context.getSource()).method_44023() == null) {
            throw new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"text.filereader.invaidsender")).create();
        }
        String FileName = (String)context.getArgument("FileName", String.class);
        List<FilePermissions.File> files = switch (fileSource) {
            default -> throw new IncompatibleClassChangeError();
            case FileSource.global -> FilePermissions.GlobalTextPermission.Files;
            case FileSource.save -> FilePermissions.WorldTextPermission.Files;
            case FileSource.local -> throw new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"text.filereader.internalexception")).create();
        };
        if (files.isEmpty()) {
            throw new SimpleCommandExceptionType((Message)class_2561.method_43469((String)"text.filereader.filenotfound", (Object[])new Object[]{FileName})).create();
        }
        List<FilePermissions.File> files1 = files.stream().filter(i -> i.Name.equals(FileName)).toList();
        if (files1.isEmpty()) {
            throw new SimpleCommandExceptionType((Message)class_2561.method_43469((String)"text.filereader.filenotfound", (Object[])new Object[]{FileName})).create();
        }
        variables.TickEvent.add(() -> files1.forEach(i -> {
            i.Permissions.clear();
            switch (fileSource) {
                case global: {
                    FilePermissions.GlobalTextPermission.NeedUpdate = true;
                    break;
                }
                case save: {
                    FilePermissions.WorldTextPermission.NeedUpdate = true;
                }
            }
        }));
        variables.scheduledExecutorService.schedule(() -> {
            MinecraftServer server = ((class_2168)context.getSource()).method_9211();
            LinkedList<class_3222> OpEntitys = new LinkedList<class_3222>();
            for (String x : server.method_3760().method_14584()) {
                if (server.method_3760().method_14566(x) == null || Objects.equals(server.method_3760().method_14566(x), ((class_2168)context.getSource()).method_44023())) continue;
                OpEntitys.add(server.method_3760().method_14566(x));
            }
            OpEntitys.forEach(i -> i.method_7353((class_2561)class_2561.method_43469((String)"text.filereader.clearpermission.success.ops", (Object[])new Object[]{((class_2168)context.getSource()).method_44023().method_5477(), FileName}).method_27692(class_124.field_1080).method_27692(class_124.field_1056), false));
            variables.Log.info(class_2561.method_43469((String)"text.filereader.clearpermission.success.ops", (Object[])new Object[]{((class_2168)context.getSource()).method_44023().method_5477(), FileName}).getString());
        }, 0L, TimeUnit.MICROSECONDS);
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"text.filereader.clearpermission.success", (Object[])new Object[]{FileName}));
        return 0;
    }

    public static int GetFileContext(CommandContext<class_2168> context, FileSource fileSource, @Nullable class_1297 ent) throws CommandSyntaxException {
        try {
            class_1297 entity;
            boolean self;
            String FileAddress;
            class_2168 source;
            block10: {
                sender sender2 = filereader.GetSender(context);
                source = (class_2168)context.getSource();
                FileAddress = (String)context.getArgument("FileName", String.class);
                if (sender2 == sender.console) {
                    variables.Log.info("Command FileReader File Get from server console");
                    return filereader.PrintConsole(context, FileAddress, fileSource);
                }
                self = ent == null || ((class_2168)context.getSource()).method_9228() == ent;
                entity = ent == null ? source.method_9229() : ent;
                switch (fileSource) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case global: {
                        if (!FilePermissions.GlobalTextPermission.HavePermission(entity, FileAddress, source.method_9211().method_3828())) break;
                        break block10;
                    }
                    case save: {
                        if (!FilePermissions.WorldTextPermission.HavePermission(entity, FileAddress, source.method_9211().method_3828())) break;
                        break block10;
                    }
                    case local: {
                        throw new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"text.filereader.internalexception")).create();
                    }
                }
                if (self) {
                    throw new SimpleCommandExceptionType((Message)class_2561.method_43469((String)"text.filereader.printfile.nopermission", (Object[])new Object[]{FileAddress})).create();
                }
                throw new SimpleCommandExceptionType((Message)class_2561.method_43469((String)"text.filereader.printfile.others.nopermission", (Object[])new Object[]{ent.method_5820(), FileAddress})).create();
            }
            CompletableFuture.supplyAsync(() -> {
                try {
                    return FileIO.PrintFile(entity, (class_1937)source.method_9225(), FileAddress, fileSource, self, context);
                }
                catch (IOException e) {
                    variables.Log.error("", (Throwable)e);
                    ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43469((String)"text.filereader.exception", (Object[])new Object[]{e.getClass().getCanonicalName(), e.getMessage()}));
                    return -1;
                }
            });
            variables.Log.info("Command FileReader File Get from player " + entity.method_5820());
            return 0;
        }
        catch (CommandSyntaxException syntaxException) {
            throw syntaxException;
        }
        catch (Exception ex) {
            ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43469((String)"text.filereader.exception", (Object[])new Object[]{ex.getClass().getCanonicalName(), ex.getMessage()}));
            throw new SimpleCommandExceptionType((Message)class_2561.method_43470((String)ex.getMessage())).create();
        }
    }

    public static int PrintConsole(CommandContext<class_2168> context, String FileName, FileSource fileSource) throws CommandSyntaxException {
        try {
            Scanner fp = switch (fileSource) {
                default -> throw new IncompatibleClassChangeError();
                case FileSource.save -> new Scanner(Paths.get(((class_2168)context.getSource()).method_9225().method_8503().method_27050(class_5218.field_24188).getParent().toString(), FileName), StandardCharsets.UTF_8);
                case FileSource.global -> new Scanner(Paths.get(FileIO.GlobalTextPath.toString(), FileName), StandardCharsets.UTF_8);
                case FileSource.local -> throw new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"text.filereader.internalexception")).create();
            };
            if (variables.ModSettings.isSegmentedOutput()) {
                variables.Log.info(class_2561.method_43469((String)"text.filereader.printfile", (Object[])new Object[]{FileName, ""}).method_10858(100));
                while (fp.hasNext()) {
                    variables.Log.info(fp.nextLine());
                }
            } else {
                StringBuilder sb = new StringBuilder();
                while (fp.hasNext()) {
                    sb.append(fp.nextLine()).append('\n');
                }
                variables.Log.info(class_2561.method_43469((String)"text.filereader.printfile", (Object[])new Object[]{FileName, "\n" + sb}).method_10858(sb.length() + 100));
            }
            fp.close();
            return 0;
        }
        catch (Exception e) {
            throw new SimpleCommandExceptionType((Message)class_2561.method_43469((String)"text.filereader.exception", (Object[])new Object[]{e.getClass().getCanonicalName(), e.getMessage()})).create();
        }
    }

    public static int GivePermissionMyself(CommandContext<class_2168> context, FileSource fs) throws CommandSyntaxException {
        filereader.GetSender(context);
        try {
            if (fs == FileSource.save) {
                if (!Files.exists(Paths.get(((class_2168)context.getSource()).method_9211().method_27050(class_5218.field_24188).getParent().toAbsolutePath().normalize().toString(), "Texts", (String)context.getArgument("FileName", String.class)).toAbsolutePath().normalize(), new LinkOption[0]) || !Paths.get(((class_2168)context.getSource()).method_9211().method_27050(class_5218.field_24188).getParent().toAbsolutePath().normalize().toString(), "Texts", (String)context.getArgument("FileName", String.class)).toAbsolutePath().normalize().toFile().isFile()) {
                    throw new SimpleCommandExceptionType((Message)class_2561.method_43469((String)"text.filereader.permission.fail.invaidfile", (Object[])new Object[]{context.getArgument("FileName", String.class)})).create();
                }
                FilePermissions.WorldTextPermission.GivePermission(((class_2168)context.getSource()).method_9229(), (String)context.getArgument("FileName", String.class));
            } else if (fs == FileSource.global) {
                if (!Files.exists(Paths.get(FileIO.GlobalTextPath.toAbsolutePath().normalize().toString(), (String)context.getArgument("FileName", String.class)).toAbsolutePath().normalize(), new LinkOption[0]) || !Paths.get(FileIO.GlobalTextPath.toAbsolutePath().normalize().toString(), (String)context.getArgument("FileName", String.class)).toAbsolutePath().normalize().toFile().isFile()) {
                    throw new SimpleCommandExceptionType((Message)class_2561.method_43469((String)"text.filereader.permission.fail.invaidfile", (Object[])new Object[]{context.getArgument("FileName", String.class)})).create();
                }
                FilePermissions.GlobalTextPermission.GivePermission(((class_2168)context.getSource()).method_9229(), (String)context.getArgument("FileName", String.class));
            }
        }
        catch (CommandSyntaxException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new SimpleCommandExceptionType((Message)class_2561.method_43469((String)"text.filereader.exception", (Object[])new Object[]{e.getClass().getCanonicalName(), e.getMessage()})).create();
        }
        variables.scheduledExecutorService.schedule(() -> {
            MinecraftServer server = ((class_2168)context.getSource()).method_9211();
            LinkedList<class_3222> OpEntitys = new LinkedList<class_3222>();
            for (String x : server.method_3760().method_14584()) {
                if (server.method_3760().method_14566(x) == null) continue;
                OpEntitys.add(server.method_3760().method_14566(x));
            }
            OpEntitys.forEach(i -> i.method_7353((class_2561)class_2561.method_43469((String)"text.filereader.permission.success.give.ops", (Object[])new Object[]{((class_2168)context.getSource()).method_9228().method_5820(), ((class_2168)context.getSource()).method_9228().method_5820(), context.getArgument("FileName", String.class)}).method_27692(class_124.field_1080).method_27692(class_124.field_1056), false));
            variables.Log.info(class_2561.method_43469((String)"text.filereader.permission.success.give.ops", (Object[])new Object[]{((class_2168)context.getSource()).method_9228().method_5820(), ((class_2168)context.getSource()).method_9228().method_5820(), context.getArgument("FileName", String.class)}).getString());
        }, 0L, TimeUnit.MICROSECONDS);
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"text.filereader.permission.success.give", (Object[])new Object[]{context.getArgument("FileName", String.class), ((class_2168)context.getSource()).method_9229().method_5820()}));
        return 0;
    }

    public static int GivePermission(CommandContext<class_2168> context, FileSource fs) throws CommandSyntaxException {
        filereader.GetSender(context);
        try {
            if (fs == FileSource.save) {
                if (!Files.exists(Paths.get(((class_2168)context.getSource()).method_9211().method_27050(class_5218.field_24188).getParent().toAbsolutePath().normalize().toString(), "Texts", (String)context.getArgument("FileName", String.class)).toAbsolutePath().normalize(), new LinkOption[0]) || !Paths.get(((class_2168)context.getSource()).method_9211().method_27050(class_5218.field_24188).getParent().toAbsolutePath().normalize().toString(), "Texts", (String)context.getArgument("FileName", String.class)).toAbsolutePath().normalize().toFile().isFile()) {
                    throw new SimpleCommandExceptionType((Message)class_2561.method_43469((String)"text.filereader.permission.fail.invaidfile", (Object[])new Object[]{context.getArgument("FileName", String.class)})).create();
                }
                class_2186.method_9317(context, (String)"Player").forEach(i -> {
                    try {
                        FilePermissions.WorldTextPermission.GivePermission((class_1297)i, (String)context.getArgument("FileName", String.class));
                    }
                    catch (Exception e) {
                        variables.Log.error("", (Throwable)e);
                    }
                });
            } else if (fs == FileSource.global) {
                if (!Files.exists(Paths.get(FileIO.GlobalTextPath.toAbsolutePath().normalize().toString(), (String)context.getArgument("FileName", String.class)).toAbsolutePath().normalize(), new LinkOption[0]) || !Paths.get(FileIO.GlobalTextPath.toAbsolutePath().normalize().toString(), (String)context.getArgument("FileName", String.class)).toAbsolutePath().normalize().toFile().isFile()) {
                    throw new SimpleCommandExceptionType((Message)class_2561.method_43469((String)"text.filereader.permission.fail.invaidfile", (Object[])new Object[]{context.getArgument("FileName", String.class)})).create();
                }
                class_2186.method_9317(context, (String)"Player").forEach(i -> {
                    try {
                        FilePermissions.GlobalTextPermission.GivePermission((class_1297)i, (String)context.getArgument("FileName", String.class));
                    }
                    catch (Exception e) {
                        variables.Log.error("", (Throwable)e);
                    }
                });
            }
        }
        catch (CommandSyntaxException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new SimpleCommandExceptionType((Message)class_2561.method_43469((String)"text.filereader.exception", (Object[])new Object[]{e.getClass().getCanonicalName(), e.getMessage()})).create();
        }
        StringBuilder sb = new StringBuilder();
        class_2186.method_9317(context, (String)"Player").forEach(i -> sb.append(i.method_5820()).append(','));
        variables.scheduledExecutorService.schedule(() -> {
            MinecraftServer server = ((class_2168)context.getSource()).method_9211();
            LinkedList<class_3222> OpEntitys = new LinkedList<class_3222>();
            for (String x : server.method_3760().method_14584()) {
                if (server.method_3760().method_14566(x) == null) continue;
                OpEntitys.add(server.method_3760().method_14566(x));
            }
            try {
                sender se = filereader.GetSender(context);
                if (se == sender.player) {
                    OpEntitys.forEach(i -> i.method_7353((class_2561)class_2561.method_43469((String)"text.filereader.permission.success.give.ops", (Object[])new Object[]{((class_2168)context.getSource()).method_9228().method_5820(), sb, context.getArgument("FileName", String.class)}).method_27692(class_124.field_1080).method_27692(class_124.field_1056), false));
                    variables.Log.info(class_2561.method_43469((String)"text.filereader.permission.success.give.ops", (Object[])new Object[]{((class_2168)context.getSource()).method_9228().method_5820(), sb, context.getArgument("FileName", String.class)}).getString());
                } else if (se == sender.console) {
                    OpEntitys.forEach(i -> i.method_7353((class_2561)class_2561.method_43469((String)"text.filereader.permission.success.give.ops", (Object[])new Object[]{"\u00a77Server", sb, context.getArgument("FileName", String.class)}), false));
                } else {
                    variables.Log.error("Internal error");
                }
            }
            catch (CommandSyntaxException e) {
                variables.Log.error("", (Throwable)e);
            }
        }, 0L, TimeUnit.MICROSECONDS);
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"text.filereader.permission.success.give", (Object[])new Object[]{context.getArgument("FileName", String.class), sb.toString()}));
        return 0;
    }

    public static int RemovePermissionMyself(CommandContext<class_2168> context, FileSource fs) throws CommandSyntaxException {
        filereader.GetSender(context);
        try {
            if (fs == FileSource.save) {
                if (!Files.exists(Paths.get(((class_2168)context.getSource()).method_9211().method_27050(class_5218.field_24188).getParent().toAbsolutePath().normalize().toString(), "Texts", (String)context.getArgument("FileName", String.class)).toAbsolutePath().normalize(), new LinkOption[0]) || !Paths.get(((class_2168)context.getSource()).method_9211().method_27050(class_5218.field_24188).getParent().toAbsolutePath().normalize().toString(), "Texts", (String)context.getArgument("FileName", String.class)).toAbsolutePath().normalize().toFile().isFile()) {
                    throw new SimpleCommandExceptionType((Message)class_2561.method_43469((String)"text.filereader.permission.fail.invaidfile", (Object[])new Object[]{context.getArgument("FileName", String.class)})).create();
                }
                FilePermissions.WorldTextPermission.RemovePermission(((class_2168)context.getSource()).method_9229(), (String)context.getArgument("FileName", String.class), ((class_2168)context.getSource()).method_9211().method_3828());
            } else if (fs == FileSource.global) {
                FilePermissions.GlobalTextPermission.RemovePermission(((class_2168)context.getSource()).method_9229(), (String)context.getArgument("FileName", String.class), ((class_2168)context.getSource()).method_9211().method_3828());
            }
        }
        catch (CommandSyntaxException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new SimpleCommandExceptionType((Message)class_2561.method_43469((String)"text.filereader.exception", (Object[])new Object[]{e.getClass().getCanonicalName(), e.getMessage()})).create();
        }
        variables.scheduledExecutorService.schedule(() -> {
            MinecraftServer server = ((class_2168)context.getSource()).method_9211();
            LinkedList<class_3222> OpEntitys = new LinkedList<class_3222>();
            for (String x : server.method_3760().method_14584()) {
                if (server.method_3760().method_14566(x) == null) continue;
                OpEntitys.add(server.method_3760().method_14566(x));
            }
            OpEntitys.forEach(i -> i.method_7353((class_2561)class_2561.method_43469((String)"text.filereader.permission.success.remove.ops", (Object[])new Object[]{((class_2168)context.getSource()).method_9228().method_5820(), ((class_2168)context.getSource()).method_9228().method_5820(), context.getArgument("FileName", String.class)}).method_27692(class_124.field_1080).method_27692(class_124.field_1056), false));
            variables.Log.info(class_2561.method_43469((String)"text.filereader.permission.success.remove.ops", (Object[])new Object[]{((class_2168)context.getSource()).method_9228().method_5820(), ((class_2168)context.getSource()).method_9228().method_5820(), context.getArgument("FileName", String.class)}).getString());
        }, 0L, TimeUnit.MICROSECONDS);
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"text.filereader.permission.success.remove", (Object[])new Object[]{context.getArgument("FileName", String.class), ((class_2168)context.getSource()).method_9229().method_5820()}));
        return 0;
    }

    public static int RemovePermission(CommandContext<class_2168> context, FileSource fs) throws CommandSyntaxException {
        filereader.GetSender(context);
        try {
            if (fs == FileSource.save) {
                if (!Files.exists(Paths.get(((class_2168)context.getSource()).method_9211().method_27050(class_5218.field_24188).getParent().toAbsolutePath().normalize().toString(), "Texts", (String)context.getArgument("FileName", String.class)).toAbsolutePath().normalize(), new LinkOption[0]) || !Paths.get(((class_2168)context.getSource()).method_9211().method_27050(class_5218.field_24188).getParent().toAbsolutePath().normalize().toString(), "Texts", (String)context.getArgument("FileName", String.class)).toAbsolutePath().normalize().toFile().isFile()) {
                    throw new SimpleCommandExceptionType((Message)class_2561.method_43469((String)"text.filereader.permission.fail.invaidfile", (Object[])new Object[]{context.getArgument("FileName", String.class)})).create();
                }
                class_2186.method_9317(context, (String)"Player").forEach(i -> {
                    try {
                        FilePermissions.WorldTextPermission.RemovePermission((class_1297)i, (String)context.getArgument("FileName", String.class), ((class_2168)context.getSource()).method_9211().method_3828());
                    }
                    catch (Exception e) {
                        variables.Log.error("", (Throwable)e);
                    }
                });
            }
            if (fs == FileSource.global) {
                if (!Files.exists(Paths.get(FileIO.GlobalTextPath.toAbsolutePath().normalize().toString(), (String)context.getArgument("FileName", String.class)).toAbsolutePath().normalize(), new LinkOption[0]) || !Paths.get(FileIO.GlobalTextPath.toAbsolutePath().normalize().toString(), (String)context.getArgument("FileName", String.class)).toAbsolutePath().normalize().toFile().isFile()) {
                    throw new SimpleCommandExceptionType((Message)class_2561.method_43469((String)"text.filereader.permission.fail.invaidfile", (Object[])new Object[]{context.getArgument("FileName", String.class)})).create();
                }
                class_2186.method_9317(context, (String)"Player").forEach(i -> {
                    try {
                        FilePermissions.GlobalTextPermission.RemovePermission((class_1297)i, (String)context.getArgument("FileName", String.class), ((class_2168)context.getSource()).method_9211().method_3828());
                    }
                    catch (Exception e) {
                        variables.Log.error("", (Throwable)e);
                    }
                });
            }
        }
        catch (CommandSyntaxException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new SimpleCommandExceptionType((Message)class_2561.method_43469((String)"text.filereader.exception", (Object[])new Object[]{e.getClass().getCanonicalName(), e.getMessage()})).create();
        }
        StringBuilder sb = new StringBuilder();
        class_2186.method_9317(context, (String)"Player").forEach(i -> sb.append(i.method_5820()).append(','));
        variables.scheduledExecutorService.schedule(() -> {
            MinecraftServer server = ((class_2168)context.getSource()).method_9211();
            LinkedList<class_3222> OpEntitys = new LinkedList<class_3222>();
            for (String x : server.method_3760().method_14584()) {
                if (server.method_3760().method_14566(x) == null) continue;
                OpEntitys.add(server.method_3760().method_14566(x));
            }
            try {
                sender se = filereader.GetSender(context);
                if (se == sender.player) {
                    OpEntitys.forEach(i -> i.method_7353((class_2561)class_2561.method_43469((String)"text.filereader.permission.success.remove.ops", (Object[])new Object[]{((class_2168)context.getSource()).method_9228().method_5820(), sb, context.getArgument("FileName", String.class)}), false));
                    variables.Log.info(class_2561.method_43469((String)"text.filereader.permission.success.remove.ops", (Object[])new Object[]{((class_2168)context.getSource()).method_9228().method_5820(), sb, context.getArgument("FileName", String.class)}).getString().replaceAll("\u00a77", ""));
                } else if (se == sender.console) {
                    OpEntitys.forEach(i -> i.method_7353((class_2561)class_2561.method_43469((String)"text.filereader.permission.success.remove.ops", (Object[])new Object[]{"\u00a77Server", sb, context.getArgument("FileName", String.class)}), false));
                } else {
                    variables.Log.error("internal error");
                }
            }
            catch (CommandSyntaxException e) {
                variables.Log.error("", (Throwable)e);
            }
        }, 0L, TimeUnit.MICROSECONDS);
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"text.filereader.permission.success.remove", (Object[])new Object[]{context.getArgument("FileName", String.class), sb.toString()}));
        return 0;
    }

    public static int GetPermission(CommandContext<class_2168> context, FileSource fileSource) throws CommandSyntaxException {
        block9: {
            class_1297 entity = class_2186.method_9313(context, (String)"Player");
            String FileName = (String)context.getArgument("FileName", String.class);
            try {
                if (fileSource == FileSource.save) {
                    if (FilePermissions.WorldTextPermission.HavePermission(entity, FileName, ((class_2168)context.getSource()).method_9211().method_3828())) {
                        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"text.filereader.permission.get.yes", (Object[])new Object[]{entity.method_5820(), FileName}));
                    } else {
                        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"text.filereader.permission.get.no", (Object[])new Object[]{entity.method_5820(), FileName}));
                    }
                    break block9;
                }
                if (fileSource == FileSource.global) {
                    if (FilePermissions.GlobalTextPermission.HavePermission(entity, FileName, ((class_2168)context.getSource()).method_9211().method_3828())) {
                        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"text.filereader.permission.get.yes", (Object[])new Object[]{entity.method_5820(), FileName}));
                    } else {
                        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"text.filereader.permission.get.no", (Object[])new Object[]{entity.method_5820(), FileName}));
                    }
                    break block9;
                }
                variables.Log.error("Internal Errer");
                throw new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"text.filereader.internalexception")).create();
            }
            catch (CommandSyntaxException e) {
                throw e;
            }
            catch (Exception ex) {
                throw new SimpleCommandExceptionType((Message)class_2561.method_43469((String)"text.filereader.exception", (Object[])new Object[]{ex.getClass().getCanonicalName(), ex.getMessage()})).create();
            }
        }
        return 0;
    }

    public static boolean HavePermission(class_3222 player, String FileName, FileSource fileSource) {
        boolean Online_Mode = player.method_5682() == null ? false : player.method_5682().method_3828();
        try {
            return switch (fileSource) {
                default -> throw new IncompatibleClassChangeError();
                case FileSource.global -> FilePermissions.GlobalTextPermission.HavePermission((class_1297)player, FileName, Online_Mode);
                case FileSource.save -> FilePermissions.WorldTextPermission.HavePermission((class_1297)player, FileName, Online_Mode);
                case FileSource.local -> throw new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"text.filereader.internalexception")).create();
            };
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static sender GetSender(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_1297 sender2 = source.method_9228();
        if (sender2 == null) {
            if (source.method_9214().equals("Server")) {
                return sender.console;
            }
            throw new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"text.filereader.invaidsender")).create();
        }
        source.method_9229();
        return sender.player;
    }
}

