/*
 * Decompiled with CFR 0.152.
 */
package cn.thecoldworld.textfilereader.networking;

import cn.thecoldworld.textfilereader.FileIO;
import cn.thecoldworld.textfilereader.FileSource;
import cn.thecoldworld.textfilereader.exceptions.TranslatableException;
import cn.thecoldworld.textfilereader.filereader;
import cn.thecoldworld.textfilereader.funcitons;
import cn.thecoldworld.textfilereader.networking.C2SArguments;
import cn.thecoldworld.textfilereader.networking.ClientNetWorkingTask;
import cn.thecoldworld.textfilereader.networking.Events;
import cn.thecoldworld.textfilereader.networking.ResponseNetworkPackage;
import cn.thecoldworld.textfilereader.networking.S2CArguments;
import cn.thecoldworld.textfilereader.networking.SendNetworkPackage;
import cn.thecoldworld.textfilereader.networking.ServerNetWorkingTask;
import cn.thecoldworld.textfilereader.networking.jsonformats.C2SGetFileContent;
import cn.thecoldworld.textfilereader.networking.jsonformats.C2SGetFileList;
import cn.thecoldworld.textfilereader.networking.jsonformats.FailedContent;
import cn.thecoldworld.textfilereader.networking.jsonformats.S2CGetFileContent;
import cn.thecoldworld.textfilereader.networking.jsonformats.S2CGetFileList;
import cn.thecoldworld.textfilereader.variables;
import com.google.gson.JsonObject;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_634;
import net.minecraft.server.MinecraftServer;

public abstract class NetworkingFunctions {
    public static void OnReceiveSedPackage(MinecraftServer server, class_3222 player, class_2960 identifier, SendNetworkPackage sendNetworkPackage) {
        if (!sendNetworkPackage.NeedResponse) {
            return;
        }
        if (identifier.equals((Object)variables.Identifiers.DebugFileIdentifier)) {
            JsonObject object = new JsonObject();
            object.addProperty("tmp", "ads");
            ServerNetWorkingTask.Run(object, sendNetworkPackage.ID, player, variables.Identifiers.DebugFileIdentifier);
        }
        if (identifier.equals((Object)variables.Identifiers.TextFileListNetworkingIdentifier) && C2SGetFileList.IsInstance(sendNetworkPackage.Body.toString())) {
            try {
                List<String> _Files = filereader.GetFileList(server, player, new C2SGetFileList(sendNetworkPackage.Body).GetFileSource());
                ServerNetWorkingTask.Run(new S2CGetFileList(_Files).ToJsonObject(), sendNetworkPackage.ID, player, variables.Identifiers.TextFileListNetworkingIdentifier);
            }
            catch (TranslatableException tre) {
                ServerNetWorkingTask.Run(new FailedContent(tre.TranslateKey).ToJsonObject(), sendNetworkPackage.ID, player, variables.Identifiers.TextFileListNetworkingIdentifier);
            }
            catch (Exception e) {
                ServerNetWorkingTask.Run(new FailedContent("text.filereader.exception", e.getClass().getCanonicalName(), e.getMessage()).ToJsonObject(), sendNetworkPackage.ID, player, variables.Identifiers.TextFileListNetworkingIdentifier);
            }
        }
        if (identifier.equals((Object)variables.Identifiers.TextFileNetworkingIdentifier)) {
            try {
                if (C2SGetFileContent.IsInstance(sendNetworkPackage.Body.toString())) {
                    String fileName = sendNetworkPackage.Body.get("FileName").getAsString();
                    FileSource fileSource = switch (sendNetworkPackage.Body.get("ListFileSource").getAsString().toLowerCase()) {
                        case "global" -> FileSource.global;
                        case "save" -> FileSource.save;
                        default -> throw new IllegalStateException("Unexpected value: " + sendNetworkPackage.Body.get("ListFileSource").getAsString().toLowerCase());
                    };
                    if (filereader.HavePermission(player, fileName, fileSource)) {
                        ServerNetWorkingTask.Run(new S2CGetFileContent(FileIO.GetFileContent(fileName, fileSource, server)).ToJsonObject(), sendNetworkPackage.ID, player, variables.Identifiers.TextFileNetworkingIdentifier);
                    } else {
                        ServerNetWorkingTask.Run(new FailedContent("text.filereader.printfile.nopermission", fileName).ToJsonObject(), sendNetworkPackage.ID, player, variables.Identifiers.TextFileNetworkingIdentifier);
                    }
                }
            }
            catch (Exception e) {
                ServerNetWorkingTask.Run(new FailedContent("text.filereader.exception", e.getClass().getCanonicalName(), e.getMessage()).ToJsonObject(), sendNetworkPackage.ID, player, variables.Identifiers.TextFileNetworkingIdentifier);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static void OnReceiveSedPackage(class_310 client2, class_2960 identifier, SendNetworkPackage sendNetworkPackage) {
    }

    public static void GetNetPackageCallback(MinecraftServer server, class_3222 player, class_3244 handler, class_2540 buf, PacketSender responseSender, class_2960 Identifier) {
        if (ResponseNetworkPackage.IsResponse((ByteBuf)buf, StandardCharsets.UTF_8)) {
            ResponseNetworkPackage responseNetworkPackage = ResponseNetworkPackage.GetPackage((ByteBuf)buf, StandardCharsets.UTF_8);
            if (responseNetworkPackage == null || responseNetworkPackage.ResponseID == null) {
                return;
            }
            funcitons.AutoRemoveGetItemFromStream(ServerNetWorkingTask.TaskPool, t -> t.isReturned() && t.PackageID.equals(responseNetworkPackage.ResponseID)).forEach(i -> i.Return(new C2SArguments(responseNetworkPackage.Body, server, player)));
        } else if (SendNetworkPackage.IsSendPackage((ByteBuf)buf, StandardCharsets.UTF_8)) {
            NetworkingFunctions.OnReceiveSedPackage(server, player, Identifier, SendNetworkPackage.GetPackage((ByteBuf)buf, StandardCharsets.UTF_8));
        } else {
            Events.C2SPackageEvent.InvokeAsync(server, player, handler, buf, responseSender, Identifier);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static void GetNetPackageCallback(class_310 client2, class_634 handler, class_2540 buf, PacketSender responseSender, class_2960 Identifier) {
        if (ResponseNetworkPackage.IsResponse((ByteBuf)buf, StandardCharsets.UTF_8)) {
            ResponseNetworkPackage responseNetworkPackage = ResponseNetworkPackage.GetPackage((ByteBuf)buf, StandardCharsets.UTF_8);
            if (responseNetworkPackage == null || responseNetworkPackage.ResponseID == null) {
                return;
            }
            funcitons.AutoRemoveGetItemFromStream(ClientNetWorkingTask.TaskPool, t -> !t.isReturned() && t.PackageID.equals(responseNetworkPackage.ResponseID)).forEach(i -> i.Return(new S2CArguments(client2, responseNetworkPackage.Body)));
        } else if (SendNetworkPackage.IsSendPackage((ByteBuf)buf, StandardCharsets.UTF_8)) {
            NetworkingFunctions.OnReceiveSedPackage(client2, Identifier, SendNetworkPackage.GetPackage((ByteBuf)buf, StandardCharsets.UTF_8));
        } else {
            Events.S2CPackageEvent.InvokeAsync(client2, handler, buf, responseSender, Identifier);
        }
    }
}

