/*
 * Decompiled with CFR 0.152.
 */
package cn.thecoldworld.textfilereader.networking.jsonformats;

import cn.thecoldworld.textfilereader.FileSource;
import cn.thecoldworld.textfilereader.networking.jsonformats.NetworkPackageContent;
import cn.thecoldworld.textfilereader.variables;
import com.google.gson.JsonObject;

public class C2SGetFileContent
implements NetworkPackageContent {
    public final String FileName;
    public final String fileSource;

    public C2SGetFileContent(String fileName, FileSource fileSource) throws Exception {
        this.FileName = fileName;
        this.fileSource = switch (fileSource) {
            default -> throw new IncompatibleClassChangeError();
            case FileSource.global -> "Global";
            case FileSource.save -> "Save";
            case FileSource.local -> throw new Exception("Cannot use FileSource.local");
        };
    }

    public C2SGetFileContent(String Json) {
        C2SGetFileContent i = (C2SGetFileContent)variables.defaultGson.fromJson(Json, C2SGetFileContent.class);
        if (i.FileName == null || i.fileSource == null) {
            this.FileName = "";
            this.fileSource = "";
        } else {
            this.FileName = i.FileName;
            this.fileSource = i.fileSource;
        }
    }

    public C2SGetFileContent(JsonObject Json) {
        if (!Json.has("FileName") || !Json.has("ListFileSource")) {
            this.FileName = "";
            this.fileSource = "";
        } else {
            this.FileName = Json.get("FileName").getAsString();
            this.fileSource = Json.get("ListFileSource").getAsString();
        }
    }

    public static boolean IsInstance(String Json) {
        try {
            return ((JsonObject)variables.defaultGson.fromJson(Json, JsonObject.class)).has("FileName") && ((JsonObject)variables.defaultGson.fromJson(Json, JsonObject.class)).has("ListFileSource");
        }
        catch (Throwable e) {
            return false;
        }
    }

    public FileSource GetFileSource() {
        return switch (this.fileSource.toLowerCase()) {
            case "global" -> FileSource.global;
            case "save" -> FileSource.save;
            default -> throw new IllegalStateException("Unexpected value: " + this.fileSource);
        };
    }

    @Override
    public String ToJson() {
        return variables.defaultGson.toJson((Object)this, C2SGetFileContent.class);
    }

    @Override
    public JsonObject ToJsonObject() {
        JsonObject i = new JsonObject();
        i.addProperty("FileName", this.FileName);
        i.addProperty("ListFileSource", this.fileSource);
        return i;
    }
}

