/*
 * Decompiled with CFR 0.152.
 */
package cn.thecoldworld.textfilereader.networking.jsonformats;

import cn.thecoldworld.textfilereader.FileSource;
import cn.thecoldworld.textfilereader.networking.jsonformats.C2SGetFileContent;
import cn.thecoldworld.textfilereader.networking.jsonformats.NetworkPackageContent;
import cn.thecoldworld.textfilereader.variables;
import com.google.gson.JsonObject;
import org.jetbrains.annotations.NotNull;

public class C2SGetFileList
implements NetworkPackageContent {
    public final String ListFileSource;

    public C2SGetFileList(FileSource fileSource) {
        this.ListFileSource = switch (fileSource) {
            default -> throw new IncompatibleClassChangeError();
            case FileSource.global -> "Global";
            case FileSource.save -> "Save";
            case FileSource.local -> "";
        };
    }

    public C2SGetFileList(String Json) {
        C2SGetFileContent i = (C2SGetFileContent)variables.defaultGson.fromJson(Json, C2SGetFileContent.class);
        this.ListFileSource = i.FileName == null || i.fileSource == null ? "" : i.fileSource;
    }

    public C2SGetFileList(@NotNull JsonObject jsonObject) {
        this.ListFileSource = jsonObject.has("ListFileSource") ? jsonObject.get("ListFileSource").getAsString() : "";
    }

    public static boolean IsInstance(String Json) {
        try {
            return ((JsonObject)variables.defaultGson.fromJson(Json, JsonObject.class)).has("ListFileSource");
        }
        catch (Throwable e) {
            return false;
        }
    }

    public FileSource GetFileSource() {
        return switch (this.ListFileSource.toLowerCase()) {
            case "global" -> FileSource.global;
            case "save" -> FileSource.save;
            default -> throw new IllegalStateException("Unexpected value: " + this.ListFileSource);
        };
    }

    @Override
    public String ToJson() {
        return variables.defaultGson.toJson((Object)this, C2SGetFileList.class);
    }

    @Override
    public JsonObject ToJsonObject() {
        JsonObject object = new JsonObject();
        object.addProperty("ListFileSource", this.ListFileSource);
        return object;
    }
}

