/*
 * Decompiled with CFR 0.152.
 */
package cn.thecoldworld.textfilereader.tasks;

import cn.thecoldworld.textfilereader.tasks.TaskAWaiter;
import cn.thecoldworld.textfilereader.variables;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Task<TResult> {
    private final List<Consumer<TResult>> callbacks;
    private final TaskAWaiter<TResult, Task<TResult>> TaskAWaiter;
    private Runnable runnable;
    private TResult result;
    private boolean Returned;

    public Task(Runnable run, List<Consumer<TResult>> callbacks) {
        this.runnable = run;
        this.callbacks = callbacks;
        this.TaskAWaiter = new TaskAWaiter(this);
    }

    public Task(Runnable run) {
        this.runnable = run;
        this.callbacks = List.of();
        this.TaskAWaiter = new TaskAWaiter(this);
    }

    public Task(List<Consumer<TResult>> callbacks) {
        this.runnable = () -> {};
        this.callbacks = callbacks;
        this.TaskAWaiter = new TaskAWaiter(this);
    }

    public Task() {
        this.runnable = () -> {};
        this.callbacks = List.of();
        this.TaskAWaiter = new TaskAWaiter(this);
    }

    public void Return(@NotNull TResult result) {
        this.result = result;
        this.Returned = true;
        this.TaskAWaiter.Return();
        this.callbacks.forEach(i -> variables.scheduledExecutorService.schedule(() -> i.accept(result), 0L, TimeUnit.MICROSECONDS));
    }

    public boolean isReturned() {
        return this.Returned;
    }

    public void Start() {
        if (this.Returned) {
            return;
        }
        variables.scheduledExecutorService.schedule(this.runnable, 0L, TimeUnit.MICROSECONDS);
        this.Returned = false;
    }

    @Nullable
    public TResult getResult() {
        return this.result;
    }

    protected void SetAction(Runnable Action) {
        this.runnable = Action;
    }

    public TaskAWaiter<TResult, Task<TResult>> getAWaiter() {
        return this.TaskAWaiter;
    }
}

