/*
 * Decompiled with CFR 0.152.
 */
package cn.thecoldworld.textfilereader;

import cn.thecoldworld.textfilereader.FileIO;
import cn.thecoldworld.textfilereader.FilePermissions;
import cn.thecoldworld.textfilereader.filereader;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_2168;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class mod
implements ModInitializer {
    public static Logger Log = LoggerFactory.getLogger((String)"TextFileReader");
    public static BlockingDeque<Runnable> TickEvent = new LinkedBlockingDeque<Runnable>();

    public void onInitialize() {
        FileWriter fr;
        Log.info("Start Initialize TextFileReader mod");
        FileIO.Rootdir = Paths.get(System.getProperty("user.dir"), new String[0]);
        if (!FileIO.Rootdir.isAbsolute()) {
            throw new RuntimeException("Cannot get Data path");
        }
        FileIO.GlobalTextPath = Paths.get(FileIO.Rootdir.toString(), "Texts");
        FileIO.ConfigPath = Paths.get(FileIO.Rootdir.toString(), "config", "TextFileReader.json");
        if (!FileIO.GlobalTextPath.toFile().exists() || !FileIO.GlobalTextPath.toFile().isDirectory()) {
            try {
                Log.info("Missing global text data directory,starting crate");
                Files.createDirectory(FileIO.GlobalTextPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot create global text data directory ,exception message:" + e.getMessage());
            }
        }
        if (!FileIO.ConfigPath.toFile().exists() || !FileIO.ConfigPath.toFile().isFile()) {
            try {
                Log.info("Missing config file,starting crate");
                Files.createFile(FileIO.ConfigPath, new FileAttribute[0]);
                fr = new FileWriter(FileIO.ConfigPath.toFile());
                fr.write("{\"Segmentedoutput\":false}");
                fr.flush();
                fr.close();
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot create global text data directory ,exception message:" + e.getMessage());
            }
        }
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> filereader.Init((CommandDispatcher<class_2168>)dispatcher));
        try {
            fr = new FileWriter(Paths.get(FileIO.GlobalTextPath.toString(), "permissions.json").toFile());
            fr.write("{\"Files\":[]}");
            fr.flush();
            fr.close();
            FilePermissions.GlobalTextPermission = FilePermissions.InitPermission(Paths.get(FileIO.GlobalTextPath.toString(), "permissions.json"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Log.info("Initialize TextFileReader mod done");
    }

    public static JsonElement GetConfig(String Name) {
        Gson gson = new Gson();
        try {
            JsonObject configjson = (JsonObject)gson.fromJson(String.join((CharSequence)"", Files.readAllLines(FileIO.ConfigPath)), JsonObject.class);
            return configjson.get(Name);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

