/*
 * Decompiled with CFR 0.152.
 */
package cn.thecoldworld.textfilereader;

import cn.thecoldworld.textfilereader.FileIO;
import cn.thecoldworld.textfilereader.variables;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Scanner;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;

public class cfileloader {
    public static void init(@NotNull CommandDispatcher<FabricClientCommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"cFileLoader").then(ClientCommandManager.literal((String)"List").executes(cfileloader::CPrintFileList))).then(ClientCommandManager.literal((String)"Read").then(ClientCommandManager.argument((String)"FileName", (ArgumentType)StringArgumentType.string()).executes(cfileloader::CGetFileContext)))).executes(i -> {
            ((FabricClientCommandSource)i.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)"TextFileReader"));
            ((FabricClientCommandSource)i.getSource()).sendFeedback((class_2561)class_2561.method_43471((String)"text.filereader.description"));
            return 0;
        }));
    }

    public static int CGetFileContext(@NotNull CommandContext<FabricClientCommandSource> context) throws CommandSyntaxException {
        try {
            String Fileaddress = (String)context.getArgument("FileName", String.class);
            Scanner fp = new Scanner(Paths.get(FileIO.GlobalTextPath.toString(), Fileaddress), StandardCharsets.UTF_8);
            if (variables.ModSettings.Segmentedoutput) {
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43469((String)"text.filereader.printfile", (Object[])new Object[]{Fileaddress, ""}));
                while (fp.hasNext()) {
                    ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43470((String)fp.nextLine()));
                }
            } else {
                StringBuilder sb = new StringBuilder();
                while (fp.hasNext()) {
                    sb.append(fp.nextLine()).append('\n');
                }
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43469((String)"text.filereader.printfile", (Object[])new Object[]{Fileaddress, "\n" + String.valueOf(sb)}));
            }
            fp.close();
        }
        catch (NoSuchFileException fe) {
            throw new SimpleCommandExceptionType((Message)class_2561.method_43469((String)"text.filereader,filenotfound", (Object[])new Object[]{fe.getMessage()})).create();
        }
        catch (Exception ex) {
            throw new SimpleCommandExceptionType((Message)class_2561.method_43469((String)"text.filereader.exception", (Object[])new Object[]{ex.getClass().getCanonicalName(), ex.getMessage()})).create();
        }
        return 0;
    }

    public static int CPrintFileList(CommandContext<FabricClientCommandSource> context) throws CommandSyntaxException {
        try {
            Path Path2 = FileIO.GlobalTextPath;
            if (!Path2.toFile().exists() || !Path2.toFile().isDirectory()) {
                variables.Log.info("Missing client text data directory,starting crate");
                Files.createDirectory(Path2, new FileAttribute[0]);
            }
            if (variables.ModSettings.Segmentedoutput) {
                FabricClientCommandSource src = (FabricClientCommandSource)context.getSource();
                CompletableFuture.supplyAsync(() -> {
                    src.sendFeedback((class_2561)class_2561.method_43469((String)"text.filereader.printcurrentpath", (Object[])new Object[]{""}));
                    try {
                        Files.walk(Path2, Integer.MAX_VALUE, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(i -> {
                            if (i.getFileName().toString().equals("permissions.json")) {
                                return;
                            }
                            src.sendFeedback((class_2561)class_2561.method_43470((String)i.getFileName().toString()));
                        });
                    }
                    catch (IOException e) {
                        variables.Log.error("", (Throwable)e);
                        src.sendError((class_2561)class_2561.method_43469((String)"text.filereader.exception", (Object[])new Object[]{e.getClass().getCanonicalName(), e.getMessage()}));
                    }
                    return 0;
                });
            } else {
                StringBuilder sb = new StringBuilder();
                Files.walk(Path2, Integer.MAX_VALUE, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(i -> {
                    if (i.getFileName().toString().equals("permissions.json")) {
                        return;
                    }
                    sb.append(i.getFileName()).append("\n");
                });
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43469((String)"text.filereader.printcurrentpath", (Object[])new Object[]{"\n" + String.valueOf(sb)}));
            }
            return 0;
        }
        catch (Exception ex) {
            throw new SimpleCommandExceptionType((Message)class_2561.method_43469((String)"text.filereader.exception", (Object[])new Object[]{ex.getClass().getCanonicalName(), ex.getMessage()})).create();
        }
    }
}

