/*
 * Decompiled with CFR 0.152.
 */
package cn.thecoldworld.textfilereader;

import cn.thecoldworld.textfilereader.FileIO;
import cn.thecoldworld.textfilereader.FilePermissions;
import cn.thecoldworld.textfilereader.FileSource;
import cn.thecoldworld.textfilereader.mod;
import cn.thecoldworld.textfilereader.sender;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Scanner;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_5218;
import org.jetbrains.annotations.Nullable;

public class filereader {
    public static void Init(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"FileReader").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"Permission").requires(src -> src.method_9259(2))).then(class_2170.method_9247((String)"Remove").then(class_2170.method_9244((String)"FileName", (ArgumentType)StringArgumentType.string()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"Player", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9247((String)"Save").executes(i -> filereader.RemovePermission((CommandContext<class_2168>)i, FileSource.save)))).then(class_2170.method_9247((String)"Global").executes(i -> filereader.RemovePermission((CommandContext<class_2168>)i, FileSource.global))))))).then(class_2170.method_9247((String)"Give").then(class_2170.method_9244((String)"FileName", (ArgumentType)StringArgumentType.string()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"Player", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9247((String)"Save").executes(i -> filereader.GivePermission((CommandContext<class_2168>)i, FileSource.save)))).then(class_2170.method_9247((String)"Global").executes(i -> filereader.GivePermission((CommandContext<class_2168>)i, FileSource.global)))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"File").then(class_2170.method_9247((String)"Read").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"FileName", (ArgumentType)StringArgumentType.string()).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"Global").then(class_2170.method_9244((String)"Player", (ArgumentType)class_2186.method_9305()).executes(i -> filereader.GetFileContext((CommandContext<class_2168>)i, FileSource.global, class_2186.method_9313((CommandContext)i, (String)"Player"))))).executes(i -> filereader.GetFileContext((CommandContext<class_2168>)i, FileSource.global, null)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"Save").then(class_2170.method_9244((String)"Player", (ArgumentType)class_2186.method_9305()).executes(i -> filereader.GetFileContext((CommandContext<class_2168>)i, FileSource.global, class_2186.method_9313((CommandContext)i, (String)"Player"))))).executes(i -> filereader.GetFileContext((CommandContext<class_2168>)i, FileSource.save, null)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"List").requires(src -> src.method_9259(2))).then(class_2170.method_9247((String)"Global").executes(i -> filereader.PrintFileList((CommandContext<class_2168>)i, FileSource.global)))).then(class_2170.method_9247((String)"World").executes(i -> filereader.PrintFileList((CommandContext<class_2168>)i, FileSource.save)))))).executes(i -> {
            ((class_2168)i.getSource()).method_45068((class_2561)class_2561.method_43470((String)"TextFileReader"));
            ((class_2168)i.getSource()).method_45068((class_2561)class_2561.method_43471((String)"text.filereader.description"));
            return 0;
        }));
    }

    public static int PrintFileList(CommandContext<class_2168> context, FileSource fileSource) throws CommandSyntaxException {
        try {
            boolean Segmentedoutput = mod.GetConfig("Segmentedoutput").getAsBoolean();
            Path Path2 = fileSource == FileSource.save ? Paths.get(((class_2168)context.getSource()).method_9225().method_8503().method_27050(class_5218.field_24188).getParent().toString(), "Texts") : FileIO.GlobalTextPath;
            if (!Path2.toFile().exists() || !Path2.toFile().isDirectory()) {
                mod.Log.info("Missing world text data directory,starting crate");
                Files.createDirectory(Path2, new FileAttribute[0]);
            }
            if (Segmentedoutput) {
                class_2168 src = (class_2168)context.getSource();
                CompletableFuture.supplyAsync(() -> {
                    src.method_45068((class_2561)class_2561.method_43469((String)"text.filereader.printcurrentpath", (Object[])new Object[]{""}));
                    try {
                        Files.walk(Path2, Integer.MAX_VALUE, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(i -> {
                            if (i.getFileName().toString().equals("permissions.json")) {
                                return;
                            }
                            src.method_45068((class_2561)class_2561.method_43470((String)i.getFileName().toString()));
                        });
                    }
                    catch (IOException e) {
                        mod.Log.error("", (Throwable)e);
                        src.method_45068((class_2561)class_2561.method_43469((String)"text.filereader.exception", (Object[])new Object[]{e.getClass().getCanonicalName(), e.getMessage()}));
                    }
                    return 0;
                });
            } else {
                StringBuilder sb = new StringBuilder();
                Files.walk(Path2, Integer.MAX_VALUE, new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(i -> {
                    if (i.getFileName().toString().equals("permissions.json")) {
                        return;
                    }
                    sb.append(i.getFileName()).append("\n");
                });
                ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"text.filereader.printcurrentpath", (Object[])new Object[]{"\n" + sb.toString()}));
            }
            return 0;
        }
        catch (Exception ex) {
            throw new SimpleCommandExceptionType((Message)class_2561.method_43469((String)"text.filereader.exception", (Object[])new Object[]{ex.getClass().getCanonicalName(), ex.getMessage()})).create();
        }
    }

    public static int GetFileContext(CommandContext<class_2168> context, FileSource fileSource, @Nullable class_1297 ent) throws CommandSyntaxException {
        try {
            class_1297 entity;
            String FileAddress;
            class_2168 source;
            block8: {
                sender sender2 = filereader.GetSender(context);
                source = (class_2168)context.getSource();
                FileAddress = (String)context.getArgument("FileName", String.class);
                if (sender2 == sender.console) {
                    mod.Log.info("Command FileReader File Get from server console");
                    return filereader.PrintConsole(context, FileAddress, fileSource);
                }
                entity = ent == null ? source.method_9229() : ent;
                switch (fileSource) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case global: {
                        if (!FilePermissions.GlobalTextPermission.HavePermission(entity, FileAddress, source.method_9211().method_3828())) break;
                        break block8;
                    }
                    case save: {
                        if (FilePermissions.WorldTextPermission.HavePermission(entity, FileAddress, source.method_9211().method_3828())) break block8;
                    }
                }
                throw new SimpleCommandExceptionType((Message)class_2561.method_43469((String)"text.filereader.printfile.nopermission", (Object[])new Object[]{FileAddress})).create();
            }
            CompletableFuture.supplyAsync(() -> {
                try {
                    return FileIO.PrintFile(entity, (class_1937)source.method_9225(), FileAddress, fileSource);
                }
                catch (IOException e) {
                    mod.Log.error("", (Throwable)e);
                    ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"text.filereader.exception", (Object[])new Object[]{e.getClass().getCanonicalName(), e.getMessage()}));
                    return -1;
                }
            });
            mod.Log.info("Command FileReader File Get from player " + entity.method_5820());
            return 0;
        }
        catch (CommandSyntaxException syntaxException) {
            throw syntaxException;
        }
        catch (Exception ex) {
            ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"text.filereader.exception", (Object[])new Object[]{ex.getClass().getCanonicalName(), ex.getMessage()}));
            throw new SimpleCommandExceptionType((Message)class_2561.method_43470((String)ex.getMessage())).create();
        }
    }

    public static int PrintConsole(CommandContext<class_2168> context, String FileName, FileSource fileSource) throws CommandSyntaxException {
        try {
            boolean Segmentedoutput = mod.GetConfig("Segmentedoutput").getAsBoolean();
            Scanner fp = switch (fileSource) {
                case FileSource.save -> new Scanner(Paths.get(((class_2168)context.getSource()).method_9225().method_8503().method_27050(class_5218.field_24188).getParent().toString(), FileName), StandardCharsets.UTF_8);
                case FileSource.global -> new Scanner(Paths.get(FileIO.GlobalTextPath.toString(), FileName), StandardCharsets.UTF_8);
                default -> throw new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"Internal error")).create();
            };
            if (Segmentedoutput) {
                mod.Log.info(class_2561.method_43469((String)"text.filereader.printfile", (Object[])new Object[]{FileName, ""}).method_10858(100));
                while (fp.hasNext()) {
                    mod.Log.info(fp.nextLine());
                }
            } else {
                StringBuilder sb = new StringBuilder();
                while (fp.hasNext()) {
                    sb.append(fp.nextLine()).append('\n');
                }
                mod.Log.info(class_2561.method_43469((String)"text.filereader.printfile", (Object[])new Object[]{FileName, "\n" + String.valueOf(sb)}).method_10858(sb.length() + 100));
            }
            fp.close();
            return 0;
        }
        catch (Exception e) {
            throw new SimpleCommandExceptionType((Message)class_2561.method_43469((String)"text.filereader.exception", (Object[])new Object[]{e.getClass().getCanonicalName(), e.getMessage()})).create();
        }
    }

    public static int GivePermission(CommandContext<class_2168> context, FileSource fs) throws CommandSyntaxException {
        filereader.GetSender(context);
        try {
            if (fs == FileSource.save) {
                if (!Files.exists(Paths.get(((class_2168)context.getSource()).method_9211().method_27050(class_5218.field_24188).getParent().toAbsolutePath().normalize().toString(), "Texts", (String)context.getArgument("FileName", String.class)).toAbsolutePath().normalize(), new LinkOption[0]) || !Paths.get(((class_2168)context.getSource()).method_9211().method_27050(class_5218.field_24188).getParent().toAbsolutePath().normalize().toString(), "Texts", (String)context.getArgument("FileName", String.class)).toAbsolutePath().normalize().toFile().isFile()) {
                    throw new SimpleCommandExceptionType((Message)class_2561.method_43469((String)"text.filereader.permission.fail.invaidfile", (Object[])new Object[]{context.getArgument("FileName", String.class)})).create();
                }
                class_2186.method_9317(context, (String)"Player").forEach(i -> {
                    try {
                        FilePermissions.WorldTextPermission.GivePermission((class_1297)i, (String)context.getArgument("FileName", String.class));
                    }
                    catch (Exception e) {
                        mod.Log.error("", (Throwable)e);
                    }
                });
            }
            if (fs == FileSource.global) {
                if (!Files.exists(Paths.get(FileIO.GlobalTextPath.toAbsolutePath().normalize().toString(), (String)context.getArgument("FileName", String.class)).toAbsolutePath().normalize(), new LinkOption[0]) || !Paths.get(FileIO.GlobalTextPath.toAbsolutePath().normalize().toString(), (String)context.getArgument("FileName", String.class)).toAbsolutePath().normalize().toFile().isFile()) {
                    throw new SimpleCommandExceptionType((Message)class_2561.method_43469((String)"text.filereader.permission.fail.invaidfile", (Object[])new Object[]{context.getArgument("FileName", String.class)})).create();
                }
                class_2186.method_9317(context, (String)"Player").forEach(i -> {
                    try {
                        FilePermissions.GlobalTextPermission.GivePermission((class_1297)i, (String)context.getArgument("FileName", String.class));
                    }
                    catch (Exception e) {
                        mod.Log.error("", (Throwable)e);
                    }
                });
            }
        }
        catch (CommandSyntaxException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new SimpleCommandExceptionType((Message)class_2561.method_43469((String)"text.filereader.exception", (Object[])new Object[]{e.getClass().getCanonicalName(), e.getMessage()})).create();
        }
        StringBuilder sb = new StringBuilder();
        class_2186.method_9317(context, (String)"Player").forEach(i -> sb.append(i.method_5820()));
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"text.filereader.permission.success.give", (Object[])new Object[]{context.getArgument("FileName", String.class), sb.toString()}));
        return 0;
    }

    public static int RemovePermission(CommandContext<class_2168> context, FileSource fs) throws CommandSyntaxException {
        filereader.GetSender(context);
        try {
            if (fs == FileSource.save) {
                if (!Files.exists(Paths.get(((class_2168)context.getSource()).method_9211().method_27050(class_5218.field_24188).getParent().toAbsolutePath().normalize().toString(), "Texts", (String)context.getArgument("FileName", String.class)).toAbsolutePath().normalize(), new LinkOption[0]) || !Paths.get(((class_2168)context.getSource()).method_9211().method_27050(class_5218.field_24188).getParent().toAbsolutePath().normalize().toString(), "Texts", (String)context.getArgument("FileName", String.class)).toAbsolutePath().normalize().toFile().isFile()) {
                    throw new SimpleCommandExceptionType((Message)class_2561.method_43469((String)"text.filereader.permission.fail.invaidfile", (Object[])new Object[]{context.getArgument("FileName", String.class)})).create();
                }
                class_2186.method_9317(context, (String)"Player").forEach(i -> {
                    try {
                        FilePermissions.WorldTextPermission.RemovePermission((class_1297)i, (String)context.getArgument("FileName", String.class), ((class_2168)context.getSource()).method_9211().method_3828());
                    }
                    catch (Exception e) {
                        mod.Log.error("", (Throwable)e);
                    }
                });
            }
            if (fs == FileSource.global) {
                if (!Files.exists(Paths.get(FileIO.GlobalTextPath.toAbsolutePath().normalize().toString(), (String)context.getArgument("FileName", String.class)).toAbsolutePath().normalize(), new LinkOption[0]) || !Paths.get(FileIO.GlobalTextPath.toAbsolutePath().normalize().toString(), (String)context.getArgument("FileName", String.class)).toAbsolutePath().normalize().toFile().isFile()) {
                    throw new SimpleCommandExceptionType((Message)class_2561.method_43469((String)"text.filereader.permission.fail.invaidfile", (Object[])new Object[]{context.getArgument("FileName", String.class)})).create();
                }
                class_2186.method_9317(context, (String)"Player").forEach(i -> {
                    try {
                        FilePermissions.GlobalTextPermission.RemovePermission((class_1297)i, (String)context.getArgument("FileName", String.class), ((class_2168)context.getSource()).method_9211().method_3828());
                    }
                    catch (Exception e) {
                        mod.Log.error("", (Throwable)e);
                    }
                });
            }
        }
        catch (CommandSyntaxException ex) {
            throw ex;
        }
        catch (Exception e) {
            throw new SimpleCommandExceptionType((Message)class_2561.method_43469((String)"text.filereader.exception", (Object[])new Object[]{e.getClass().getCanonicalName(), e.getMessage()})).create();
        }
        StringBuilder sb = new StringBuilder();
        class_2186.method_9317(context, (String)"Player").forEach(i -> sb.append(i.method_5820()));
        ((class_2168)context.getSource()).method_45068((class_2561)class_2561.method_43469((String)"text.filereader.permission.success.remove", (Object[])new Object[]{context.getArgument("FileName", String.class), sb.toString()}));
        return 0;
    }

    public static sender GetSender(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        class_1297 sender2 = source.method_9228();
        if (sender2 == null) {
            if (source.method_9214().equals("Server")) {
                return sender.console;
            }
            throw new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"text.filereader.invaidsender")).create();
        }
        source.method_9229();
        return sender.player;
    }
}

