/*
 * Decompiled with CFR 0.152.
 */
package net.cardinalboats;

import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import net.cardinalboats.alias.AliasesKt;
import net.cardinalboats.config.CIBConfig;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000h\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\u001a2\u0010\u0005\u001a\u00020\u00062\n\u0010\u0007\u001a\u00060\bj\u0002`\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\u000e\b\u0002\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000e\u001a\u0012\u0010\u000f\u001a\u00020\u00042\n\u0010\u0010\u001a\u00060\u0011j\u0002`\u0012\u001a\u001e\u0010\u0013\u001a\u00020\u00062\u000e\u0010\u0014\u001a\n\u0018\u00010\u0015j\u0004\u0018\u0001`\u00162\u0006\u0010\u0017\u001a\u00020\u0018\u001a\u001e\u0010\u0019\u001a\u00020\u00042\n\u0010\u001a\u001a\u00060\u001bj\u0002`\u001c2\n\u0010\u0014\u001a\u00060\u001dj\u0002`\u001e\u001a\u0016\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\"\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0012\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"icePattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "lieAboutMovingForward", "", "rotateBoat", "", "boat", "Lnet/minecraft/world/entity/vehicle/Boat;", "Lnet/cardinalboats/alias/AbstractBoatEntity;", "rotation", "", "maintainVelocity", "postAction", "Lkotlin/Function0;", "isIce", "blockState", "Lnet/minecraft/world/level/block/state/BlockState;", "Lnet/cardinalboats/alias/BlockState;", "clientChatLog", "player", "Lnet/minecraft/client/player/LocalPlayer;", "Lnet/cardinalboats/alias/ClientPlayerEntity;", "message", "", "shouldSnap", "level", "Lnet/minecraft/world/level/Level;", "Lnet/cardinalboats/alias/World;", "Lnet/minecraft/world/entity/player/Player;", "Lnet/cardinalboats/alias/PlayerEntity;", "roundYRot", "yRot", "toNearest", "", "forge-1.18.2"})
public final class UtilKt {
    private static final Pattern icePattern = Pattern.compile("(\\b|_)ice\\b", 2);
    @JvmField
    public static boolean lieAboutMovingForward;

    public static final void rotateBoat(@NotNull Boat boat, float rotation, boolean maintainVelocity, @NotNull Function0<Unit> postAction) {
        Intrinsics.checkNotNullParameter((Object)boat, (String)"boat");
        Intrinsics.checkNotNullParameter(postAction, (String)"postAction");
        if (maintainVelocity) {
            double currentVelocity = AliasesKt.getVelocity((Entity)boat).length();
            Vec3 newVelocity = AliasesKt.rotateY(new Vec3(0.0, 0.0, currentVelocity), -rotation * AliasesKt.RADIANS_PER_DEGREE);
            Entity entity = (Entity)boat;
            Intrinsics.checkNotNull((Object)newVelocity);
            AliasesKt.setVelocity(entity, newVelocity);
        } else {
            Entity entity = (Entity)boat;
            Vec3 vec3 = Vec3.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"ZERO");
            AliasesKt.setVelocity(entity, vec3);
        }
        AliasesKt.setYaw((Entity)boat, rotation);
        AliasesKt.setYawVelocity(boat, 0.0f);
        Entity entity = boat.getControllingPassenger();
        if (entity != null) {
            AliasesKt.setYaw(entity, AliasesKt.getYaw((Entity)boat));
        }
        postAction.invoke();
    }

    public static /* synthetic */ void rotateBoat$default(Boat boat, float f, boolean bl, Function0 function0, int n, Object object) {
        if ((n & 8) != 0) {
            function0 = UtilKt::rotateBoat$lambda$0;
        }
        UtilKt.rotateBoat(boat, f, bl, (Function0<Unit>)function0);
    }

    public static final boolean isIce(@NotNull BlockState blockState) {
        Intrinsics.checkNotNullParameter((Object)blockState, (String)"blockState");
        return icePattern.matcher(blockState.getBlock().toString()).find();
    }

    public static final void clientChatLog(@Nullable LocalPlayer player, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        if (player == null) {
            return;
        }
        if (CIBConfig.getInstance().doChatShit) {
            AliasesKt.sendMessage(player, (Component)AliasesKt.makeText("[cardinalboats] " + message), false);
        }
    }

    public static final boolean shouldSnap(@NotNull Level level, @NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        HitResult lookingAt = AliasesKt.raycast((Entity)player, 20.0, 0.0f, false);
        if (lookingAt != null && lookingAt.getType() == HitResult.Type.BLOCK) {
            BlockState blockState = level.getBlockState(((BlockHitResult)lookingAt).getBlockPos());
            Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"getBlockState(...)");
            return UtilKt.isIce(blockState);
        }
        return false;
    }

    public static final float roundYRot(float yRot, int toNearest) {
        return MathKt.roundToInt((float)(yRot % (float)360 / (float)toNearest)) * toNearest;
    }

    private static final Unit rotateBoat$lambda$0() {
        return Unit.INSTANCE;
    }
}

