/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtstoragedrawers;

import com.jaquadro.minecraft.storagedrawers.core.ModBlockVariants;
import com.texelsaurus.minecraft.chameleon.registry.ChameleonRegistry;
import lombok.Generated;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public enum DrawerTypes {
    RUBBER("rubber", "rubber_planks", "rubber_slab"),
    TREATED("treated", "treated_wood_planks", "treated_wood_slab");

    private final String name;
    private final ResourceLocation plankResource;
    private final ResourceLocation slabResource;
    private final ModBlockVariants.VariantData data;

    private DrawerTypes(String name, String plankName, String slabName) {
        this.name = name;
        this.plankResource = new ResourceLocation("gtceu", plankName);
        this.slabResource = new ResourceLocation("gtceu", slabName);
        this.data = new ModBlockVariants.VariantData(new ResourceLocation("gtstoragedrawers", "gtceu_" + name));
    }

    public String getTrimModelName() {
        return "block/gtceu_" + this.name + "_trim";
    }

    public String getTrimItemName() {
        return "item/gtceu_" + this.name + "_trim";
    }

    public String getDrawerModelName(int size, boolean half) {
        String type = half ? "half" : "full";
        return "block/gtceu_" + this.name + "_" + type + "_drawers_" + size;
    }

    public String getItemModelName(int size, boolean half) {
        String type = half ? "half" : "full";
        return "item/gtceu_" + this.name + "_" + type + "_drawers_" + size;
    }

    public String getTextureName(String textureVariant) {
        return "block/gtceu/drawers_" + this.name + "_" + textureVariant;
    }

    public void registerBlocks(ChameleonRegistry<Block> register) {
        ModBlockVariants.registerVariant(register, (ModBlockVariants.VariantData)this.data);
    }

    public void registerItems(ChameleonRegistry<Item> register) {
        ModBlockVariants.registerVariantItem(register, (ModBlockVariants.VariantData)this.data);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public ResourceLocation getPlankResource() {
        return this.plankResource;
    }

    @Generated
    public ResourceLocation getSlabResource() {
        return this.slabResource;
    }

    @Generated
    public ModBlockVariants.VariantData getData() {
        return this.data;
    }
}

