/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtstoragedrawers.data;

import com.gregtechceu.gtstoragedrawers.DrawerTypes;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class ModRecipeProvider
extends RecipeProvider {
    public ModRecipeProvider(PackOutput output) {
        super(output);
    }

    protected void buildRecipes(@NotNull Consumer<FinishedRecipe> consumer) {
        for (DrawerTypes type : DrawerTypes.values()) {
            this.makeTrim(type, consumer);
            this.makeDrawer1(type, true, consumer);
            this.makeDrawer2(type, true, consumer);
            this.makeDrawer4(type, true, consumer);
            this.makeDrawer1(type, false, consumer);
            this.makeDrawer2(type, false, consumer);
            this.makeDrawer4(type, false, consumer);
        }
    }

    private void makeTrim(DrawerTypes type, Consumer<FinishedRecipe> consumer) {
        if (type.getPlankResource() == null) {
            return;
        }
        Item plank = (Item)ForgeRegistries.ITEMS.getValue(type.getPlankResource());
        if (plank == null) {
            return;
        }
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)type.getData().blockTrim.get()), (int)4).pattern("x/x").pattern("/x/").pattern("x/x").define(Character.valueOf('x'), (ItemLike)plank).define(Character.valueOf('/'), Tags.Items.RODS_WOODEN).group("gtstoragedrawers").unlockedBy("has_item", (CriterionTriggerInstance)ModRecipeProvider.has((ItemLike)plank)).save(consumer);
    }

    private void makeDrawer1(DrawerTypes type, boolean half, Consumer<FinishedRecipe> consumer) {
        ResourceLocation woodResource;
        ResourceLocation resourceLocation = woodResource = half ? type.getSlabResource() : type.getPlankResource();
        if (woodResource == null) {
            return;
        }
        Item plank = (Item)ForgeRegistries.ITEMS.getValue(woodResource);
        if (plank == null) {
            return;
        }
        Block block = half ? (Block)type.getData().blockHalf1.get() : (Block)type.getData().blockFull1.get();
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)block, (int)1).pattern("///").pattern(" x ").pattern("///").define(Character.valueOf('x'), Tags.Items.CHESTS_WOODEN).define(Character.valueOf('/'), (ItemLike)plank).group("gtstoragedrawers").unlockedBy("has_item", (CriterionTriggerInstance)ModRecipeProvider.has((TagKey)Tags.Items.CHESTS_WOODEN)).save(consumer);
    }

    private void makeDrawer2(DrawerTypes type, boolean half, Consumer<FinishedRecipe> consumer) {
        ResourceLocation woodResource;
        ResourceLocation resourceLocation = woodResource = half ? type.getSlabResource() : type.getPlankResource();
        if (woodResource == null) {
            return;
        }
        Item plank = (Item)ForgeRegistries.ITEMS.getValue(woodResource);
        if (plank == null) {
            return;
        }
        Block block = half ? (Block)type.getData().blockHalf2.get() : (Block)type.getData().blockFull2.get();
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)block, (int)2).pattern("/x/").pattern("///").pattern("/x/").define(Character.valueOf('x'), Tags.Items.CHESTS_WOODEN).define(Character.valueOf('/'), (ItemLike)plank).group("gtstoragedrawers").unlockedBy("has_item", (CriterionTriggerInstance)ModRecipeProvider.has((TagKey)Tags.Items.CHESTS_WOODEN)).save(consumer);
    }

    private void makeDrawer4(DrawerTypes type, boolean half, Consumer<FinishedRecipe> consumer) {
        ResourceLocation woodResource;
        ResourceLocation resourceLocation = woodResource = half ? type.getSlabResource() : type.getPlankResource();
        if (woodResource == null) {
            return;
        }
        Item plank = (Item)ForgeRegistries.ITEMS.getValue(woodResource);
        if (plank == null) {
            return;
        }
        Block block = half ? (Block)type.getData().blockHalf4.get() : (Block)type.getData().blockFull4.get();
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)block, (int)4).pattern("x/x").pattern("///").pattern("x/x").define(Character.valueOf('x'), Tags.Items.CHESTS_WOODEN).define(Character.valueOf('/'), (ItemLike)plank).group("gtstoragedrawers").unlockedBy("has_item", (CriterionTriggerInstance)ModRecipeProvider.has((TagKey)Tags.Items.CHESTS_WOODEN)).save(consumer);
    }
}

