/*
 * Decompiled with CFR 0.152.
 */
package me.aviso.aceCurrency.api;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.aviso.aceCurrency.api.CurrencyAPI;
import me.aviso.aceCurrency.database.Database;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005H\u0016J\u0018\u0010\u000b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005H\u0016J\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0005H\u0016\u00a8\u0006\r"}, d2={"Lme/aviso/aceCurrency/api/CurrencyAPIImpl;", "Lme/aviso/aceCurrency/api/CurrencyAPI;", "<init>", "()V", "getCurrency", "", "player", "Lorg/bukkit/entity/Player;", "addCurrency", "", "amount", "setCurrency", "removeCurrency", "AceCurrency"})
public final class CurrencyAPIImpl
implements CurrencyAPI {
    @Override
    public int getCurrency(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        String string = player.getUniqueId().toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        String uuid = string;
        int amount = 0;
        String query = "SELECT amount FROM player_currency WHERE uuid = ?";
        Connection connection = Database.INSTANCE.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement(query);
            Intrinsics.checkNotNullExpressionValue(preparedStatement, "prepareStatement(...)");
            PreparedStatement statement = preparedStatement;
            statement.setString(1, uuid);
            ResultSet resultSet = statement.executeQuery();
            Intrinsics.checkNotNullExpressionValue(resultSet, "executeQuery(...)");
            ResultSet resultSet2 = resultSet;
            if (resultSet2.next()) {
                amount = resultSet2.getInt("amount");
            }
            resultSet2.close();
            statement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return amount;
    }

    @Override
    public boolean addCurrency(@NotNull Player player, int amount) {
        boolean bl;
        Intrinsics.checkNotNullParameter(player, "player");
        if (amount <= 0) {
            return false;
        }
        String string = player.getUniqueId().toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        String uuid = string;
        int currentAmount = this.getCurrency(player);
        String query = "INSERT INTO player_currency (uuid, amount) VALUES (?, ?) ON CONFLICT(uuid) DO UPDATE SET amount = ?";
        Connection connection = Database.INSTANCE.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement(query);
            Intrinsics.checkNotNullExpressionValue(preparedStatement, "prepareStatement(...)");
            PreparedStatement statement = preparedStatement;
            statement.setString(1, uuid);
            statement.setInt(2, currentAmount + amount);
            statement.setInt(3, currentAmount + amount);
            statement.executeUpdate();
            statement.close();
            bl = true;
        }
        catch (SQLException e) {
            e.printStackTrace();
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean setCurrency(@NotNull Player player, int amount) {
        boolean bl;
        Intrinsics.checkNotNullParameter(player, "player");
        if (amount < 0) {
            return false;
        }
        String string = player.getUniqueId().toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        String uuid = string;
        String query = "INSERT INTO player_currency (uuid, amount) VALUES (?, ?) ON CONFLICT(uuid) DO UPDATE SET amount = ?";
        Connection connection = Database.INSTANCE.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement(query);
            Intrinsics.checkNotNullExpressionValue(preparedStatement, "prepareStatement(...)");
            PreparedStatement statement = preparedStatement;
            statement.setString(1, uuid);
            statement.setInt(2, amount);
            statement.setInt(3, amount);
            statement.executeUpdate();
            statement.close();
            bl = true;
        }
        catch (SQLException e) {
            e.printStackTrace();
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean removeCurrency(@NotNull Player player, int amount) {
        boolean bl;
        Intrinsics.checkNotNullParameter(player, "player");
        if (amount <= 0) {
            return false;
        }
        String string = player.getUniqueId().toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        String uuid = string;
        int currentAmount = this.getCurrency(player);
        if (currentAmount < amount) {
            return false;
        }
        String query = "UPDATE player_currency SET amount = ? WHERE uuid = ?";
        Connection connection = Database.INSTANCE.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement(query);
            Intrinsics.checkNotNullExpressionValue(preparedStatement, "prepareStatement(...)");
            PreparedStatement statement = preparedStatement;
            statement.setInt(1, currentAmount - amount);
            statement.setString(2, uuid);
            statement.executeUpdate();
            statement.close();
            bl = true;
        }
        catch (SQLException e) {
            e.printStackTrace();
            bl = false;
        }
        return bl;
    }
}

