/*
 * Decompiled with CFR 0.152.
 */
package me.aviso.aceCurrency.database;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import me.aviso.aceCurrency.AceCurrency;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\f\u001a\u00020\tH\u0002J\u0006\u0010\r\u001a\u00020\u0005J\u0006\u0010\u000e\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lme/aviso/aceCurrency/database/Database;", "", "<init>", "()V", "connection", "Ljava/sql/Connection;", "DATABASE_URL", "", "connect", "", "plugin", "Lme/aviso/aceCurrency/AceCurrency;", "createTable", "getConnection", "disconnect", "AceCurrency"})
public final class Database {
    @NotNull
    public static final Database INSTANCE = new Database();
    private static Connection connection;
    @NotNull
    private static final String DATABASE_URL = "jdbc:sqlite:plugins/AceCurrency/database.db";

    private Database() {
    }

    public final void connect(@NotNull AceCurrency plugin) {
        File dbFile;
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        File dbDirectory = new File("plugins/AceCurrency");
        if (!dbDirectory.exists()) {
            dbDirectory.mkdirs();
        }
        if (!(dbFile = new File(dbDirectory, "database.db")).exists()) {
            try {
                dbFile.createNewFile();
            }
            catch (Exception e) {
                plugin.getLogger().severe("Could not create database file: " + e.getMessage());
                return;
            }
        }
        try {
            Connection connection = DriverManager.getConnection(DATABASE_URL);
            Intrinsics.checkNotNullExpressionValue(connection, "getConnection(...)");
            Database.connection = connection;
            this.createTable();
        }
        catch (SQLException e) {
            plugin.getLogger().severe("Could not connect to the database: " + e.getMessage());
        }
    }

    private final void createTable() {
        Connection connection = Database.connection;
        if (connection == null) {
            Intrinsics.throwUninitializedPropertyAccessException("connection");
            connection = null;
        }
        Statement statement = connection.createStatement();
        Intrinsics.checkNotNullExpressionValue(statement, "createStatement(...)");
        Statement statement2 = statement;
        statement2.executeUpdate("CREATE TABLE IF NOT EXISTS player_currency (uuid TEXT PRIMARY KEY, amount INTEGER)");
        statement2.close();
    }

    @NotNull
    public final Connection getConnection() {
        Connection connection = Database.connection;
        if (connection == null) {
            Intrinsics.throwUninitializedPropertyAccessException("connection");
            connection = null;
        }
        return connection;
    }

    public final void disconnect() {
        try {
            Connection connection = Database.connection;
            if (connection == null) {
                Intrinsics.throwUninitializedPropertyAccessException("connection");
                connection = null;
            }
            connection.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

