/*
 * Decompiled with CFR 0.152.
 */
package me.aviso.aceCurrency.api;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import kotlin.jvm.internal.Intrinsics;
import me.aviso.aceCurrency.api.CurrencyAPI;
import me.aviso.aceCurrency.database.Database;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public final class CurrencyAPIImpl
implements CurrencyAPI {
    @Override
    public int getCurrency(@NotNull Player player) {
        Intrinsics.checkNotNullParameter(player, "player");
        String string = player.getUniqueId().toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        String uuid = string;
        int amount = 0;
        String query = "SELECT amount FROM player_currency WHERE uuid = ?";
        Connection connection = Database.INSTANCE.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement(query);
            Intrinsics.checkNotNullExpressionValue(preparedStatement, "prepareStatement(...)");
            PreparedStatement statement = preparedStatement;
            statement.setString(1, uuid);
            ResultSet resultSet = statement.executeQuery();
            Intrinsics.checkNotNullExpressionValue(resultSet, "executeQuery(...)");
            ResultSet resultSet2 = resultSet;
            if (resultSet2.next()) {
                amount = resultSet2.getInt("amount");
            }
            resultSet2.close();
            statement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return amount;
    }

    @Override
    public boolean addCurrency(@NotNull Player player, int amount) {
        boolean bl;
        Intrinsics.checkNotNullParameter(player, "player");
        if (amount <= 0) {
            return false;
        }
        String string = player.getUniqueId().toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        String uuid = string;
        int currentAmount = this.getCurrency(player);
        String query = "INSERT INTO player_currency (uuid, amount) VALUES (?, ?) ON CONFLICT(uuid) DO UPDATE SET amount = ?";
        Connection connection = Database.INSTANCE.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement(query);
            Intrinsics.checkNotNullExpressionValue(preparedStatement, "prepareStatement(...)");
            PreparedStatement statement = preparedStatement;
            statement.setString(1, uuid);
            statement.setInt(2, currentAmount + amount);
            statement.setInt(3, currentAmount + amount);
            statement.executeUpdate();
            statement.close();
            bl = true;
        }
        catch (SQLException e) {
            e.printStackTrace();
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean setCurrency(@NotNull Player player, int amount) {
        boolean bl;
        Intrinsics.checkNotNullParameter(player, "player");
        if (amount < 0) {
            return false;
        }
        String string = player.getUniqueId().toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        String uuid = string;
        String query = "INSERT INTO player_currency (uuid, amount) VALUES (?, ?) ON CONFLICT(uuid) DO UPDATE SET amount = ?";
        Connection connection = Database.INSTANCE.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement(query);
            Intrinsics.checkNotNullExpressionValue(preparedStatement, "prepareStatement(...)");
            PreparedStatement statement = preparedStatement;
            statement.setString(1, uuid);
            statement.setInt(2, amount);
            statement.setInt(3, amount);
            statement.executeUpdate();
            statement.close();
            bl = true;
        }
        catch (SQLException e) {
            e.printStackTrace();
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean removeCurrency(@NotNull Player player, int amount) {
        boolean bl;
        Intrinsics.checkNotNullParameter(player, "player");
        if (amount <= 0) {
            return false;
        }
        String string = player.getUniqueId().toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        String uuid = string;
        int currentAmount = this.getCurrency(player);
        if (currentAmount < amount) {
            return false;
        }
        String query = "UPDATE player_currency SET amount = ? WHERE uuid = ?";
        Connection connection = Database.INSTANCE.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement(query);
            Intrinsics.checkNotNullExpressionValue(preparedStatement, "prepareStatement(...)");
            PreparedStatement statement = preparedStatement;
            statement.setInt(1, currentAmount - amount);
            statement.setString(2, uuid);
            statement.executeUpdate();
            statement.close();
            bl = true;
        }
        catch (SQLException e) {
            e.printStackTrace();
            bl = false;
        }
        return bl;
    }

    @Override
    public int getCurrencyUUID(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        int amount = 0;
        String query = "SELECT amount FROM player_currency WHERE uuid = ?";
        Connection connection = Database.INSTANCE.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement(query);
            Intrinsics.checkNotNullExpressionValue(preparedStatement, "prepareStatement(...)");
            PreparedStatement statement = preparedStatement;
            statement.setString(1, uuid.toString());
            ResultSet resultSet = statement.executeQuery();
            Intrinsics.checkNotNullExpressionValue(resultSet, "executeQuery(...)");
            ResultSet resultSet2 = resultSet;
            if (resultSet2.next()) {
                amount = resultSet2.getInt("amount");
            }
            resultSet2.close();
            statement.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return amount;
    }

    @Override
    public boolean addCurrencyUUID(@NotNull UUID uuid, int amount) {
        boolean bl;
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        if (amount <= 0) {
            return false;
        }
        int currentAmount = this.getCurrencyUUID(uuid);
        String query = "INSERT INTO player_currency (uuid, amount) VALUES (?, ?) ON CONFLICT(uuid) DO UPDATE SET amount = ?";
        Connection connection = Database.INSTANCE.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement(query);
            Intrinsics.checkNotNullExpressionValue(preparedStatement, "prepareStatement(...)");
            PreparedStatement statement = preparedStatement;
            statement.setString(1, uuid.toString());
            statement.setInt(2, currentAmount + amount);
            statement.setInt(3, currentAmount + amount);
            statement.executeUpdate();
            statement.close();
            bl = true;
        }
        catch (SQLException e) {
            e.printStackTrace();
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean setCurrencyUUID(@NotNull UUID uuid, int amount) {
        boolean bl;
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        if (amount < 0) {
            return false;
        }
        String query = "INSERT INTO player_currency (uuid, amount) VALUES (?, ?) ON CONFLICT(uuid) DO UPDATE SET amount = ?";
        Connection connection = Database.INSTANCE.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement(query);
            Intrinsics.checkNotNullExpressionValue(preparedStatement, "prepareStatement(...)");
            PreparedStatement statement = preparedStatement;
            statement.setString(1, uuid.toString());
            statement.setInt(2, amount);
            statement.setInt(3, amount);
            statement.executeUpdate();
            statement.close();
            bl = true;
        }
        catch (SQLException e) {
            e.printStackTrace();
            bl = false;
        }
        return bl;
    }

    @Override
    public boolean removeCurrencyUUID(@NotNull UUID uuid, int amount) {
        boolean bl;
        Intrinsics.checkNotNullParameter(uuid, "uuid");
        if (amount <= 0) {
            return false;
        }
        int currentAmount = this.getCurrencyUUID(uuid);
        if (currentAmount < amount) {
            return false;
        }
        String query = "UPDATE player_currency SET amount = ? WHERE uuid = ?";
        Connection connection = Database.INSTANCE.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement(query);
            Intrinsics.checkNotNullExpressionValue(preparedStatement, "prepareStatement(...)");
            PreparedStatement statement = preparedStatement;
            statement.setInt(1, currentAmount - amount);
            statement.setString(2, uuid.toString());
            statement.executeUpdate();
            statement.close();
            bl = true;
        }
        catch (SQLException e) {
            e.printStackTrace();
            bl = false;
        }
        return bl;
    }
}

