/*
 * Decompiled with CFR 0.152.
 */
package me.aviso.aceCurrency.database;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import kotlin.jvm.internal.Intrinsics;
import me.aviso.aceCurrency.AceCurrency;
import org.jetbrains.annotations.NotNull;

public final class Database {
    @NotNull
    public static final Database INSTANCE = new Database();
    private static Connection connection;
    @NotNull
    private static final String DATABASE_URL = "jdbc:sqlite:plugins/AceCurrency/database.db";

    private Database() {
    }

    public final void connect(@NotNull AceCurrency plugin) {
        File dbFile;
        Intrinsics.checkNotNullParameter((Object)plugin, "plugin");
        File dbDirectory = new File("plugins/AceCurrency");
        if (!dbDirectory.exists()) {
            dbDirectory.mkdirs();
        }
        if (!(dbFile = new File(dbDirectory, "database.db")).exists()) {
            try {
                dbFile.createNewFile();
            }
            catch (Exception e) {
                plugin.getLogger().severe("Could not create database file: " + e.getMessage());
                return;
            }
        }
        try {
            Connection connection = DriverManager.getConnection(DATABASE_URL);
            Intrinsics.checkNotNullExpressionValue(connection, "getConnection(...)");
            Database.connection = connection;
            this.createTable();
        }
        catch (SQLException e) {
            plugin.getLogger().severe("Could not connect to the database: " + e.getMessage());
        }
    }

    private final void createTable() {
        Connection connection = Database.connection;
        if (connection == null) {
            Intrinsics.throwUninitializedPropertyAccessException("connection");
            connection = null;
        }
        Statement statement = connection.createStatement();
        Intrinsics.checkNotNullExpressionValue(statement, "createStatement(...)");
        Statement statement2 = statement;
        statement2.executeUpdate("CREATE TABLE IF NOT EXISTS player_currency (uuid TEXT PRIMARY KEY, amount INTEGER)");
        statement2.close();
    }

    @NotNull
    public final Connection getConnection() {
        Connection connection = Database.connection;
        if (connection == null) {
            Intrinsics.throwUninitializedPropertyAccessException("connection");
            connection = null;
        }
        return connection;
    }

    public final void disconnect() {
        try {
            Connection connection = Database.connection;
            if (connection == null) {
                Intrinsics.throwUninitializedPropertyAccessException("connection");
                connection = null;
            }
            connection.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

