/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.wmb.api;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import org.texboobcat.wmb.dab.DabPolicy;

public final class WmbApi {
    private static final Set<String> EXEMPT_TYPES = ConcurrentHashMap.newKeySet();
    private static final Set<String> HIGH_PRIORITY_TYPES = ConcurrentHashMap.newKeySet();
    private static final Map<Mob, Boolean> FORCE_TICK = Collections.synchronizedMap(new WeakHashMap());

    private WmbApi() {
    }

    private static String keyOf(EntityType<?> type) {
        ResourceLocation key = BuiltInRegistries.f_256780_.m_7981_(type);
        return key != null ? key.toString() : String.valueOf(type);
    }

    public static void markExempt(EntityType<?> type) {
        EXEMPT_TYPES.add(WmbApi.keyOf(type));
    }

    public static void unmarkExempt(EntityType<?> type) {
        EXEMPT_TYPES.remove(WmbApi.keyOf(type));
    }

    public static boolean isExempt(EntityType<?> type) {
        return EXEMPT_TYPES.contains(WmbApi.keyOf(type));
    }

    public static void markHighPriority(EntityType<?> type) {
        HIGH_PRIORITY_TYPES.add(WmbApi.keyOf(type));
    }

    public static void unmarkHighPriority(EntityType<?> type) {
        HIGH_PRIORITY_TYPES.remove(WmbApi.keyOf(type));
    }

    public static boolean isHighPriority(EntityType<?> type) {
        return HIGH_PRIORITY_TYPES.contains(WmbApi.keyOf(type));
    }

    public static void requestImmediateTick(Mob mob) {
        if (mob != null) {
            FORCE_TICK.put(mob, Boolean.TRUE);
        }
    }

    public static boolean consumeImmediateTick(Mob mob) {
        if (mob == null) {
            return false;
        }
        return FORCE_TICK.remove(mob) != null;
    }

    public static int getDabInterval(Mob mob) {
        Level level = mob.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return 1;
        }
        ServerLevel level2 = (ServerLevel)level;
        double minDistSqr = Double.POSITIVE_INFINITY;
        for (ServerPlayer p : level2.m_6907_()) {
            double d2 = p.m_20280_((Entity)mob);
            if (!(d2 < minDistSqr)) continue;
            minDistSqr = d2;
        }
        return DabPolicy.computeInterval(mob, minDistSqr);
    }
}

