/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.wmb.api.event;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import net.minecraft.world.entity.Mob;

public final class WMBEntityTickEvent {
    private static final List<Consumer<Mob>> PRE_LISTENERS = new CopyOnWriteArrayList<Consumer<Mob>>();
    private static final List<Consumer<Mob>> POST_LISTENERS = new CopyOnWriteArrayList<Consumer<Mob>>();

    private WMBEntityTickEvent() {
    }

    public static void registerPre(Consumer<Mob> listener) {
        if (listener != null) {
            PRE_LISTENERS.add(listener);
        }
    }

    public static void unregisterPre(Consumer<Mob> listener) {
        PRE_LISTENERS.remove(listener);
    }

    public static void registerPost(Consumer<Mob> listener) {
        if (listener != null) {
            POST_LISTENERS.add(listener);
        }
    }

    public static void unregisterPost(Consumer<Mob> listener) {
        POST_LISTENERS.remove(listener);
    }

    public static void firePre(Mob mob) {
        for (Consumer<Mob> c : PRE_LISTENERS) {
            try {
                c.accept(mob);
            }
            catch (Throwable throwable) {}
        }
    }

    public static void firePost(Mob mob) {
        for (Consumer<Mob> c : POST_LISTENERS) {
            try {
                c.accept(mob);
            }
            catch (Throwable throwable) {}
        }
    }
}

