/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.wmb.api.event;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.pathfinder.Path;

public final class WMBPathfindRequestEvent {
    private static final List<Consumer<Context>> LISTENERS = new CopyOnWriteArrayList<Consumer<Context>>();

    private WMBPathfindRequestEvent() {
    }

    public static void register(Consumer<Context> listener) {
        if (listener != null) {
            LISTENERS.add(listener);
        }
    }

    public static void unregister(Consumer<Context> listener) {
        LISTENERS.remove(listener);
    }

    public static void fire(Context ctx) {
        for (Consumer<Context> c : LISTENERS) {
            try {
                c.accept(ctx);
            }
            catch (Throwable throwable) {}
        }
    }

    public static final class Context {
        public final Mob mob;
        public final String dimension;
        public final ChunkPos originChunk;
        public final long targetBucket;
        public final int tickNow;
        public final BlockPos targetPos;
        public final Entity targetEntity;
        private boolean cancel;
        private Path overridePath;

        public Context(Mob mob, String dimension, ChunkPos originChunk, long targetBucket, int tickNow, BlockPos targetPos, Entity targetEntity) {
            this.mob = mob;
            this.dimension = dimension;
            this.originChunk = originChunk;
            this.targetBucket = targetBucket;
            this.tickNow = tickNow;
            this.targetPos = targetPos;
            this.targetEntity = targetEntity;
        }

        public void cancel() {
            this.cancel = true;
        }

        public boolean isCancelled() {
            return this.cancel;
        }

        public void setPath(Path p) {
            this.overridePath = p;
        }

        public Path getPath() {
            return this.overridePath;
        }
    }
}

