/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.wmb.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.texboobcat.wmb.config.Presets;
import org.texboobcat.wmb.config.WmbConfig;
import org.texboobcat.wmb.dab.DabPolicy;
import org.texboobcat.wmb.metrics.Metrics;
import org.texboobcat.wmb.network.WmbNetwork;
import org.texboobcat.wmb.profile.Profiler;
import org.texboobcat.wmb.regional.RegionalTpsService;
import org.texboobcat.wmb.test.StressTestManager;
import org.texboobcat.wmb.tracking.AsyncEntityTracker;

public final class WmbCommands {
    private WmbCommands() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder root = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"wmb").requires(src -> src.m_6761_(2))).then(Commands.m_82127_((String)"reload").executes(ctx -> WmbCommands.reload((CommandSourceStack)ctx.getSource())))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"metrics").then(Commands.m_82127_((String)"on").executes(ctx -> WmbCommands.metricsToggle((CommandSourceStack)ctx.getSource(), true)))).then(Commands.m_82127_((String)"off").executes(ctx -> WmbCommands.metricsToggle((CommandSourceStack)ctx.getSource(), false))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"regions").then(Commands.m_82127_((String)"here").executes(ctx -> WmbCommands.regionsHere((CommandSourceStack)ctx.getSource())))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"top").then(Commands.m_82129_((String)"n", (ArgumentType)IntegerArgumentType.integer((int)1, (int)100)).executes(ctx -> WmbCommands.regionsTop((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"n"))))).executes(ctx -> WmbCommands.regionsTop((CommandSourceStack)ctx.getSource(), 10))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"heatmap").then(Commands.m_82129_((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1, (int)32)).executes(ctx -> WmbCommands.heatmap((CommandSourceStack)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"radius"))))).executes(ctx -> WmbCommands.heatmap((CommandSourceStack)ctx.getSource(), 8)))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"tuning").then(Commands.m_82127_((String)"on").executes(ctx -> WmbCommands.tuningToggle((CommandSourceStack)ctx.getSource(), true)))).then(Commands.m_82127_((String)"off").executes(ctx -> WmbCommands.tuningToggle((CommandSourceStack)ctx.getSource(), false))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"preset").then(Commands.m_82127_((String)"vanilla").executes(ctx -> WmbCommands.applyPreset((CommandSourceStack)ctx.getSource(), "VANILLA")))).then(Commands.m_82127_((String)"balanced").executes(ctx -> WmbCommands.applyPreset((CommandSourceStack)ctx.getSource(), "BALANCED")))).then(Commands.m_82127_((String)"aggressive").executes(ctx -> WmbCommands.applyPreset((CommandSourceStack)ctx.getSource(), "AGGRESSIVE"))))).then(Commands.m_82127_((String)"stats").executes(ctx -> WmbCommands.stats((CommandSourceStack)ctx.getSource())))).then(Commands.m_82127_((String)"trackerstats").executes(ctx -> WmbCommands.trackerStats((CommandSourceStack)ctx.getSource())))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"debug").then(Commands.m_82127_((String)"entity").executes(ctx -> WmbCommands.debugEntity((CommandSourceStack)ctx.getSource())))).then(Commands.m_82127_((String)"chunk").executes(ctx -> WmbCommands.debugChunk((CommandSourceStack)ctx.getSource()))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"profile").then(Commands.m_82127_((String)"start").executes(ctx -> WmbCommands.profileStart((CommandSourceStack)ctx.getSource())))).then(Commands.m_82127_((String)"stop").executes(ctx -> WmbCommands.profileStop((CommandSourceStack)ctx.getSource()))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"stresstest").then(Commands.m_82127_((String)"start").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"entity", (ArgumentType)ResourceLocationArgument.m_106984_()).executes(ctx -> WmbCommands.stressStart((CommandSourceStack)ctx.getSource(), ResourceLocationArgument.m_107011_((CommandContext)ctx, (String)"entity"), 100, 32, 1200, 20, 8, true))).then(Commands.m_82129_((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1, (int)5000)).then(Commands.m_82129_((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)4, (int)256)).then(Commands.m_82129_((String)"duration", (ArgumentType)IntegerArgumentType.integer((int)100, (int)72000)).then(Commands.m_82129_((String)"pathEvery", (ArgumentType)IntegerArgumentType.integer((int)0, (int)200)).then(Commands.m_82129_((String)"waypoints", (ArgumentType)IntegerArgumentType.integer((int)1, (int)64)).executes(ctx -> WmbCommands.stressStart((CommandSourceStack)ctx.getSource(), ResourceLocationArgument.m_107011_((CommandContext)ctx, (String)"entity"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"count"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"radius"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"duration"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"pathEvery"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"waypoints"), true)))))))))).then(Commands.m_82127_((String)"stop").executes(ctx -> WmbCommands.stressStop((CommandSourceStack)ctx.getSource())))).then(Commands.m_82127_((String)"status").executes(ctx -> WmbCommands.stressStatus((CommandSourceStack)ctx.getSource())))).then(Commands.m_82127_((String)"report").executes(ctx -> WmbCommands.stressReport((CommandSourceStack)ctx.getSource()))));
        dispatcher.register(root);
    }

    private static int heatmap(CommandSourceStack src, int radius) {
        try {
            ServerPlayer player = src.m_81375_();
            Level level = player.m_9236_();
            if (!(level instanceof ServerLevel)) {
                src.m_81352_((Component)Component.m_237113_((String)"[WMB] Not on server level."));
                return 0;
            }
            ServerLevel level2 = (ServerLevel)level;
            int r = Math.max(1, Math.min(32, radius));
            RegionalTpsService.Heatmap hm = RegionalTpsService.exportHeatmap(level2, player.m_20183_(), r);
            WmbNetwork.sendHeatmap(player, hm);
            src.m_288197_(() -> Component.m_237113_((String)("[WMB] Sent heatmap (" + hm.size + "x" + hm.size + ") to client.")), false);
            return 1;
        }
        catch (Exception e) {
            src.m_81352_((Component)Component.m_237113_((String)("[WMB] heatmap failed: " + e.getMessage())));
            return 0;
        }
    }

    private static int regionsHere(CommandSourceStack src) {
        try {
            ServerPlayer player = src.m_81375_();
            Level level = player.m_9236_();
            if (!(level instanceof ServerLevel)) {
                src.m_81352_((Component)Component.m_237113_((String)"[WMB] Not on server level."));
                return 0;
            }
            ServerLevel level2 = (ServerLevel)level;
            String s = RegionalTpsService.regionInfo(level2, player.m_20183_());
            src.m_288197_(() -> Component.m_237113_((String)("[WMB] Region: " + s)), false);
            return 1;
        }
        catch (Exception e) {
            src.m_81352_((Component)Component.m_237113_((String)("[WMB] regions here failed: " + e.getMessage())));
            return 0;
        }
    }

    private static int regionsTop(CommandSourceStack src, int n) {
        try {
            ServerPlayer player = src.m_81375_();
            Level level = player.m_9236_();
            if (!(level instanceof ServerLevel)) {
                src.m_81352_((Component)Component.m_237113_((String)"[WMB] Not on server level."));
                return 0;
            }
            ServerLevel level2 = (ServerLevel)level;
            List<String> list = RegionalTpsService.topRegions(n);
            if (list.isEmpty()) {
                src.m_288197_(() -> Component.m_237113_((String)"[WMB] No active regions."), false);
                return 1;
            }
            src.m_288197_(() -> Component.m_237113_((String)"[WMB] Top Regions (by avg AI ms):"), false);
            for (String s : list) {
                src.m_288197_(() -> Component.m_237113_((String)(" - " + s)), false);
            }
            return 1;
        }
        catch (Exception e) {
            src.m_81352_((Component)Component.m_237113_((String)("[WMB] regions top failed: " + e.getMessage())));
            return 0;
        }
    }

    private static int reload(CommandSourceStack src) {
        WmbConfig.reload();
        src.m_288197_(() -> Component.m_237113_((String)"[WMB] Config reloaded."), true);
        return 1;
    }

    private static int debugEntity(CommandSourceStack src) {
        try {
            String typeStr;
            ServerPlayer player = src.m_81375_();
            Level level = player.m_9236_();
            if (!(level instanceof ServerLevel)) {
                src.m_81352_((Component)Component.m_237113_((String)"[WMB] Not on server level."));
                return 0;
            }
            ServerLevel level2 = (ServerLevel)level;
            AABB box = player.m_20191_().m_82400_(16.0);
            List list = level2.m_45976_(Mob.class, box);
            Mob nearest = null;
            double nearestDist2 = Double.POSITIVE_INFINITY;
            for (Mob m : list) {
                double d2 = m.m_20280_((Entity)player);
                if (!(d2 < nearestDist2)) continue;
                nearestDist2 = d2;
                nearest = m;
            }
            if (nearest == null) {
                src.m_288197_(() -> Component.m_237113_((String)"[WMB] No mob within 16 blocks."), false);
                return 1;
            }
            double minDistSqr = Double.POSITIVE_INFINITY;
            for (ServerPlayer p : level2.m_6907_()) {
                double d2 = p.m_20280_((Entity)nearest);
                if (!(d2 < minDistSqr)) continue;
                minDistSqr = d2;
            }
            int interval = DabPolicy.computeInterval(nearest, minDistSqr);
            ResourceLocation key = BuiltInRegistries.f_256780_.m_7981_((Object)nearest.m_6095_());
            String typeStrF = typeStr = key != null ? key.toString() : nearest.m_7755_().getString();
            double ex = nearest.m_20185_();
            double ey = nearest.m_20186_();
            double ez = nearest.m_20189_();
            double dist = Math.sqrt(minDistSqr);
            int intervalF = interval;
            src.m_288197_(() -> Component.m_237113_((String)String.format("[WMB] Entity %s @ (%.1f, %.1f, %.1f) dist=%.2f interval=%d", typeStrF, ex, ey, ez, dist, intervalF)), false);
            return 1;
        }
        catch (Exception e) {
            src.m_81352_((Component)Component.m_237113_((String)("[WMB] debug entity failed: " + e.getMessage())));
            return 0;
        }
    }

    private static int debugChunk(CommandSourceStack src) {
        try {
            ServerPlayer player = src.m_81375_();
            Level level = player.m_9236_();
            if (!(level instanceof ServerLevel)) {
                src.m_81352_((Component)Component.m_237113_((String)"[WMB] Not on server level."));
                return 0;
            }
            ServerLevel level2 = (ServerLevel)level;
            ChunkPos cp = new ChunkPos(player.m_20183_());
            int x0 = cp.m_45604_();
            int z0 = cp.m_45605_();
            int x1 = x0 + 16;
            int z1 = z0 + 16;
            AABB area = new AABB((double)x0, (double)level2.m_141937_(), (double)z0, (double)x1, (double)level2.m_151558_(), (double)z1);
            List list = level2.m_45976_(Mob.class, area);
            int count = list.size();
            double avgInterval = 0.0;
            if (count > 0) {
                long sum = 0L;
                for (Mob m : list) {
                    double minDistSqr = Double.POSITIVE_INFINITY;
                    for (ServerPlayer p : level2.m_6907_()) {
                        double d2 = p.m_20280_((Entity)m);
                        if (!(d2 < minDistSqr)) continue;
                        minDistSqr = d2;
                    }
                    int iv = DabPolicy.computeInterval(m, minDistSqr);
                    sum += (long)iv;
                }
                avgInterval = (double)sum / (double)count;
            }
            int cx = cp.f_45578_;
            int cz = cp.f_45579_;
            int countF = count;
            double avgF = avgInterval;
            src.m_288197_(() -> Component.m_237113_((String)String.format("[WMB] Chunk %d,%d mobs=%d avgInterval=%.2f", cx, cz, countF, avgF)), false);
            return 1;
        }
        catch (Exception e) {
            src.m_81352_((Component)Component.m_237113_((String)("[WMB] debug chunk failed: " + e.getMessage())));
            return 0;
        }
    }

    private static int stats(CommandSourceStack src) {
        WmbConfig c = WmbConfig.get();
        src.m_288197_(() -> Component.m_237113_((String)("[WMB] DAB: " + (c.dab.enabled ? "enabled" : "disabled") + String.format(" d0=%.1f d1=%.1f d2=%.1f", c.dab.d0, c.dab.d1, c.dab.d2) + String.format(" hysteresis=%.1f", c.dab.hysteresisBlocks) + String.format(" multipliers[n=%d,m=%d,f=%d,d=%d]", c.dab.nearMultiplier, c.dab.midMultiplier, c.dab.farMultiplier, c.dab.distantMultiplier) + String.format(" per-dimension=%d", c.dab.perDimension.size()))), false);
        src.m_288197_(() -> Component.m_237113_((String)("[WMB] Proximity: updateIntervalTicks=" + c.proximity.updateIntervalTicks)), false);
        src.m_288197_(() -> Component.m_237113_((String)("[WMB] AsyncSpawn: " + (c.asyncSpawn.enabled ? "enabled" : "disabled") + " threads=" + c.asyncSpawn.threadPoolSize)), false);
        src.m_288197_(() -> Component.m_237113_((String)("[WMB] AsyncTracker: " + (c.asyncTracker.enabled ? "enabled" : "disabled") + " threads=" + c.asyncTracker.threadPoolSize + " updateInterval=" + c.asyncTracker.updateInterval + " cacheDuration=" + c.asyncTracker.cacheDuration)), false);
        src.m_288197_(() -> Component.m_237113_((String)("[WMB] Checks: suffocationInterval=" + c.checks.suffocationInterval)), false);
        src.m_288197_(() -> Component.m_237113_((String)("[WMB] Metrics: " + (c.metrics.enabled ? "enabled" : "disabled"))), false);
        src.m_288197_(() -> Component.m_237113_((String)("[WMB] Tuning: " + (c.tuning.enabled ? "enabled" : "disabled") + String.format(" targetTickMs=%.1f window=%d cooldown=%d minRecalc[%d..%d]", c.tuning.targetTickMs, c.tuning.windowTicks, c.tuning.cooldownTicks, c.tuning.minRecalcMin, c.tuning.minRecalcMax) + String.format(" pid[kp=%.3f,ki=%.3f,kd=%.3f] maxStep=%d iMax=%.1f", c.tuning.kp, c.tuning.ki, c.tuning.kd, c.tuning.maxStepPerWindow, c.tuning.integralMaxAbs))), false);
        src.m_288197_(() -> Component.m_237113_((String)("[WMB] PathfindingCfg: enabled=" + c.pathfinding.enabled + " minRecalcInterval=" + c.pathfinding.minRecalcInterval + " groupWindowTicks=" + c.pathfinding.groupWindowTicks + " cacheTtlTicks=" + c.pathfinding.cacheTtlTicks + " share=" + (c.pathfinding.experimentalShareEnabled ? "on" : "off"))), false);
        if (c.metrics.enabled) {
            Metrics.Snapshot s = Metrics.snapshot();
            src.m_288197_(() -> Component.m_237113_((String)String.format("[WMB] Metrics: aiExecuted=%d aiSkipped=%d avgInterval=%.2f", s.aiStepsExecuted, s.aiStepsSkipped, s.avgInterval())), false);
            src.m_288197_(() -> Component.m_237113_((String)String.format("[WMB] Metrics: skippedBreakdown [dab=%d, regional=%d, entity=%d, visibility=%d]", s.aiStepsSkippedDab, s.aiStepsSkippedRegional, s.aiStepsSkippedEntity, s.aiStepsSkippedVisibility)), false);
            src.m_288197_(() -> Component.m_237113_((String)String.format("[WMB] Pathfinding: calls=%d avg=%.2f\u00b5s shared{pub=%d,claim=%d}", s.pathfindCount, s.avgPathfindMicros(), s.pathSharedPublished, s.pathSharedClaimed)), false);
            src.m_288197_(() -> Component.m_237113_((String)String.format("[WMB] AsyncSpawn: fillBatches=%d avgFill=%.2fms candidates=%d", s.spawnFillBatches, s.avgSpawnFillMillis(), s.spawnCandidateCount)), false);
            src.m_288197_(() -> Component.m_237113_((String)String.format("[WMB] Tick: avg=%.2fms TPS=%.2f", s.avgTickMillis(), s.tps())), false);
        }
        return 1;
    }

    private static int trackerStats(CommandSourceStack src) {
        WmbConfig c = WmbConfig.get();
        src.m_288197_(() -> Component.m_237113_((String)AsyncEntityTracker.getStatusString()), false);
        if (c.metrics.enabled) {
            Metrics.Snapshot s = Metrics.snapshot();
            src.m_288197_(() -> Component.m_237113_((String)String.format("[WMB] TrackerMetrics: tasks=%d avg=%.3fms queue=%d", s.trackerTaskCount, s.avgTrackerTaskMillis(), s.trackerQueueSize)), false);
        }
        return 1;
    }

    private static int profileStart(CommandSourceStack src) {
        Profiler.start();
        src.m_288197_(() -> Component.m_237113_((String)"[WMB] Profiling started."), true);
        return 1;
    }

    private static int profileStop(CommandSourceStack src) {
        Profiler.ProfileSnapshot snap = Profiler.stop();
        double avgMicros = snap.avgAiMicros();
        double totalMillis = (double)snap.totalAiNanos / 1000000.0;
        src.m_288197_(() -> Component.m_237113_((String)String.format("[WMB] Profiling stopped. AI steps=%d total=%.2fms avg=%.2f\u00b5s", snap.totalAiCount, totalMillis, avgMicros)), true);
        return 1;
    }

    private static int stressStart(CommandSourceStack src, ResourceLocation entityId, int count, int radius, int duration, int pathEvery, int waypoints, boolean cleanup) {
        try {
            ServerPlayer player = src.m_81375_();
            Level level = player.m_9236_();
            if (!(level instanceof ServerLevel)) {
                src.m_81352_((Component)Component.m_237113_((String)"[WMB] Not on server level."));
                return 0;
            }
            ServerLevel level2 = (ServerLevel)level;
            EntityType type = (EntityType)BuiltInRegistries.f_256780_.m_7745_(entityId);
            if (type == null) {
                src.m_81352_((Component)Component.m_237113_((String)("[WMB] Unknown entity id: " + String.valueOf(entityId))));
                return 0;
            }
            if (!(type.m_20615_((Level)level2) instanceof Mob)) {
                src.m_81352_((Component)Component.m_237113_((String)"[WMB] Entity must be a Mob type."));
                return 0;
            }
            EntityType mobType = type;
            BlockPos center = player.m_20183_();
            String dimId = level2.m_46472_().m_135782_().toString();
            StressTestManager.ScenarioConfig cfg = new StressTestManager.ScenarioConfig((EntityType<? extends Mob>)mobType, count, radius, duration, pathEvery, waypoints, cleanup, center, dimId);
            if (StressTestManager.isRunning()) {
                src.m_81352_((Component)Component.m_237113_((String)"[WMB] Stress test already running."));
                return 0;
            }
            boolean ok = StressTestManager.start(level2, cfg);
            if (!ok) {
                src.m_81352_((Component)Component.m_237113_((String)"[WMB] Failed to start stress test."));
                return 0;
            }
            src.m_288197_(() -> Component.m_237113_((String)("[WMB] Stress test started: entity=" + String.valueOf(entityId) + " count=" + count + " radius=" + radius + " duration=" + duration + " pathEvery=" + pathEvery + " waypoints=" + waypoints)), true);
            return 1;
        }
        catch (Exception e) {
            src.m_81352_((Component)Component.m_237113_((String)("[WMB] stress start failed: " + e.getMessage())));
            return 0;
        }
    }

    private static int stressStop(CommandSourceStack src) {
        try {
            ServerPlayer player = src.m_81375_();
            Level level = player.m_9236_();
            if (!(level instanceof ServerLevel)) {
                src.m_81352_((Component)Component.m_237113_((String)"[WMB] Not on server level."));
                return 0;
            }
            ServerLevel level2 = (ServerLevel)level;
            if (!StressTestManager.isRunning()) {
                src.m_81352_((Component)Component.m_237113_((String)"[WMB] No stress test running."));
                return 0;
            }
            StressTestManager.stop(level2);
            src.m_288197_(() -> Component.m_237113_((String)"[WMB] Stress test stopped. Report printed to console."), true);
            return 1;
        }
        catch (Exception e) {
            src.m_81352_((Component)Component.m_237113_((String)("[WMB] stress stop failed: " + e.getMessage())));
            return 0;
        }
    }

    private static int stressStatus(CommandSourceStack src) {
        String s = StressTestManager.statusString();
        src.m_288197_(() -> Component.m_237113_((String)s), false);
        return 1;
    }

    private static int stressReport(CommandSourceStack src) {
        String s = StressTestManager.liveReport();
        src.m_288197_(() -> Component.m_237113_((String)s), false);
        return 1;
    }

    private static int applyPreset(CommandSourceStack src, String name) {
        WmbConfig cfg = WmbConfig.get();
        boolean ok = Presets.apply(cfg, name);
        if (!ok) {
            src.m_81352_((Component)Component.m_237113_((String)("[WMB] Unknown preset: " + name)));
            return 0;
        }
        src.m_288197_(() -> Component.m_237113_((String)("[WMB] Preset applied: " + name + " (runtime only). Use /wmb reload to revert from file.")), true);
        return 1;
    }

    private static int tuningToggle(CommandSourceStack src, boolean on) {
        WmbConfig cfg = WmbConfig.get();
        cfg.tuning.enabled = on;
        src.m_288197_(() -> Component.m_237113_((String)("[WMB] Tuning " + (on ? "enabled" : "disabled"))), true);
        return 1;
    }

    private static int metricsToggle(CommandSourceStack src, boolean on) {
        WmbConfig cfg = WmbConfig.get();
        cfg.metrics.enabled = on;
        src.m_288197_(() -> Component.m_237113_((String)("[WMB] Metrics " + (on ? "enabled" : "disabled"))), true);
        return 1;
    }
}

