/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.wmb.mixin;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.texboobcat.wmb.api.WmbApi;
import org.texboobcat.wmb.api.event.WMBEntityTickEvent;
import org.texboobcat.wmb.config.WmbConfig;
import org.texboobcat.wmb.dab.DabPolicy;
import org.texboobcat.wmb.metrics.Metrics;
import org.texboobcat.wmb.profile.Profiler;
import org.texboobcat.wmb.proximity.ProximityService;
import org.texboobcat.wmb.regional.RegionalTpsService;

@Mixin(value={Mob.class})
public abstract class MobMixin {
    @Unique
    private int wmb$currentInterval = 1;
    @Unique
    private int wmb$counter = 0;
    @Unique
    private long wmb$profileStartNanos = 0L;
    @Unique
    private int wmb$cullCounter = 0;
    @Unique
    private int wmb$visCounter = 0;
    @Unique
    private boolean wmb$nextIntervalRegionalDominant = false;
    @Unique
    private boolean wmb$activeRegionalDominant = false;
    @Unique
    private WmbConfig wmb$cachedConfig = null;
    @Unique
    private int wmb$configCacheTick = Integer.MIN_VALUE;
    @Unique
    private static final int CONFIG_CACHE_INTERVAL = 100;
    @Unique
    private ChunkPos wmb$tempMobChunk = null;
    @Unique
    private ChunkPos wmb$tempPlayerChunk = null;
    @Unique
    private boolean wmb$isExempt = false;
    @Unique
    private int wmb$exemptCacheTick = Integer.MIN_VALUE;
    @Unique
    private static final int EXEMPT_CACHE_INTERVAL = 200;
    @Unique
    private double wmb$cachedMinDistSqr = Double.POSITIVE_INFINITY;
    @Unique
    private int wmb$distCacheTick = Integer.MIN_VALUE;

    @Inject(method={"serverAiStep"}, at={@At(value="HEAD")}, cancellable=true)
    private void wmb$throttleServerAiStep(CallbackInfo ci) {
        Mob self = (Mob)this;
        Level level = self.m_9236_();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        int currentTick = self.f_19797_;
        WmbConfig config = this.getCachedConfig(currentTick);
        boolean forceTick = WmbApi.consumeImmediateTick(self);
        if (forceTick) {
            this.wmb$counter = 0;
            this.executeAiStep(self, config, currentTick);
            return;
        }
        double minDistSqr = this.getCachedPlayerDistance(self, serverLevel, currentTick);
        if (config.culling.enabled && this.shouldCullByEntityCriteria(self, minDistSqr, config, currentTick)) {
            if (this.handleCullingCounter(this.wmb$cullCounter, config.culling.allowEveryNTicks, config.metrics.enabled, () -> Metrics.onAiStepSkippedEntity(), ci)) {
                ++this.wmb$cullCounter;
                return;
            }
            this.wmb$cullCounter = 0;
        } else {
            this.wmb$cullCounter = 0;
        }
        if (config.visibility.enabled && this.shouldCullByVisibility(self, (Level)serverLevel, config, currentTick)) {
            if (this.handleCullingCounter(this.wmb$visCounter, config.visibility.allowEveryNTicks, config.metrics.enabled, () -> Metrics.onAiStepSkippedVisibility(), ci)) {
                ++this.wmb$visCounter;
                return;
            }
            this.wmb$visCounter = 0;
        } else {
            this.wmb$visCounter = 0;
        }
        int dabInterval = DabPolicy.computeInterval(self, minDistSqr, this.wmb$currentInterval);
        int regionMul = 1;
        try {
            boolean exempt = false;
            try {
                EntityType type = self.m_6095_();
                if (WmbApi.isExempt(type)) {
                    exempt = true;
                }
                if (type == EntityType.f_20496_ || type == EntityType.f_20565_) {
                    exempt = true;
                }
            }
            catch (Throwable type) {
                // empty catch block
            }
            try {
                if (self.m_21523_() || self.m_8077_()) {
                    exempt = true;
                }
            }
            catch (Throwable type) {
                // empty catch block
            }
            try {
                OwnableEntity own;
                if (self instanceof OwnableEntity && (own = (OwnableEntity)self).m_269323_() != null) {
                    exempt = true;
                }
            }
            catch (Throwable own) {
                // empty catch block
            }
            regionMul = !exempt ? RegionalTpsService.currentRegionMultiplier(serverLevel, self.m_20183_()) : 1;
        }
        catch (Throwable exempt) {
            // empty catch block
        }
        int targetInterval = dabInterval;
        boolean regionalDominant = false;
        if (regionMul > targetInterval) {
            targetInterval = regionMul;
            regionalDominant = true;
        }
        this.wmb$nextIntervalRegionalDominant = regionalDominant;
        this.updateInterval(targetInterval);
        if (this.wmb$counter > 0) {
            --this.wmb$counter;
            if (config.metrics.enabled) {
                if (this.wmb$activeRegionalDominant) {
                    Metrics.onAiStepSkippedRegional();
                } else {
                    Metrics.onAiStepSkippedDab();
                }
            }
            ci.cancel();
            return;
        }
        this.executeAiStep(self, config, currentTick);
    }

    @Inject(method={"serverAiStep"}, at={@At(value="TAIL")})
    private void wmb$profileServerAiStepTail(CallbackInfo ci) {
        Mob self = (Mob)this;
        if (this.wmb$profileStartNanos != 0L) {
            Level lvl;
            long duration = System.nanoTime() - this.wmb$profileStartNanos;
            this.wmb$profileStartNanos = 0L;
            if (Profiler.isActive()) {
                Profiler.recordAiDuration(duration);
            }
            if ((lvl = self.m_9236_()) instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)lvl;
                try {
                    RegionalTpsService.recordEntityAiDuration(sl, self.m_20183_(), duration);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        WMBEntityTickEvent.firePost(self);
    }

    @Unique
    private void executeAiStep(Mob self, WmbConfig config, int currentTick) {
        WMBEntityTickEvent.firePre(self);
        this.wmb$counter = Math.max(0, this.wmb$currentInterval - 1);
        this.wmb$activeRegionalDominant = this.wmb$nextIntervalRegionalDominant;
        if (config.metrics.enabled) {
            Metrics.onAiStepExecuted(this.wmb$currentInterval);
        }
        this.wmb$profileStartNanos = System.nanoTime();
    }

    @Unique
    private void updateInterval(int targetInterval) {
        this.wmb$currentInterval = targetInterval < this.wmb$currentInterval ? Math.max(targetInterval, this.wmb$currentInterval - 1) : targetInterval;
    }

    @Unique
    private boolean handleCullingCounter(int counter, int allowEvery, boolean metricsEnabled, Runnable metricsCallback, CallbackInfo ci) {
        int every = Math.max(1, allowEvery);
        if (counter < every - 1) {
            if (metricsEnabled) {
                metricsCallback.run();
            }
            ci.cancel();
            return true;
        }
        return false;
    }

    @Unique
    private WmbConfig getCachedConfig(int currentTick) {
        if (this.wmb$cachedConfig == null || currentTick - this.wmb$configCacheTick >= 100) {
            this.wmb$cachedConfig = WmbConfig.get();
            this.wmb$configCacheTick = currentTick;
        }
        return this.wmb$cachedConfig;
    }

    @Unique
    private double getCachedPlayerDistance(Mob self, ServerLevel level, int currentTick) {
        if (currentTick - this.wmb$distCacheTick >= 2) {
            Vec3 mobPos = self.m_20182_();
            this.wmb$cachedMinDistSqr = ProximityService.nearestPlayerDistSqr(level, mobPos.f_82479_, mobPos.f_82480_, mobPos.f_82481_);
            this.wmb$distCacheTick = currentTick;
        }
        return this.wmb$cachedMinDistSqr;
    }

    @Unique
    private boolean getCachedExemption(Mob mob, boolean exemptNamed, boolean exemptLeashed, boolean exemptOwned, boolean exemptPersistent, int currentTick) {
        if (currentTick - this.wmb$exemptCacheTick >= 200) {
            this.wmb$isExempt = MobMixin.isExemptCommon(mob, exemptNamed, exemptLeashed, exemptOwned, exemptPersistent);
            this.wmb$exemptCacheTick = currentTick;
        }
        return this.wmb$isExempt;
    }

    @Unique
    private ChunkPos getOrCreateMobChunk(Mob mob) {
        int x = mob.m_146903_() >> 4;
        int z = mob.m_146907_() >> 4;
        if (this.wmb$tempMobChunk == null || this.wmb$tempMobChunk.f_45578_ != x || this.wmb$tempMobChunk.f_45579_ != z) {
            this.wmb$tempMobChunk = new ChunkPos(x, z);
        }
        return this.wmb$tempMobChunk;
    }

    @Unique
    private ChunkPos getOrCreatePlayerChunk(Player player) {
        int x = player.m_146903_() >> 4;
        int z = player.m_146907_() >> 4;
        if (this.wmb$tempPlayerChunk == null || this.wmb$tempPlayerChunk.f_45578_ != x || this.wmb$tempPlayerChunk.f_45579_ != z) {
            this.wmb$tempPlayerChunk = new ChunkPos(x, z);
        }
        return this.wmb$tempPlayerChunk;
    }

    @Unique
    private static boolean isOwned(Mob mob) {
        OwnableEntity own;
        return mob instanceof OwnableEntity && (own = (OwnableEntity)mob).m_269323_() != null;
    }

    @Unique
    private static boolean isLowMotion(Mob mob, double speedThreshold) {
        double thresholdSqr;
        Vec3 deltaMovement = mob.m_20184_();
        double speedSqr = deltaMovement.m_82556_();
        return speedSqr <= (thresholdSqr = speedThreshold * speedThreshold);
    }

    @Unique
    private static boolean noActivePath(Mob mob) {
        try {
            PathNavigation navigation = mob.m_21573_();
            return navigation == null || navigation.m_26571_();
        }
        catch (Throwable ignored) {
            return true;
        }
    }

    @Unique
    private static boolean hasTarget(Mob mob) {
        try {
            return mob.m_5448_() != null;
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    @Unique
    private static boolean isExemptCommon(Mob mob, boolean exemptNamed, boolean exemptLeashed, boolean exemptOwned, boolean exemptPersistent) {
        if (exemptLeashed && mob.m_21523_()) {
            return true;
        }
        if (exemptNamed && mob.m_8077_()) {
            return true;
        }
        if (exemptOwned && MobMixin.isOwned(mob)) {
            return true;
        }
        if (exemptPersistent) {
            try {
                if (mob.m_21532_()) {
                    return true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            return WmbApi.isExempt(mob.m_6095_()) || WmbApi.isHighPriority(mob.m_6095_());
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    @Unique
    private boolean shouldCullByEntityCriteria(Mob mob, double nearestPlayerDistSqr, WmbConfig config, int currentTick) {
        WmbConfig.CullingCfg cullingCfg = config.culling;
        if (!cullingCfg.enabled) {
            return false;
        }
        if (this.getCachedExemption(mob, cullingCfg.exemptNamed, cullingCfg.exemptLeashed, cullingCfg.exemptOwned, cullingCfg.exemptPersistent, currentTick)) {
            return false;
        }
        double distance = Math.sqrt(nearestPlayerDistSqr);
        if (distance < cullingCfg.minDistance) {
            return false;
        }
        if (cullingCfg.requireNoTarget && MobMixin.hasTarget(mob)) {
            return false;
        }
        if (cullingCfg.requireNoPath && !MobMixin.noActivePath(mob)) {
            return false;
        }
        return !cullingCfg.requireLowMotion || MobMixin.isLowMotion(mob, cullingCfg.lowMotionSpeed);
    }

    @Unique
    private boolean shouldCullByVisibility(Mob mob, Level level, WmbConfig config, int currentTick) {
        WmbConfig.VisibilityCfg visibilityCfg = config.visibility;
        if (!visibilityCfg.enabled) {
            return false;
        }
        if (this.getCachedExemption(mob, visibilityCfg.exemptNamed, visibilityCfg.exemptLeashed, visibilityCfg.exemptOwned, visibilityCfg.exemptPersistent, currentTick)) {
            return false;
        }
        ChunkPos mobChunk = this.getOrCreateMobChunk(mob);
        int range = Math.max(0, visibilityCfg.playerChunkRange);
        boolean hasNearbyPlayer = false;
        for (Player player : level.m_6907_()) {
            ChunkPos playerChunk = this.getOrCreatePlayerChunk(player);
            int chebDistance = Math.max(Math.abs(playerChunk.f_45578_ - mobChunk.f_45578_), Math.abs(playerChunk.f_45579_ - mobChunk.f_45579_));
            if (chebDistance > range) continue;
            hasNearbyPlayer = true;
            break;
        }
        if (hasNearbyPlayer) {
            return false;
        }
        if (visibilityCfg.requireNoTarget && MobMixin.hasTarget(mob)) {
            return false;
        }
        if (visibilityCfg.requireNoPath && !MobMixin.noActivePath(mob)) {
            return false;
        }
        return !visibilityCfg.requireLowMotion || MobMixin.isLowMotion(mob, visibilityCfg.lowMotionSpeed);
    }
}

