/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.wmb.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.chunk.LevelChunk;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.texboobcat.wmb.config.WmbConfig;
import org.texboobcat.wmb.spawn.AsyncSpawnManager;

@Mixin(value={NaturalSpawner.class})
public class NaturalSpawnerMixin {
    @Inject(method={"getRandomPosWithin"}, at={@At(value="HEAD")}, cancellable=true)
    private static void wmb$randomPosAsync(Level level, LevelChunk chunk, CallbackInfoReturnable<BlockPos> cir) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (WmbConfig.get().asyncSpawn.enabled) {
                BlockPos pos = AsyncSpawnManager.nextOrRandom(serverLevel, chunk);
                cir.setReturnValue((Object)pos);
                cir.cancel();
            }
        }
    }
}

