/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.wmb.mixin;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.texboobcat.wmb.api.event.WMBPathfindRequestEvent;
import org.texboobcat.wmb.config.WmbConfig;
import org.texboobcat.wmb.metrics.Metrics;
import org.texboobcat.wmb.path.PathGroupManager;
import org.texboobcat.wmb.path.SharedPathRegistry;

@Mixin(value={PathNavigation.class})
public abstract class PathNavigationMixin {
    @Shadow
    protected Mob f_26494_;
    @Unique
    private int wmb$lastPathTick = Integer.MIN_VALUE;
    @Unique
    private long wmb$lastTargetBucket = Long.MIN_VALUE;
    @Unique
    private int wmb$lastCacheTick = Integer.MIN_VALUE;
    @Unique
    private Path wmb$cachedPath = null;
    @Unique
    private long wmb$pfStartNanos = 0L;
    @Unique
    private WmbConfig wmb$cachedConfig = null;
    @Unique
    private int wmb$configCacheTick = Integer.MIN_VALUE;
    @Unique
    private static final int CONFIG_CACHE_INTERVAL = 100;
    @Unique
    private ChunkPos wmb$tempOriginChunk = null;
    @Unique
    private ChunkPos wmb$tempTargetChunk = null;

    @Shadow
    public abstract Path m_26570_();

    @Inject(method={"createPath(Lnet/minecraft/core/BlockPos;I)Lnet/minecraft/world/level/pathfinder/Path;"}, at={@At(value="HEAD")}, cancellable=true)
    private void wmb$throttleCreatePathToPos(BlockPos target, int depth, CallbackInfoReturnable<Path> cir) {
        ChunkPos targetChunk;
        long bucket;
        WmbConfig config = this.getCachedConfig();
        if (!config.pathfinding.enabled) {
            return;
        }
        ChunkPos origin = this.getOrCreateOriginChunk();
        if (this.handlePathfindingLogic(origin, bucket = PathGroupManager.bucketForTargetPos(targetChunk = this.getOrCreateTargetChunk(target)), target, null, config, cir)) {
            return;
        }
    }

    @Inject(method={"createPath(Lnet/minecraft/world/entity/Entity;I)Lnet/minecraft/world/level/pathfinder/Path;"}, at={@At(value="HEAD")}, cancellable=true)
    private void wmb$throttleCreatePathToEntity(Entity target, int depth, CallbackInfoReturnable<Path> cir) {
        long bucket;
        WmbConfig config = this.getCachedConfig();
        if (!config.pathfinding.enabled) {
            return;
        }
        ChunkPos origin = this.getOrCreateOriginChunk();
        if (this.handlePathfindingLogic(origin, bucket = PathGroupManager.bucketForTargetEntity(target.m_19879_()), null, target, config, cir)) {
            return;
        }
    }

    @Inject(method={"createPath(Lnet/minecraft/core/BlockPos;I)Lnet/minecraft/world/level/pathfinder/Path;"}, at={@At(value="RETURN")})
    private void wmb$cacheOnReturnPos(BlockPos target, int depth, CallbackInfoReturnable<Path> cir) {
        WmbConfig config = this.getCachedConfig();
        if (!config.pathfinding.enabled) {
            return;
        }
        ChunkPos targetChunk = this.getOrCreateTargetChunk(target);
        this.handleCacheUpdate(PathGroupManager.bucketForTargetPos(targetChunk), (Path)cir.getReturnValue(), config);
        this.recordMetrics(config);
    }

    @Inject(method={"createPath(Lnet/minecraft/world/entity/Entity;I)Lnet/minecraft/world/level/pathfinder/Path;"}, at={@At(value="RETURN")})
    private void wmb$cacheOnReturnEntity(Entity target, int depth, CallbackInfoReturnable<Path> cir) {
        WmbConfig config = this.getCachedConfig();
        if (!config.pathfinding.enabled) {
            return;
        }
        this.handleCacheUpdate(PathGroupManager.bucketForTargetEntity(target.m_19879_()), (Path)cir.getReturnValue(), config);
        this.recordMetrics(config);
    }

    @Unique
    private boolean handlePathfindingLogic(ChunkPos origin, long bucket, BlockPos targetPos, Entity targetEntity, WmbConfig config, CallbackInfoReturnable<Path> cir) {
        Level level = this.f_26494_.m_9236_();
        int now = this.f_26494_.f_19797_;
        String dim = level.m_46472_().m_135782_().toString();
        WMBPathfindRequestEvent.Context ctx = new WMBPathfindRequestEvent.Context(this.f_26494_, dim, origin, bucket, now, targetPos, targetEntity);
        WMBPathfindRequestEvent.fire(ctx);
        if (ctx.getPath() != null) {
            cir.setReturnValue((Object)ctx.getPath());
            cir.cancel();
            return true;
        }
        if (ctx.isCancelled()) {
            cir.setReturnValue(null);
            cir.cancel();
            return true;
        }
        this.wmb$pfStartNanos = config.metrics.enabled ? System.nanoTime() : 0L;
        return this.handleThrottle(bucket, origin, dim, now, config, cir);
    }

    @Unique
    private boolean handleThrottle(long targetBucket, ChunkPos origin, String dim, int now, WmbConfig config, CallbackInfoReturnable<Path> cir) {
        Path claimed;
        Path reusedPath;
        int timeSinceLastPath;
        int minInterval = config.pathfinding.minRecalcInterval;
        if (targetBucket == this.wmb$lastTargetBucket && (timeSinceLastPath = now - this.wmb$lastPathTick) >= 0 && timeSinceLastPath < minInterval && (reusedPath = this.reusePathIfFresh(now, config.pathfinding.cacheTtlTicks)) != null) {
            cir.setReturnValue((Object)reusedPath);
            cir.cancel();
            return true;
        }
        if (config.pathfinding.experimentalShareEnabled && (claimed = SharedPathRegistry.tryClaim(dim, origin, targetBucket, now, config.pathfinding.shareTtlTicks)) != null) {
            cir.setReturnValue((Object)claimed);
            cir.cancel();
            return true;
        }
        if (PathGroupManager.shouldDefer(dim, origin, targetBucket, config.pathfinding.groupWindowTicks, now)) {
            Path reusedPath2 = this.reusePathIfFresh(now, config.pathfinding.cacheTtlTicks);
            if (reusedPath2 != null) {
                cir.setReturnValue((Object)reusedPath2);
                cir.cancel();
                return true;
            }
            if (now - this.wmb$lastPathTick < minInterval) {
                cir.setReturnValue(null);
                cir.cancel();
                return true;
            }
        }
        return false;
    }

    @Unique
    private void handleCacheUpdate(long targetBucket, Path result, WmbConfig config) {
        int now = this.f_26494_.f_19797_;
        this.wmb$lastTargetBucket = targetBucket;
        this.wmb$lastPathTick = now;
        if (result != null) {
            this.wmb$cachedPath = result;
            this.wmb$lastCacheTick = now;
            if (config.pathfinding.experimentalShareEnabled) {
                Level level = this.f_26494_.m_9236_();
                String dim = level.m_46472_().m_135782_().toString();
                ChunkPos origin = this.getOrCreateOriginChunk();
                SharedPathRegistry.publish(dim, origin, targetBucket, result, now);
            }
        }
    }

    @Unique
    private Path reusePathIfFresh(int now, int ttl) {
        int age;
        if (this.wmb$cachedPath != null && (age = now - this.wmb$lastCacheTick) >= 0 && age <= ttl) {
            return this.wmb$cachedPath;
        }
        Path current = this.m_26570_();
        if (current != null) {
            this.wmb$cachedPath = current;
            this.wmb$lastCacheTick = now;
            return current;
        }
        return null;
    }

    @Unique
    private void recordMetrics(WmbConfig config) {
        if (config.metrics.enabled && this.wmb$pfStartNanos != 0L) {
            long nanos = System.nanoTime() - this.wmb$pfStartNanos;
            if (nanos > 0L) {
                Metrics.onPathfindDuration(nanos);
            }
            this.wmb$pfStartNanos = 0L;
        }
    }

    @Unique
    private WmbConfig getCachedConfig() {
        int now = this.f_26494_.f_19797_;
        if (this.wmb$cachedConfig == null || now - this.wmb$configCacheTick >= 100) {
            this.wmb$cachedConfig = WmbConfig.get();
            this.wmb$configCacheTick = now;
        }
        return this.wmb$cachedConfig;
    }

    @Unique
    private ChunkPos getOrCreateOriginChunk() {
        BlockPos pos = this.f_26494_.m_20183_();
        if (this.wmb$tempOriginChunk == null) {
            this.wmb$tempOriginChunk = new ChunkPos(pos);
        } else {
            int currentX = pos.m_123341_() >> 4;
            int currentZ = pos.m_123343_() >> 4;
            if (this.wmb$tempOriginChunk.f_45578_ != currentX || this.wmb$tempOriginChunk.f_45579_ != currentZ) {
                this.wmb$tempOriginChunk = new ChunkPos(pos);
            }
        }
        return this.wmb$tempOriginChunk;
    }

    @Unique
    private ChunkPos getOrCreateTargetChunk(BlockPos target) {
        if (this.wmb$tempTargetChunk == null) {
            this.wmb$tempTargetChunk = new ChunkPos(target);
        } else {
            int targetX = target.m_123341_() >> 4;
            int targetZ = target.m_123343_() >> 4;
            if (this.wmb$tempTargetChunk.f_45578_ != targetX || this.wmb$tempTargetChunk.f_45579_ != targetZ) {
                this.wmb$tempTargetChunk = new ChunkPos(target);
            }
        }
        return this.wmb$tempTargetChunk;
    }
}

