/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.wmb.network;

import dev.architectury.networking.NetworkManager;
import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import org.texboobcat.wmb.client.HeatmapScreen;
import org.texboobcat.wmb.client.WmbClient;
import org.texboobcat.wmb.regional.RegionalTpsService;

public final class WmbNetwork {
    public static final ResourceLocation HEATMAP_S2C = new ResourceLocation("wmb", "heatmap");
    public static final ResourceLocation HEATMAP_REQ_C2S = new ResourceLocation("wmb", "heatmap_req");
    public static final ResourceLocation REGION_DETAIL_C2S = new ResourceLocation("wmb", "region_detail_req");
    public static final ResourceLocation REGION_DETAIL_S2C = new ResourceLocation("wmb", "region_detail");

    private WmbNetwork() {
    }

    public static void init() {
        EnvExecutor.runInEnv((Env)Env.CLIENT, () -> () -> WmbNetwork.registerClientReceivers());
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)REGION_DETAIL_C2S, (buf, ctx) -> {
            String dim = WmbNetwork.readString(buf);
            int rx = buf.m_130242_();
            int rz = buf.m_130242_();
            ServerPlayer sp = (ServerPlayer)ctx.getPlayer();
            if (sp == null || sp.f_8924_ == null) {
                return;
            }
            sp.f_8924_.execute(() -> {
                ServerLevel level = WmbNetwork.getServerLevelByDim(sp, dim);
                if (level != null) {
                    RegionalTpsService.RegionDetail detail = RegionalTpsService.exportRegionDetail(level, dim, rx, rz);
                    FriendlyByteBuf out = new FriendlyByteBuf(Unpooled.buffer());
                    WmbNetwork.encodeRegionDetail(out, detail);
                    NetworkManager.sendToPlayer((ServerPlayer)sp, (ResourceLocation)REGION_DETAIL_S2C, (FriendlyByteBuf)out);
                }
            });
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)HEATMAP_REQ_C2S, (buf, ctx) -> {
            String dim = WmbNetwork.readString(buf);
            int originRx = buf.m_130242_();
            int originRz = buf.m_130242_();
            int size = buf.m_130242_();
            ServerPlayer sp = (ServerPlayer)ctx.getPlayer();
            if (sp == null || sp.f_8924_ == null) {
                return;
            }
            sp.f_8924_.execute(() -> {
                ServerLevel level = WmbNetwork.getServerLevelByDim(sp, dim);
                if (level != null) {
                    RegionalTpsService.Heatmap hm = RegionalTpsService.exportHeatmapByOrigin(level, dim, originRx, originRz, size);
                    FriendlyByteBuf out = new FriendlyByteBuf(Unpooled.buffer());
                    WmbNetwork.encodeHeatmap(out, hm);
                    NetworkManager.sendToPlayer((ServerPlayer)sp, (ResourceLocation)HEATMAP_S2C, (FriendlyByteBuf)out);
                }
            });
        });
    }

    private static void registerClientReceivers() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)HEATMAP_S2C, (buf, ctx) -> {
            RegionalTpsService.Heatmap hm = WmbNetwork.decodeHeatmap(buf);
            Minecraft.m_91087_().execute(() -> {
                WmbClient.setLastHeatmap(hm);
                Screen patt0$temp = Minecraft.m_91087_().f_91080_;
                if (patt0$temp instanceof HeatmapScreen) {
                    HeatmapScreen hs = (HeatmapScreen)patt0$temp;
                    hs.setHeatmap(hm);
                } else {
                    HeatmapScreen.open(hm);
                }
            });
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)REGION_DETAIL_S2C, (buf, ctx) -> {
            RegionalTpsService.RegionDetail detail = WmbNetwork.decodeRegionDetail(buf);
            Minecraft.m_91087_().execute(() -> {
                Screen patt0$temp = Minecraft.m_91087_().f_91080_;
                if (patt0$temp instanceof HeatmapScreen) {
                    HeatmapScreen hs = (HeatmapScreen)patt0$temp;
                    hs.onRegionDetail(detail);
                }
            });
        });
    }

    public static void sendHeatmap(ServerPlayer player, RegionalTpsService.Heatmap hm) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        WmbNetwork.encodeHeatmap(buf, hm);
        NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)HEATMAP_S2C, (FriendlyByteBuf)buf);
    }

    public static void requestRegionDetail(String dim, int rx, int rz) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        WmbNetwork.writeString(buf, dim);
        buf.m_130130_(rx);
        buf.m_130130_(rz);
        NetworkManager.sendToServer((ResourceLocation)REGION_DETAIL_C2S, (FriendlyByteBuf)buf);
    }

    public static void requestHeatmap(String dim, int originRx, int originRz, int size) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        WmbNetwork.writeString(buf, dim);
        buf.m_130130_(originRx);
        buf.m_130130_(originRz);
        buf.m_130130_(size);
        NetworkManager.sendToServer((ResourceLocation)HEATMAP_REQ_C2S, (FriendlyByteBuf)buf);
    }

    private static void encodeHeatmap(FriendlyByteBuf buf, RegionalTpsService.Heatmap hm) {
        WmbNetwork.writeString(buf, hm.dim);
        buf.m_130130_(hm.originRx);
        buf.m_130130_(hm.originRz);
        buf.m_130130_(hm.size);
        buf.m_130103_(hm.tick);
        buf.writeDouble(hm.globalTPS);
        for (int r = 0; r < hm.size; ++r) {
            for (int c = 0; c < hm.size; ++c) {
                buf.writeFloat((float)hm.avgMs[r][c]);
                buf.writeFloat((float)hm.avgMem[r][c]);
                buf.m_130130_(hm.multiplier[r][c]);
                buf.m_130130_(hm.playerCount[r][c]);
                int prioOrdinal = hm.priority[r][c].ordinal();
                buf.m_130130_(prioOrdinal);
            }
        }
    }

    private static RegionalTpsService.Heatmap decodeHeatmap(FriendlyByteBuf buf) {
        String dim = WmbNetwork.readString(buf);
        int originRx = buf.m_130242_();
        int originRz = buf.m_130242_();
        int size = buf.m_130242_();
        long tick = buf.m_130258_();
        double globalTPS = buf.readDouble();
        double[][] avgMs = new double[size][size];
        double[][] avgMem = new double[size][size];
        int[][] mul = new int[size][size];
        int[][] players = new int[size][size];
        RegionalTpsService.RegionStats.RegionPriority[][] priority = new RegionalTpsService.RegionStats.RegionPriority[size][size];
        for (int r = 0; r < size; ++r) {
            for (int c = 0; c < size; ++c) {
                avgMs[r][c] = buf.readFloat();
                avgMem[r][c] = buf.readFloat();
                mul[r][c] = buf.m_130242_();
                players[r][c] = buf.m_130242_();
                int prioOrdinal = buf.m_130242_();
                RegionalTpsService.RegionStats.RegionPriority[] values = RegionalTpsService.RegionStats.RegionPriority.values();
                if (prioOrdinal < 0 || prioOrdinal >= values.length) {
                    prioOrdinal = 2;
                }
                priority[r][c] = values[prioOrdinal];
            }
        }
        return new RegionalTpsService.Heatmap(dim, originRx, originRz, size, avgMs, avgMem, mul, players, priority, tick, globalTPS);
    }

    private static void encodeRegionDetail(FriendlyByteBuf buf, RegionalTpsService.RegionDetail d) {
        WmbNetwork.writeString(buf, d.dim);
        buf.m_130130_(d.rx);
        buf.m_130130_(d.rz);
        buf.writeFloat((float)d.avgMs);
        buf.writeFloat((float)d.avgMem);
        buf.m_130130_(d.multiplier);
        buf.m_130130_(d.targetMultiplier);
        buf.m_130130_(d.lastActiveTicks);
        buf.m_130130_(d.lastBeCount);
        buf.m_130130_(d.lastSchedTickCount);
        buf.m_130130_(d.lastRedstoneUpdates);
        buf.m_130103_(d.tick);
        buf.m_130130_(d.msHistory.length);
        for (double v : d.msHistory) {
            buf.writeFloat((float)v);
        }
        buf.m_130130_(d.memHistory.length);
        for (double v : d.memHistory) {
            buf.writeFloat((float)v);
        }
        buf.m_130130_(d.playerHistory.length);
        for (int v : d.playerHistory) {
            buf.m_130130_(v);
        }
        buf.m_130130_(d.entityCount);
        buf.m_130130_(d.mobCount);
        buf.m_130130_(d.priority.ordinal());
        buf.writeBoolean(d.emergencyMode);
        buf.m_130130_(d.consecutiveGoodTicks);
        buf.m_130130_(d.consecutiveBadTicks);
    }

    private static RegionalTpsService.RegionDetail decodeRegionDetail(FriendlyByteBuf buf) {
        String dim = WmbNetwork.readString(buf);
        int rx = buf.m_130242_();
        int rz = buf.m_130242_();
        double avgMs = buf.readFloat();
        double avgMem = buf.readFloat();
        int mul = buf.m_130242_();
        int targetMul = buf.m_130242_();
        int active = buf.m_130242_();
        int be = buf.m_130242_();
        int sched = buf.m_130242_();
        int red = buf.m_130242_();
        long tick = buf.m_130258_();
        int nMs = buf.m_130242_();
        double[] msHist = new double[nMs];
        for (int i = 0; i < nMs; ++i) {
            msHist[i] = buf.readFloat();
        }
        int nMem = buf.m_130242_();
        double[] memHist = new double[nMem];
        for (int i = 0; i < nMem; ++i) {
            memHist[i] = buf.readFloat();
        }
        int nPlayers = buf.m_130242_();
        int[] playerHist = new int[nPlayers];
        for (int i = 0; i < nPlayers; ++i) {
            playerHist[i] = buf.m_130242_();
        }
        int ent = buf.m_130242_();
        int mob = buf.m_130242_();
        int prioOrdinal = buf.m_130242_();
        RegionalTpsService.RegionStats.RegionPriority[] values = RegionalTpsService.RegionStats.RegionPriority.values();
        if (prioOrdinal < 0 || prioOrdinal >= values.length) {
            prioOrdinal = 2;
        }
        RegionalTpsService.RegionStats.RegionPriority priority = values[prioOrdinal];
        boolean emergency = buf.readBoolean();
        int good = buf.m_130242_();
        int bad = buf.m_130242_();
        return new RegionalTpsService.RegionDetail(dim, rx, rz, avgMs, avgMem, mul, targetMul, active, be, sched, red, tick, msHist, memHist, playerHist, ent, mob, priority, emergency, good, bad);
    }

    private static void writeString(FriendlyByteBuf buf, String s) {
        byte[] b = s.getBytes(StandardCharsets.UTF_8);
        buf.m_130130_(b.length);
        buf.writeBytes(b);
    }

    private static String readString(FriendlyByteBuf buf) {
        int len = buf.m_130242_();
        byte[] b = new byte[len];
        buf.readBytes(b);
        return new String(b, StandardCharsets.UTF_8);
    }

    private static ServerLevel getServerLevelByDim(ServerPlayer sp, String dim) {
        try {
            ResourceLocation rl = new ResourceLocation(dim);
            ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)rl);
            return sp.f_8924_.m_129880_(key);
        }
        catch (Exception e) {
            return null;
        }
    }
}

