/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.wmb.path;

import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.world.level.ChunkPos;

public final class PathGroupManager {
    private static final ConcurrentMap<Key, Integer> LAST_TICK = new ConcurrentHashMap<Key, Integer>();

    private PathGroupManager() {
    }

    public static boolean shouldDefer(String dimensionKey, ChunkPos originChunk, long targetBucket, int windowTicks, int nowTick) {
        int dt;
        if (windowTicks <= 0) {
            return false;
        }
        Key key = new Key(dimensionKey, originChunk.m_45588_(), targetBucket);
        Integer last = (Integer)LAST_TICK.get(key);
        if (last != null && (dt = nowTick - last) >= 0 && dt < windowTicks) {
            return true;
        }
        LAST_TICK.put(key, nowTick);
        return false;
    }

    public static long bucketForTargetPos(ChunkPos targetChunk) {
        return targetChunk.m_45588_();
    }

    public static long bucketForTargetEntity(int entityId) {
        return Long.MIN_VALUE | (long)entityId & 0xFFFFFFFFL;
    }

    private record Key(String dim, long originChunk, long targetBucket) {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key k = (Key)o;
            return this.originChunk == k.originChunk && this.targetBucket == k.targetBucket && Objects.equals(this.dim, k.dim);
        }

        @Override
        public int hashCode() {
            int h = this.dim.hashCode();
            h = 31 * h + Long.hashCode(this.originChunk);
            h = 31 * h + Long.hashCode(this.targetBucket);
            return h;
        }
    }
}

