/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.wmb.path;

import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.pathfinder.Path;
import org.texboobcat.wmb.config.WmbConfig;
import org.texboobcat.wmb.metrics.Metrics;

public final class SharedPathRegistry {
    private static final ConcurrentMap<Key, Entry> MAP = new ConcurrentHashMap<Key, Entry>();

    private SharedPathRegistry() {
    }

    public static void publish(String dimKey, ChunkPos originChunk, long targetBucket, Path path, int tickNow) {
        if (path == null) {
            return;
        }
        Key k = new Key(dimKey, originChunk.m_45588_(), targetBucket);
        MAP.put(k, new Entry(path, tickNow));
        if (WmbConfig.get().metrics.enabled) {
            Metrics.onPathSharedPublished();
        }
    }

    public static Path tryClaim(String dimKey, ChunkPos originChunk, long targetBucket, int tickNow, int ttlTicks) {
        Key k = new Key(dimKey, originChunk.m_45588_(), targetBucket);
        Entry e = (Entry)MAP.get(k);
        if (e == null) {
            return null;
        }
        int age = tickNow - e.tick;
        if (age < 0 || age > ttlTicks) {
            MAP.remove(k, e);
            return null;
        }
        if (e.claimed) {
            return null;
        }
        e.claimed = true;
        if (WmbConfig.get().metrics.enabled) {
            Metrics.onPathSharedClaimed();
        }
        return e.path;
    }

    private record Key(String dim, long originChunk, long targetBucket) {
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key k = (Key)o;
            return this.originChunk == k.originChunk && this.targetBucket == k.targetBucket && Objects.equals(this.dim, k.dim);
        }

        @Override
        public int hashCode() {
            int h = this.dim.hashCode();
            h = 31 * h + Long.hashCode(this.originChunk);
            h = 31 * h + Long.hashCode(this.targetBucket);
            return h;
        }
    }

    private static final class Entry {
        final Path path;
        final int tick;
        volatile boolean claimed = false;

        Entry(Path path, int tick) {
            this.path = path;
            this.tick = tick;
        }
    }
}

