/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.wmb.profile;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public final class Profiler {
    private static final AtomicBoolean ACTIVE = new AtomicBoolean(false);
    private static final AtomicLong TOTAL_AI_NANOS = new AtomicLong();
    private static final AtomicLong TOTAL_AI_COUNT = new AtomicLong();

    private Profiler() {
    }

    public static void start() {
        TOTAL_AI_NANOS.set(0L);
        TOTAL_AI_COUNT.set(0L);
        ACTIVE.set(true);
    }

    public static ProfileSnapshot stop() {
        ACTIVE.set(false);
        return Profiler.snapshot();
    }

    public static boolean isActive() {
        return ACTIVE.get();
    }

    public static void recordAiDuration(long nanos) {
        if (ACTIVE.get()) {
            TOTAL_AI_NANOS.addAndGet(nanos);
            TOTAL_AI_COUNT.incrementAndGet();
        }
    }

    public static ProfileSnapshot snapshot() {
        long nanos = TOTAL_AI_NANOS.get();
        long cnt = TOTAL_AI_COUNT.get();
        return new ProfileSnapshot(nanos, cnt);
    }

    public static final class ProfileSnapshot {
        public final long totalAiNanos;
        public final long totalAiCount;

        public ProfileSnapshot(long totalAiNanos, long totalAiCount) {
            this.totalAiNanos = totalAiNanos;
            this.totalAiCount = totalAiCount;
        }

        public double avgAiMicros() {
            return this.totalAiCount == 0L ? 0.0 : (double)this.totalAiNanos / 1000.0 / (double)this.totalAiCount;
        }
    }
}

