/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.wmb.spawn;

import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.LevelChunk;
import org.texboobcat.wmb.config.WmbConfig;
import org.texboobcat.wmb.metrics.Metrics;

public final class AsyncSpawnManager {
    private static volatile ExecutorService pool;
    private static final Map<Key, ArrayBlockingQueue<BlockPos>> BUFFERS;
    private static final Map<Key, Long> LAST_SCHEDULE;
    private static final int BUFFER_CAPACITY = 64;
    private static final int FILL_BATCH = 32;
    private static final long RESCHEDULE_COOLDOWN_MS = 50L;

    private AsyncSpawnManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void ensurePool() {
        if (pool != null) return;
        Class<AsyncSpawnManager> clazz = AsyncSpawnManager.class;
        synchronized (AsyncSpawnManager.class) {
            if (pool != null) return;
            int threads = Math.max(1, WmbConfig.get().asyncSpawn.threadPoolSize);
            pool = new ThreadPoolExecutor(threads, threads, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadFactory(){
                private final AtomicInteger idx = new AtomicInteger(1);

                @Override
                public Thread newThread(Runnable r) {
                    Thread t = new Thread(r, "WMB-AsyncSpawn-" + this.idx.getAndIncrement());
                    t.setDaemon(true);
                    return t;
                }
            });
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static BlockPos nextOrRandom(ServerLevel level, LevelChunk chunk) {
        if (!WmbConfig.get().asyncSpawn.enabled) {
            return AsyncSpawnManager.randomPosInChunk(level, chunk);
        }
        AsyncSpawnManager.ensurePool();
        Key key = Key.of(level, chunk.m_7697_());
        ArrayBlockingQueue q = BUFFERS.computeIfAbsent(key, k -> new ArrayBlockingQueue(64));
        BlockPos polled = (BlockPos)q.poll();
        if (polled != null) {
            return polled;
        }
        AsyncSpawnManager.maybeScheduleFill(level, chunk, q, key);
        return AsyncSpawnManager.randomPosInChunk(level, chunk);
    }

    private static void maybeScheduleFill(ServerLevel level, LevelChunk chunk, ArrayBlockingQueue<BlockPos> q, Key key) {
        if (q.remainingCapacity() < 16) {
            return;
        }
        long now = System.currentTimeMillis();
        Long last = LAST_SCHEDULE.get(key);
        if (last != null && now - last < 50L) {
            return;
        }
        LAST_SCHEDULE.put(key, now);
        AsyncSpawnManager.ensurePool();
        pool.execute(() -> AsyncSpawnManager.fillPositions(level, chunk.m_7697_(), q, 32));
    }

    private static void fillPositions(ServerLevel level, ChunkPos cp, ArrayBlockingQueue<BlockPos> q, int count) {
        long nanos;
        boolean met = WmbConfig.get().metrics.enabled;
        long start = met ? System.nanoTime() : 0L;
        int minY = level.m_141937_();
        int maxY = level.m_151558_();
        int height = Math.max(1, maxY - minY);
        int x0 = cp.m_45604_();
        int z0 = cp.m_45605_();
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        ArrayList<BlockPos> local = new ArrayList<BlockPos>(count);
        for (int i = 0; i < count; ++i) {
            int x = x0 + rnd.nextInt(16);
            int z = z0 + rnd.nextInt(16);
            int y = minY + rnd.nextInt(height);
            local.add(new BlockPos(x, y, z));
        }
        for (BlockPos pos : local) {
            q.offer(pos);
        }
        if (met && (nanos = System.nanoTime() - start) > 0L) {
            Metrics.onAsyncSpawnFill(nanos, local.size());
        }
    }

    private static BlockPos randomPosInChunk(ServerLevel level, LevelChunk chunk) {
        ChunkPos cp = chunk.m_7697_();
        int minY = level.m_141937_();
        int maxY = level.m_151558_();
        int height = Math.max(1, maxY - minY);
        int x = cp.m_45604_() + level.f_46441_.m_188503_(16);
        int z = cp.m_45605_() + level.f_46441_.m_188503_(16);
        int y = minY + level.f_46441_.m_188503_(height);
        return new BlockPos(x, y, z);
    }

    static {
        BUFFERS = new ConcurrentHashMap<Key, ArrayBlockingQueue<BlockPos>>();
        LAST_SCHEDULE = new ConcurrentHashMap<Key, Long>();
    }

    private record Key(String dim, long chunkKey) {
        static Key of(ServerLevel level, ChunkPos cp) {
            return new Key(level.m_46472_().m_135782_().toString(), cp.m_45588_());
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key k = (Key)o;
            return this.chunkKey == k.chunkKey && Objects.equals(this.dim, k.dim);
        }

        @Override
        public int hashCode() {
            return this.dim.hashCode() * 31 ^ Long.hashCode(this.chunkKey);
        }
    }
}

