/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.wmb.test;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import org.texboobcat.wmb.metrics.Metrics;

public final class StressTestManager {
    private static final String TAG = "wmb_stress";
    private static final int SPAWN_BATCH = 64;
    private static boolean running = false;
    private static ScenarioConfig cfg;
    private static UUID levelId;
    private static ResourceKey<Level> dimKey;
    private static int ticksElapsed;
    private static long startNanos;
    private static Metrics.Snapshot pre;
    private static final List<UUID> entityIds;
    private static int spawnRemaining;
    private static int spawnAttempted;
    private static int spawnSucceeded;
    private static int spawnFailed;
    private static int pathOrdersIssued;
    private static List<BlockPos> waypointList;
    private static int waypointIndex;

    private StressTestManager() {
    }

    public static synchronized boolean isRunning() {
        return running;
    }

    public static synchronized boolean start(ServerLevel level, ScenarioConfig scenario) {
        if (running) {
            return false;
        }
        running = true;
        cfg = scenario;
        dimKey = level.m_46472_();
        levelId = level.m_46472_().m_135782_().m_135827_().equals("minecraft") ? UUID.nameUUIDFromBytes(("minecraft:" + level.m_46472_().m_135782_().m_135815_()).getBytes()) : UUID.nameUUIDFromBytes(scenario.dimensionId.getBytes());
        ticksElapsed = 0;
        startNanos = System.nanoTime();
        pre = Metrics.snapshot();
        entityIds.clear();
        spawnRemaining = Math.max(0, StressTestManager.cfg.count);
        spawnAttempted = 0;
        spawnSucceeded = 0;
        spawnFailed = 0;
        pathOrdersIssued = 0;
        waypointIndex = 0;
        waypointList = StressTestManager.buildWaypoints(StressTestManager.cfg.center, StressTestManager.cfg.radius, Math.max(1, StressTestManager.cfg.waypoints));
        return true;
    }

    public static synchronized void stop(ServerLevel level) {
        if (!running) {
            return;
        }
        if (StressTestManager.cfg.cleanupOnStop) {
            StressTestManager.cleanup(level);
        }
        StressTestManager.finalizeReport(level);
        running = false;
        cfg = null;
        entityIds.clear();
        waypointList = null;
    }

    public static synchronized void onServerTick(MinecraftServer server) {
        if (!running) {
            return;
        }
        ServerLevel level = server.m_129880_(dimKey);
        if (level == null) {
            return;
        }
        if (spawnRemaining > 0) {
            int batch = Math.min(64, spawnRemaining);
            for (int i = 0; i < batch; ++i) {
                if (StressTestManager.spawnOne(level)) {
                    ++spawnSucceeded;
                } else {
                    ++spawnFailed;
                }
                ++spawnAttempted;
                --spawnRemaining;
            }
        }
        if (StressTestManager.cfg.pathEveryTicks > 0 && ++ticksElapsed % StressTestManager.cfg.pathEveryTicks == 0) {
            StressTestManager.drivePaths(level);
        }
        if (StressTestManager.cfg.pathEveryTicks > 0 && ticksElapsed % StressTestManager.cfg.pathEveryTicks == 0) {
            waypointIndex = (waypointIndex + 1) % waypointList.size();
        }
        if (ticksElapsed >= StressTestManager.cfg.durationTicks) {
            StressTestManager.stop(level);
        }
    }

    private static List<BlockPos> buildWaypoints(BlockPos center, int radius, int count) {
        ArrayList<BlockPos> pts = new ArrayList<BlockPos>(count);
        if (radius <= 0) {
            radius = 1;
        }
        for (int i = 0; i < count; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)count;
            int dx = (int)Math.round(Math.cos(angle) * (double)radius);
            int dz = (int)Math.round(Math.sin(angle) * (double)radius);
            pts.add(center.m_7918_(dx, 0, dz));
        }
        return pts;
    }

    private static boolean spawnOne(ServerLevel level) {
        try {
            ThreadLocalRandom rnd = ThreadLocalRandom.current();
            double ang = rnd.nextDouble(0.0, Math.PI * 2);
            double r = rnd.nextDouble(0.0, StressTestManager.cfg.radius);
            int x = StressTestManager.cfg.center.m_123341_() + (int)Math.round(Math.cos(ang) * r);
            int z = StressTestManager.cfg.center.m_123343_() + (int)Math.round(Math.sin(ang) * r);
            int y = level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z) + 1;
            Mob mob = (Mob)StressTestManager.cfg.entityType.m_20615_((Level)level);
            if (mob == null) {
                return false;
            }
            mob.m_146884_(new Vec3((double)x + 0.5, (double)y, (double)z + 0.5));
            mob.m_20049_(TAG);
            if (level.m_7967_((Entity)mob)) {
                entityIds.add(mob.m_20148_());
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private static void drivePaths(ServerLevel level) {
        if (waypointList == null || waypointList.isEmpty()) {
            return;
        }
        BlockPos wpCenter = waypointList.get(waypointIndex);
        for (UUID id : new ArrayList<UUID>(entityIds)) {
            Entity e = level.m_8791_(id);
            if (!(e instanceof Mob)) continue;
            Mob mob = (Mob)e;
            BlockPos target = wpCenter;
            int y = level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, target.m_123341_(), target.m_123343_()) + 1;
            double tx = (double)target.m_123341_() + 0.5;
            double ty = y;
            double tz = (double)target.m_123343_() + 0.5;
            try {
                if (mob.m_21573_() == null) continue;
                mob.m_21573_().m_26519_(tx, ty, tz, 1.2);
                ++pathOrdersIssued;
            }
            catch (Throwable throwable) {}
        }
    }

    private static void cleanup(ServerLevel level) {
        for (UUID id : new ArrayList<UUID>(entityIds)) {
            Entity e = level.m_8791_(id);
            if (e == null || !e.m_6084_() || !e.m_19880_().contains(TAG)) continue;
            e.m_146870_();
        }
    }

    private static void finalizeReport(ServerLevel level) {
        Metrics.Snapshot post = Metrics.snapshot();
        long endNanos = System.nanoTime();
        long durNanos = Math.max(0L, endNanos - startNanos);
        long aiExec = post.aiStepsExecuted - StressTestManager.pre.aiStepsExecuted;
        long aiSkip = post.aiStepsSkipped - StressTestManager.pre.aiStepsSkipped;
        long aiSkipDab = post.aiStepsSkippedDab - StressTestManager.pre.aiStepsSkippedDab;
        long aiSkipEnt = post.aiStepsSkippedEntity - StressTestManager.pre.aiStepsSkippedEntity;
        long aiSkipVis = post.aiStepsSkippedVisibility - StressTestManager.pre.aiStepsSkippedVisibility;
        long pfCount = post.pathfindCount - StressTestManager.pre.pathfindCount;
        long pfNanos = post.pathfindNanos - StressTestManager.pre.pathfindNanos;
        long sharedPub = post.pathSharedPublished - StressTestManager.pre.pathSharedPublished;
        long sharedClaim = post.pathSharedClaimed - StressTestManager.pre.pathSharedClaimed;
        double avgPfMicros = pfCount == 0L ? 0.0 : (double)pfNanos / 1000.0 / (double)pfCount;
        StringBuilder sb = new StringBuilder();
        sb.append("[WMB] StressTest Report\n");
        sb.append("Scenario: ").append(StressTestManager.cfg.entityType != null ? EntityType.m_20613_(StressTestManager.cfg.entityType).toString() : "?").append(" count=").append(StressTestManager.cfg.count).append(" radius=").append(StressTestManager.cfg.radius).append(" durationTicks=").append(StressTestManager.cfg.durationTicks).append(" pathEvery=").append(StressTestManager.cfg.pathEveryTicks).append(" waypoints=").append(StressTestManager.cfg.waypoints).append(" cleanup=").append(StressTestManager.cfg.cleanupOnStop).append("\n");
        sb.append("Runtime: ticks=").append(ticksElapsed).append(" durMs=").append(String.format(Locale.ROOT, "%.2f", (double)durNanos / 1000000.0)).append("\n");
        sb.append("Spawns: attempted=").append(spawnAttempted).append(" succeeded=").append(spawnSucceeded).append(" failed=").append(spawnFailed).append("\n");
        sb.append("Path: ordersIssued=").append(pathOrdersIssued).append(" shared{pub=").append(sharedPub).append(",claim=").append(sharedClaim).append("}").append("\n");
        sb.append("AI: executed=").append(aiExec).append(" skipped=").append(aiSkip).append(" [dab=").append(aiSkipDab).append(",entity=").append(aiSkipEnt).append(",visibility=").append(aiSkipVis).append("]").append(" avgPfMicros=").append(String.format(Locale.ROOT, "%.2f", avgPfMicros)).append(" pfCount=").append(pfCount).append("\n");
        System.out.println(sb.toString());
    }

    public static synchronized String statusString() {
        if (!running) {
            return "[WMB] StressTest: idle";
        }
        return String.format(Locale.ROOT, "[WMB] StressTest: running ticks=%d remaining=%d spawns{attempted=%d,ok=%d,fail=%d} pathOrders=%d", ticksElapsed, spawnRemaining, spawnAttempted, spawnSucceeded, spawnFailed, pathOrdersIssued);
    }

    public static synchronized String liveReport() {
        if (!running) {
            return "[WMB] StressTest: no active test";
        }
        Metrics.Snapshot post = Metrics.snapshot();
        long nowNanos = System.nanoTime();
        long durNanos = Math.max(0L, nowNanos - startNanos);
        long aiExec = post.aiStepsExecuted - StressTestManager.pre.aiStepsExecuted;
        long aiSkip = post.aiStepsSkipped - StressTestManager.pre.aiStepsSkipped;
        long aiSkipDab = post.aiStepsSkippedDab - StressTestManager.pre.aiStepsSkippedDab;
        long aiSkipEnt = post.aiStepsSkippedEntity - StressTestManager.pre.aiStepsSkippedEntity;
        long aiSkipVis = post.aiStepsSkippedVisibility - StressTestManager.pre.aiStepsSkippedVisibility;
        long pfCount = post.pathfindCount - StressTestManager.pre.pathfindCount;
        long pfNanos = post.pathfindNanos - StressTestManager.pre.pathfindNanos;
        long sharedPub = post.pathSharedPublished - StressTestManager.pre.pathSharedPublished;
        long sharedClaim = post.pathSharedClaimed - StressTestManager.pre.pathSharedClaimed;
        double avgPfMicros = pfCount == 0L ? 0.0 : (double)pfNanos / 1000.0 / (double)pfCount;
        StringBuilder sb = new StringBuilder();
        sb.append("[WMB] StressTest Live Report\n");
        sb.append("Runtime: ticks=").append(ticksElapsed).append(" durMs=").append(String.format(Locale.ROOT, "%.2f", (double)durNanos / 1000000.0)).append("\n");
        sb.append("Spawns: attempted=").append(spawnAttempted).append(" succeeded=").append(spawnSucceeded).append(" failed=").append(spawnFailed).append("\n");
        sb.append("Path: ordersIssued=").append(pathOrdersIssued).append(" shared{pub=").append(sharedPub).append(",claim=").append(sharedClaim).append("}").append("\n");
        sb.append("AI: executed=").append(aiExec).append(" skipped=").append(aiSkip).append(" [dab=").append(aiSkipDab).append(",entity=").append(aiSkipEnt).append(",visibility=").append(aiSkipVis).append("]").append(" avgPfMicros=").append(String.format(Locale.ROOT, "%.2f", avgPfMicros)).append(" pfCount=").append(pfCount).append("\n");
        return sb.toString();
    }

    static {
        entityIds = new ArrayList<UUID>();
    }

    public static final class ScenarioConfig {
        public final EntityType<? extends Mob> entityType;
        public final int count;
        public final int radius;
        public final int durationTicks;
        public final int pathEveryTicks;
        public final int waypoints;
        public final boolean cleanupOnStop;
        public final BlockPos center;
        public final String dimensionId;

        public ScenarioConfig(EntityType<? extends Mob> entityType, int count, int radius, int durationTicks, int pathEveryTicks, int waypoints, boolean cleanupOnStop, BlockPos center, String dimensionId) {
            this.entityType = entityType;
            this.count = count;
            this.radius = radius;
            this.durationTicks = durationTicks;
            this.pathEveryTicks = pathEveryTicks;
            this.waypoints = waypoints;
            this.cleanupOnStop = cleanupOnStop;
            this.center = center;
            this.dimensionId = dimensionId;
        }
    }
}

