/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.wmb;

import com.mojang.brigadier.CommandDispatcher;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.event.events.common.TickEvent;
import net.minecraft.class_2168;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.texboobcat.wmb.command.WmbCommands;
import org.texboobcat.wmb.config.WmbConfig;
import org.texboobcat.wmb.metrics.Metrics;
import org.texboobcat.wmb.network.WmbNetwork;
import org.texboobcat.wmb.proximity.ProximityService;
import org.texboobcat.wmb.regional.RegionalTpsService;
import org.texboobcat.wmb.test.StressTestManager;
import org.texboobcat.wmb.tracking.AsyncEntityTracker;
import org.texboobcat.wmb.tune.AutoTuner;

public final class Wmb {
    public static final String MOD_ID = "wmb";
    private static final Logger LOGGER = LogManager.getLogger((String)"wmb");
    private static volatile long TICK_START_NANOS = 0L;
    private static int PROX_COUNTER = 0;

    public static void init() {
        WmbConfig.load();
        WmbNetwork.init();
        CommandRegistrationEvent.EVENT.register((dispatcher, registry, selection) -> WmbCommands.register((CommandDispatcher<class_2168>)dispatcher));
        TickEvent.SERVER_PRE.register(server -> {
            TICK_START_NANOS = WmbConfig.get().metrics.enabled ? System.nanoTime() : 0L;
            RegionalTpsService.onServerPreTick(server);
            int interval = WmbConfig.get().proximity.updateIntervalTicks;
            if (interval <= 0) {
                interval = 5;
            }
            if (PROX_COUNTER++ % interval == 0) {
                ProximityService.update(server);
            }
            AsyncEntityTracker.onServerPreTick(server);
        });
        TickEvent.SERVER_POST.register(server -> {
            long end = System.nanoTime();
            long start = TICK_START_NANOS;
            if (start != 0L) {
                Metrics.onServerTickDuration(end - start);
            }
            long duration = start != 0L ? end - start : 0L;
            AutoTuner.onServerTick(duration);
            AsyncEntityTracker.onServerPostTick(server);
            RegionalTpsService.onServerPostTick(server);
            StressTestManager.onServerTick(server);
        });
        LOGGER.info("WMB initialized");
    }
}

