/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.wmb.api.event;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import net.minecraft.class_1308;

public final class WMBEntityTickEvent {
    private static final List<Consumer<class_1308>> PRE_LISTENERS = new CopyOnWriteArrayList<Consumer<class_1308>>();
    private static final List<Consumer<class_1308>> POST_LISTENERS = new CopyOnWriteArrayList<Consumer<class_1308>>();

    private WMBEntityTickEvent() {
    }

    public static void registerPre(Consumer<class_1308> listener) {
        if (listener != null) {
            PRE_LISTENERS.add(listener);
        }
    }

    public static void unregisterPre(Consumer<class_1308> listener) {
        PRE_LISTENERS.remove(listener);
    }

    public static void registerPost(Consumer<class_1308> listener) {
        if (listener != null) {
            POST_LISTENERS.add(listener);
        }
    }

    public static void unregisterPost(Consumer<class_1308> listener) {
        POST_LISTENERS.remove(listener);
    }

    public static void firePre(class_1308 mob) {
        for (Consumer<class_1308> c : PRE_LISTENERS) {
            try {
                c.accept(mob);
            }
            catch (Throwable throwable) {}
        }
    }

    public static void firePost(class_1308 mob) {
        for (Consumer<class_1308> c : POST_LISTENERS) {
            try {
                c.accept(mob);
            }
            catch (Throwable throwable) {}
        }
    }
}

