/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.wmb.client;

import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import org.texboobcat.wmb.network.WmbNetwork;
import org.texboobcat.wmb.regional.RegionalTpsService;

public class HeatmapScreen
extends class_437 {
    private RegionalTpsService.Heatmap hm;
    private int padding = 16;
    private RegionalTpsService.RegionDetail detail;
    private int selectedRx = Integer.MIN_VALUE;
    private int selectedRz = Integer.MIN_VALUE;
    private boolean dragging = false;
    private double dragStartX;
    private double dragStartY;
    private int dragStartOriginRx;
    private int dragStartOriginRz;
    private int lodLevel = 1;
    private int maxLodLevel = 16;
    private int minCellSize = 8;
    private int maxCellSize = 64;
    private boolean lodEnabled = false;
    private final int originalHeatmapSize;
    private int lastCalcWidth = -1;
    private int lastCalcHeight = -1;
    private int lastCalcHmSize = -1;
    private boolean lastCalcLodEnabled = !this.lodEnabled;
    private int legendX1 = -1;
    private int legendY1 = -1;
    private int legendX2 = -1;
    private int legendY2 = -1;
    private double[][] lodAvgMs;
    private int[][] lodMultiplier;
    private int[][] lodRegionCount;
    private int lodGridSize;
    private double[][] lodAvgMem;
    private int[][] lodPlayerCount;
    private RegionalTpsService.RegionStats.RegionPriority[][] lodPriority;
    private ColorMode colorMode = ColorMode.AI_MS;
    private int modeX1 = -1;
    private int modeY1 = -1;
    private int modeX2 = -1;
    private int modeY2 = -1;
    private ResizablePanel detailPanel;
    private ResizeHandle currentResizeHandle = ResizeHandle.NONE;
    private MergedRegionDetail mergedDetail;

    public static void open(RegionalTpsService.Heatmap hm) {
        class_310.method_1551().method_1507((class_437)new HeatmapScreen(hm));
    }

    public HeatmapScreen(RegionalTpsService.Heatmap hm) {
        super((class_2561)class_2561.method_43470((String)"WMB Regional TPS Heatmap"));
        this.hm = hm;
        this.originalHeatmapSize = hm.size;
        this.detailPanel = new ResizablePanel("Region Details", 50, 50, 300, 150, 250, 120);
        this.calculateLOD();
    }

    private void calculateLOD() {
        if (this.hm == null) {
            return;
        }
        int gridSize = this.hm.size;
        int availW = Math.max(1, this.field_22789 - this.padding * 2);
        int availH = Math.max(1, this.field_22790 - this.padding * 3 - 40);
        int baseCell = Math.max(1, Math.min(availW / Math.max(1, gridSize), availH / Math.max(1, gridSize)));
        int targetLod = 1;
        if (this.lodEnabled) {
            if (baseCell < this.minCellSize) {
                double desired = (double)this.minCellSize / (double)baseCell;
                targetLod = HeatmapScreen.roundUpPowerOfTwo((int)Math.ceil(desired));
            }
            targetLod = Math.max(1, Math.min(targetLod, Math.min(this.maxLodLevel, gridSize)));
        }
        this.lodLevel = Math.max(1, targetLod);
        this.lodGridSize = (int)Math.ceil((double)gridSize / (double)this.lodLevel);
        this.lodAvgMs = new double[this.lodGridSize][this.lodGridSize];
        this.lodAvgMem = new double[this.lodGridSize][this.lodGridSize];
        this.lodPlayerCount = new int[this.lodGridSize][this.lodGridSize];
        this.lodPriority = new RegionalTpsService.RegionStats.RegionPriority[this.lodGridSize][this.lodGridSize];
        this.lodMultiplier = new int[this.lodGridSize][this.lodGridSize];
        this.lodRegionCount = new int[this.lodGridSize][this.lodGridSize];
        for (int lodR = 0; lodR < this.lodGridSize; ++lodR) {
            for (int lodC = 0; lodC < this.lodGridSize; ++lodC) {
                double totalMs = 0.0;
                double totalMem = 0.0;
                int totalPlayers = 0;
                int maxMul = 1;
                int regionCount = 0;
                int[] prioCounts = new int[RegionalTpsService.RegionStats.RegionPriority.values().length];
                for (int dr = 0; dr < this.lodLevel; ++dr) {
                    for (int dc = 0; dc < this.lodLevel; ++dc) {
                        int r = lodR * this.lodLevel + dr;
                        int c = lodC * this.lodLevel + dc;
                        if (r >= gridSize || c >= gridSize) continue;
                        totalMs += this.hm.avgMs[r][c];
                        totalMem += this.hm.avgMem[r][c];
                        totalPlayers += this.hm.playerCount[r][c];
                        maxMul = Math.max(maxMul, this.hm.multiplier[r][c]);
                        RegionalTpsService.RegionStats.RegionPriority pr = this.hm.priority[r][c];
                        int n = pr.ordinal();
                        prioCounts[n] = prioCounts[n] + 1;
                        ++regionCount;
                    }
                }
                this.lodAvgMs[lodR][lodC] = regionCount > 0 ? totalMs / (double)regionCount : 0.0;
                this.lodAvgMem[lodR][lodC] = regionCount > 0 ? totalMem / (double)regionCount : 0.0;
                this.lodPlayerCount[lodR][lodC] = totalPlayers;
                this.lodMultiplier[lodR][lodC] = maxMul;
                this.lodRegionCount[lodR][lodC] = regionCount;
                int bestIdx = 0;
                int bestCount = -1;
                for (int i = 0; i < prioCounts.length; ++i) {
                    if (prioCounts[i] <= bestCount) continue;
                    bestCount = prioCounts[i];
                    bestIdx = i;
                }
                this.lodPriority[lodR][lodC] = RegionalTpsService.RegionStats.RegionPriority.values()[bestIdx];
            }
        }
        this.lastCalcWidth = this.field_22789;
        this.lastCalcHeight = this.field_22790;
        this.lastCalcHmSize = this.hm.size;
        this.lastCalcLodEnabled = this.lodEnabled;
    }

    private static int roundUpPowerOfTwo(int n) {
        if (n <= 1) {
            return 1;
        }
        --n;
        n |= n >> 1;
        n |= n >> 2;
        n |= n >> 4;
        n |= n >> 8;
        n |= n >> 16;
        return n + 1;
    }

    protected void method_25426() {
        super.method_25426();
        this.calculateLOD();
        this.detailPanel.x = Math.min(this.detailPanel.x, this.field_22789 - this.detailPanel.width);
        this.detailPanel.y = Math.min(this.detailPanel.y, this.field_22790 - this.detailPanel.height);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (button == 0 && this.modeX1 >= 0 && mouseX >= (double)this.modeX1 && mouseX <= (double)this.modeX2 && mouseY >= (double)this.modeY1 && mouseY <= (double)this.modeY2) {
            switch (this.colorMode.ordinal()) {
                case 0: {
                    this.colorMode = ColorMode.MEM_MB;
                    break;
                }
                case 1: {
                    this.colorMode = ColorMode.PLAYERS;
                    break;
                }
                case 2: {
                    this.colorMode = ColorMode.PRIORITY;
                    break;
                }
                case 3: {
                    this.colorMode = ColorMode.AI_MS;
                }
            }
            return true;
        }
        if (button == 0 && this.legendX1 >= 0) {
            boolean inMode;
            boolean inLegend = mouseX >= (double)this.legendX1 && mouseX <= (double)this.legendX2 && mouseY >= (double)this.legendY1 && mouseY <= (double)this.legendY2;
            boolean bl = inMode = this.modeX1 >= 0 && mouseX >= (double)this.modeX1 && mouseX <= (double)this.modeX2 && mouseY >= (double)this.modeY1 && mouseY <= (double)this.modeY2;
            if (inLegend && !inMode) {
                this.lodEnabled = !this.lodEnabled;
                this.calculateLOD();
                return true;
            }
        }
        if (this.detailPanel.visible && this.detailPanel.isMouseInPanel(mouseX, mouseY)) {
            if (button == 0) {
                this.currentResizeHandle = this.detailPanel.getResizeHandle(mouseX, mouseY);
                if (this.currentResizeHandle != ResizeHandle.NONE) {
                    this.detailPanel.startResize(mouseX, mouseY);
                    return true;
                }
                if (this.detailPanel.isMouseInTitleBar(mouseX, mouseY)) {
                    this.detailPanel.startDrag(mouseX, mouseY);
                    return true;
                }
            }
            return true;
        }
        int availW = this.field_22789 - this.padding * 2;
        int availH = this.field_22790 - this.padding * 3 - 40;
        int cell = Math.max(2, Math.min(availW / this.lodGridSize, availH / this.lodGridSize));
        int gridW = cell * this.lodGridSize;
        int gridH = cell * this.lodGridSize;
        int left = (this.field_22789 - gridW) / 2;
        int top = this.padding + 20;
        if (mouseX >= (double)left && mouseX < (double)(left + gridW) && mouseY >= (double)top && mouseY < (double)(top + gridH) && cell > 0) {
            if (button == 1) {
                this.dragging = true;
                this.dragStartX = mouseX;
                this.dragStartY = mouseY;
                this.dragStartOriginRx = this.hm.originRx;
                this.dragStartOriginRz = this.hm.originRz;
                return true;
            }
            int c = (int)((mouseX - (double)left) / (double)cell);
            int r = (int)((mouseY - (double)top) / (double)cell);
            if (r >= 0 && r < this.lodGridSize && c >= 0 && c < this.lodGridSize) {
                this.detailPanel.visible = true;
                if (this.lodLevel > 1) {
                    int baseR = r * this.lodLevel + this.lodLevel / 2;
                    int baseC = c * this.lodLevel + this.lodLevel / 2;
                    baseR = Math.min(baseR, this.hm.size - 1);
                    baseC = Math.min(baseC, this.hm.size - 1);
                    int rx = this.hm.originRx + baseC;
                    int rz = this.hm.originRz + baseR;
                    this.selectedRx = rx;
                    this.selectedRz = rz;
                    this.detail = null;
                    this.mergedDetail = null;
                    this.createMergedRegionDetail(r, c);
                } else {
                    int rx = this.hm.originRx + c;
                    int rz = this.hm.originRz + r;
                    this.selectedRx = rx;
                    this.selectedRz = rz;
                    this.detail = null;
                    this.mergedDetail = null;
                    WmbNetwork.requestRegionDetail(this.hm.dim, rx, rz);
                }
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    private void createMergedRegionDetail(int lodR, int lodC) {
        int totalEntities = 0;
        int totalMobs = 0;
        int totalActiveTicks = 0;
        int totalBeCount = 0;
        int totalSchedTicks = 0;
        int validRegions = 0;
        for (int dr = 0; dr < this.lodLevel; ++dr) {
            for (int dc = 0; dc < this.lodLevel; ++dc) {
                int r = lodR * this.lodLevel + dr;
                int c = lodC * this.lodLevel + dc;
                if (r >= this.hm.size || c >= this.hm.size) continue;
                int estimatedEntities = Math.max(1, (int)(this.hm.avgMs[r][c] * 2.0));
                totalEntities += estimatedEntities;
                totalMobs += estimatedEntities / 3;
                totalActiveTicks += this.hm.multiplier[r][c];
                totalBeCount += estimatedEntities / 10;
                totalSchedTicks += this.hm.multiplier[r][c] * 5;
                ++validRegions;
            }
        }
        double[] history = new double[20];
        for (int i = 0; i < 20; ++i) {
            history[i] = this.lodAvgMs[lodR][lodC] * (0.8 + Math.random() * 0.4);
        }
        this.mergedDetail = new MergedRegionDetail(this.hm.dim, this.selectedRx, this.selectedRz, this.lodAvgMs[lodR][lodC], this.lodMultiplier[lodR][lodC], totalEntities, totalMobs, totalActiveTicks, totalBeCount, totalSchedTicks, history, this.lodRegionCount[lodR][lodC], this.lodAvgMem[lodR][lodC], this.lodPlayerCount[lodR][lodC], this.lodPriority[lodR][lodC]);
        this.detail = null;
    }

    public void onRegionDetail(RegionalTpsService.RegionDetail detail) {
        if (detail == null) {
            return;
        }
        if (!this.hm.dim.equals(detail.dim)) {
            return;
        }
        if (detail.rx != this.selectedRx || detail.rz != this.selectedRz) {
            return;
        }
        this.detail = detail;
        this.mergedDetail = null;
    }

    public void setHeatmap(RegionalTpsService.Heatmap hm) {
        this.hm = hm;
        this.calculateLOD();
        if (this.selectedRx != Integer.MIN_VALUE) {
            boolean inZ;
            boolean inX = this.selectedRx >= hm.originRx && this.selectedRx < hm.originRx + hm.size;
            boolean bl = inZ = this.selectedRz >= hm.originRz && this.selectedRz < hm.originRz + hm.size;
            if (!inX || !inZ) {
                this.selectedRx = Integer.MIN_VALUE;
                this.selectedRz = Integer.MIN_VALUE;
                this.detail = null;
                this.mergedDetail = null;
                this.detailPanel.visible = false;
            }
        }
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.detailPanel.dragging) {
            this.detailPanel.updateDrag(mouseX, mouseY, this.field_22789, this.field_22790);
            return true;
        }
        if (this.detailPanel.resizing) {
            this.detailPanel.updateResize(mouseX, mouseY, this.currentResizeHandle, this.field_22789, this.field_22790);
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    private void renderDetailPanel(class_332 gg) {
        if (!this.detailPanel.visible) {
            return;
        }
        gg.method_25294(this.detailPanel.x, this.detailPanel.y, this.detailPanel.x + this.detailPanel.width, this.detailPanel.y + this.detailPanel.height, -1879048192);
        gg.method_25294(this.detailPanel.x, this.detailPanel.y, this.detailPanel.x + this.detailPanel.width, this.detailPanel.y + 20, -1337966528);
        String header = this.lodLevel > 1 ? "Merged Region Detail" : "Region Detail";
        gg.method_25303(this.field_22793, header, this.detailPanel.x + 6, this.detailPanel.y + 6, 0xFFFFFF);
        String closeX = "\u00d7";
        int closeX_width = this.field_22793.method_1727(closeX);
        int closeButtonX = this.detailPanel.x + this.detailPanel.width - closeX_width - 8;
        gg.method_25303(this.field_22793, closeX, closeButtonX, this.detailPanel.y + 6, 0xFFAAAAA);
        int contentY = this.detailPanel.y + 25;
        int contentHeight = this.detailPanel.height - 25;
        if (this.selectedRx != Integer.MIN_VALUE) {
            String sel;
            if (this.lodLevel > 1) {
                int regionCount = 0;
                block0: for (int r = 0; r < this.lodGridSize; ++r) {
                    for (int c = 0; c < this.lodGridSize; ++c) {
                        int baseR = r * this.lodLevel + this.lodLevel / 2;
                        int baseC = c * this.lodLevel + this.lodLevel / 2;
                        baseR = Math.min(baseR, this.hm.size - 1);
                        if (this.hm.originRx + (baseC = Math.min(baseC, this.hm.size - 1)) != this.selectedRx || this.hm.originRz + baseR != this.selectedRz) continue;
                        regionCount = this.lodRegionCount[r][c];
                        continue block0;
                    }
                }
                sel = String.format("Center (%d,%d) - %d regions (%dx%d)", this.selectedRx, this.selectedRz, regionCount, this.lodLevel, this.lodLevel);
            } else {
                sel = String.format("Region (%d,%d)", this.selectedRx, this.selectedRz);
            }
            gg.method_25303(this.field_22793, sel, this.detailPanel.x + 6, contentY, 10539263);
            contentY += 14;
        }
        if (this.detail == null && this.mergedDetail == null) {
            gg.method_25303(this.field_22793, "Click a cell to see details...", this.detailPanel.x + 6, contentY, 0xC0C0C0);
        } else if (this.mergedDetail != null) {
            gg.method_25303(this.field_22793, String.format("avg avgAI: %.2f ms  maxMul: %d", this.mergedDetail.avgMs, this.mergedDetail.multiplier), this.detailPanel.x + 6, contentY, 0xFFFFFF);
            gg.method_25303(this.field_22793, String.format("avgMem: %.1f MB  players: %d  prio: %s", this.mergedDetail.avgMemMB, this.mergedDetail.totalPlayers, String.valueOf((Object)this.mergedDetail.priority)), this.detailPanel.x + 6, contentY += 12, 0xFFFFFF);
            gg.method_25303(this.field_22793, String.format("total entities: %d  mobs: %d", this.mergedDetail.entityCount, this.mergedDetail.mobCount), this.detailPanel.x + 6, contentY += 12, 0xFFFFFF);
            gg.method_25303(this.field_22793, String.format("total aiSteps: %d  BE: %d  sched: %d", this.mergedDetail.lastActiveTicks, this.mergedDetail.lastBeCount, this.mergedDetail.lastSchedTickCount), this.detailPanel.x + 6, contentY += 12, 0xFFFFFF);
            gg.method_25303(this.field_22793, String.format("* Aggregated from %d regions", this.mergedDetail.regionCount), this.detailPanel.x + 6, contentY += 12, 0x808080);
            int sparklineHeight = Math.max(20, contentHeight - ((contentY += 12) - this.detailPanel.y - 25) - 10);
            this.drawSparkline(gg, this.detailPanel.x + 6, contentY, this.detailPanel.width - 12, sparklineHeight, this.mergedDetail.msHistory);
        } else {
            gg.method_25303(this.field_22793, String.format("avgAI: %.2f ms  mul: %d", this.detail.avgMs, this.detail.multiplier), this.detailPanel.x + 6, contentY, 0xFFFFFF);
            gg.method_25303(this.field_22793, String.format("avgMem: %.1f MB  prio: %s%s", this.detail.avgMem, String.valueOf((Object)this.detail.priority), this.detail.emergencyMode ? " (EMERGENCY)" : ""), this.detailPanel.x + 6, contentY += 12, 0xFFFFFF);
            gg.method_25303(this.field_22793, String.format("entities: %d  mobs: %d", this.detail.entityCount, this.detail.mobCount), this.detailPanel.x + 6, contentY += 12, 0xFFFFFF);
            gg.method_25303(this.field_22793, String.format("aiSteps: %d  BE: %d  sched: %d", this.detail.lastActiveTicks, this.detail.lastBeCount, this.detail.lastSchedTickCount), this.detailPanel.x + 6, contentY += 12, 0xFFFFFF);
            gg.method_25303(this.field_22793, String.format("targetMul: %d  good: %d  bad: %d", this.detail.targetMultiplier, this.detail.consecutiveGoodTicks, this.detail.consecutiveBadTicks), this.detailPanel.x + 6, contentY += 12, 0xA0A0A0);
            int sparklineHeight = Math.max(20, contentHeight - ((contentY += 12) - this.detailPanel.y - 25) - 10);
            this.drawSparkline(gg, this.detailPanel.x + 6, contentY, this.detailPanel.width - 12, sparklineHeight, this.detail.msHistory);
        }
        this.drawResizeHandles(gg);
    }

    private void drawResizeHandles(class_332 gg) {
        int handleSize = 8;
        int x = this.detailPanel.x;
        int y = this.detailPanel.y;
        int w = this.detailPanel.width;
        int h = this.detailPanel.height;
        gg.method_25294(x + w - handleSize, y + h - handleSize, x + w, y + h, -2130706433);
        gg.method_25294(x, y + h - handleSize, x + handleSize, y + h, -2130706433);
        gg.method_25294(x + w - handleSize, y, x + w, y + handleSize, -2130706433);
        gg.method_25294(x, y, x + handleSize, y + handleSize, -2130706433);
    }

    private void drawSparkline(class_332 gg, int x, int y, int w, int h, double[] values) {
        gg.method_25294(x, y, x + w, y + h, 0x3000FF00);
        if (values == null || values.length == 0) {
            return;
        }
        double max = 1.0E-4;
        for (double v : values) {
            if (!(v > max)) continue;
            max = v;
        }
        int n = values.length;
        gg.method_25303(this.field_22793, "AI ms", x, y - 10, 0xA0A0A0);
        int prevX = x;
        int prevY = y + h - (int)Math.round(values[0] / max * (double)(h - 1));
        int color = -24576;
        for (int i = 1; i < n; ++i) {
            int xi = x + i * (w - 1) / (n - 1);
            int yi = y + h - (int)Math.round(values[i] / max * (double)(h - 1));
            this.drawLine(gg, prevX, prevY, xi, yi, color);
            prevX = xi;
            prevY = yi;
        }
    }

    private void drawLine(class_332 gg, int x0, int y0, int x1, int y1, int color) {
        int dx = Math.abs(x1 - x0);
        int dy = -Math.abs(y1 - y0);
        int sx = x0 < x1 ? 1 : -1;
        int sy = y0 < y1 ? 1 : -1;
        int err = dx + dy;
        int x = x0;
        int y = y0;
        while (true) {
            gg.method_25294(x, y, x + 1, y + 1, color);
            if (x == x1 && y == y1) break;
            int e2 = 2 * err;
            if (e2 >= dy) {
                err += dy;
                x += sx;
            }
            if (e2 > dx) continue;
            err += dx;
            y += sy;
        }
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25394(class_332 gg, int mouseX, int mouseY, float partialTick) {
        int i;
        this.method_25420(gg);
        if (this.hm != null && (this.field_22789 != this.lastCalcWidth || this.field_22790 != this.lastCalcHeight || this.hm.size != this.lastCalcHmSize || this.lodEnabled != this.lastCalcLodEnabled)) {
            this.calculateLOD();
        }
        int availW = this.field_22789 - this.padding * 2;
        int availH = this.field_22790 - this.padding * 3 - 40;
        int cell = Math.max(2, Math.min(availW / this.lodGridSize, availH / this.lodGridSize));
        int gridW = cell * this.lodGridSize;
        int gridH = cell * this.lodGridSize;
        int left = (this.field_22789 - gridW) / 2;
        int top = this.padding + 20;
        gg.method_25300(this.field_22793, this.field_22785.getString(), this.field_22789 / 2, this.padding / 2, 0xFFFFFF);
        String info = String.format("dim=%s origin=(%d,%d) size=%dx%d tick=%d gTPS=%.2f LOD=%dx%d [%s]", this.hm.dim, this.hm.originRx, this.hm.originRz, this.hm.size, this.hm.size, this.hm.tick, this.hm.globalTPS, this.lodLevel, this.lodLevel, this.lodEnabled ? "Auto" : "Off");
        gg.method_25300(this.field_22793, info, this.field_22789 / 2, this.padding, 0xA0A0A0);
        for (int r = 0; r < this.lodGridSize; ++r) {
            for (int c = 0; c < this.lodGridSize; ++c) {
                int x0 = left + c * cell;
                int y0 = top + r * cell;
                int x1 = x0 + cell - 1;
                int y1 = y0 + cell - 1;
                int color = this.colorForCell(r, c);
                gg.method_25294(x0, y0, x1, y1, color);
                if (this.lodLevel <= 1) continue;
                gg.method_25294(x0, y0, x1, y0 + 1, -2130706433);
                gg.method_25294(x0, y0, x0 + 1, y1, -2130706433);
            }
        }
        int lineColor = this.lodLevel > 1 ? 0x60FFFFFF : 0x40FFFFFF;
        for (i = 0; i <= this.lodGridSize; ++i) {
            int x = left + i * cell;
            gg.method_25294(x, top, x + 1, top + gridH, lineColor);
        }
        for (i = 0; i <= this.lodGridSize; ++i) {
            int y = top + i * cell;
            gg.method_25294(left, y, left + gridW, y + 1, lineColor);
        }
        if (cell >= 12) {
            for (int r = 0; r < this.lodGridSize; ++r) {
                for (int c = 0; c < this.lodGridSize; ++c) {
                    int ty;
                    int tx;
                    String s;
                    int x0 = left + c * cell;
                    int y0 = top + r * cell;
                    if (this.lodLevel > 1) {
                        s = String.valueOf(this.lodRegionCount[r][c]);
                        tx = x0 + (cell - this.field_22793.method_1727(s)) / 2;
                        Objects.requireNonNull(this.field_22793);
                        ty = y0 + (cell - 9) / 2 - 4;
                        gg.method_25303(this.field_22793, s, tx, ty, -16777216);
                        String mulStr = "x" + this.lodMultiplier[r][c];
                        tx = x0 + (cell - this.field_22793.method_1727(mulStr)) / 2;
                        Objects.requireNonNull(this.field_22793);
                        ty = y0 + (cell - 9) / 2 + 6;
                        gg.method_25303(this.field_22793, mulStr, tx, ty, -8388608);
                        continue;
                    }
                    s = String.valueOf(this.lodMultiplier[r][c]);
                    tx = x0 + (cell - this.field_22793.method_1727(s)) / 2;
                    Objects.requireNonNull(this.field_22793);
                    ty = y0 + (cell - 9) / 2;
                    gg.method_25303(this.field_22793, s, tx, ty, -16777216);
                }
            }
        }
        int legendY = top + gridH + 8;
        String modeLabel = switch (this.colorMode.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> "AI ms";
            case 1 -> "Mem MB";
            case 2 -> "Players";
            case 3 -> "Priority";
        };
        String legendText = this.lodLevel > 1 ? String.format("Color = %s, Number = region count, LOD = %dx%d merged", modeLabel, this.lodLevel, this.lodLevel) : String.format("Color = %s, Number = multiplier - Individual Regions", modeLabel);
        gg.method_25300(this.field_22793, legendText, this.field_22789 / 2, legendY, 0xFFFFFF);
        String controls = "Mouse wheel: zoom | Right-drag: pan | ESC: close | LOD: " + (this.lodEnabled ? "Auto (click)" : "Off (click)") + " | Mode: " + modeLabel + " (click)";
        int controlsY = legendY + 12;
        gg.method_25300(this.field_22793, controls, this.field_22789 / 2, controlsY, 0xA0A0A0);
        int controlsWidth = this.field_22793.method_1727(controls);
        this.legendX1 = this.field_22789 / 2 - controlsWidth / 2;
        this.legendX2 = this.legendX1 + controlsWidth;
        this.legendY1 = controlsY;
        Objects.requireNonNull(this.field_22793);
        this.legendY2 = controlsY + 9;
        int preModeWidth = this.field_22793.method_1727("Mouse wheel: zoom | Right-drag: pan | ESC: close | LOD: " + (this.lodEnabled ? "Auto (click)" : "Off (click)") + " | Mode: ");
        this.modeX1 = this.legendX1 + preModeWidth;
        this.modeX2 = this.legendX2;
        this.modeY1 = this.legendY1;
        this.modeY2 = this.legendY2;
        if (mouseX >= left && mouseX < left + gridW && mouseY >= top && mouseY < top + gridH && cell > 0) {
            int c = (mouseX - left) / cell;
            int r = (mouseY - top) / cell;
            if (r >= 0 && r < this.lodGridSize && c >= 0 && c < this.lodGridSize) {
                String line1;
                String line2 = "";
                if (this.lodLevel > 1) {
                    int baseR = r * this.lodLevel + this.lodLevel / 2;
                    int baseC = c * this.lodLevel + this.lodLevel / 2;
                    baseR = Math.min(baseR, this.hm.size - 1);
                    baseC = Math.min(baseC, this.hm.size - 1);
                    int rx = this.hm.originRx + baseC;
                    int rz = this.hm.originRz + baseR;
                    line1 = String.format("Merged Region Center=(%d,%d) [%d regions]", rx, rz, this.lodRegionCount[r][c]);
                    switch (this.colorMode.ordinal()) {
                        case 0: {
                            line2 = String.format("avgAI=%.2f ms, maxMul=%d", this.lodAvgMs[r][c], this.lodMultiplier[r][c]);
                            break;
                        }
                        case 1: {
                            line2 = String.format("avgMem=%.1f MB, maxMul=%d", this.lodAvgMem[r][c], this.lodMultiplier[r][c]);
                            break;
                        }
                        case 2: {
                            line2 = String.format("players=%d, maxMul=%d", this.lodPlayerCount[r][c], this.lodMultiplier[r][c]);
                            break;
                        }
                        case 3: {
                            line2 = String.format("priority=%s, maxMul=%d", new Object[]{this.lodPriority[r][c], this.lodMultiplier[r][c]});
                        }
                    }
                } else {
                    int rx = this.hm.originRx + c;
                    int rz = this.hm.originRz + r;
                    line1 = String.format("Region=(%d,%d)", rx, rz);
                    switch (this.colorMode.ordinal()) {
                        case 0: {
                            line2 = String.format("avgAI=%.2f ms, mul=%d", this.lodAvgMs[r][c], this.lodMultiplier[r][c]);
                            break;
                        }
                        case 1: {
                            line2 = String.format("avgMem=%.1f MB, mul=%d", this.lodAvgMem[r][c], this.lodMultiplier[r][c]);
                            break;
                        }
                        case 2: {
                            line2 = String.format("players=%d, mul=%d", this.lodPlayerCount[r][c], this.lodMultiplier[r][c]);
                            break;
                        }
                        case 3: {
                            line2 = String.format("priority=%s, mul=%d", new Object[]{this.lodPriority[r][c], this.lodMultiplier[r][c]});
                        }
                    }
                }
                int tx = mouseX + 12;
                int ty = mouseY + 8;
                int maxWidth = Math.max(this.field_22793.method_1727(line1), this.field_22793.method_1727(line2));
                Objects.requireNonNull(this.field_22793);
                gg.method_25294(tx - 4, ty - 4, tx + maxWidth + 4, ty + 9 * 2 + 4, -1342177280);
                gg.method_25303(this.field_22793, line1, tx, ty, 0xFFFFFF);
                Objects.requireNonNull(this.field_22793);
                gg.method_25303(this.field_22793, line2, tx, ty + 9 + 2, 0xFFFFFF);
            }
        }
        this.renderDetailPanel(gg);
        super.method_25394(gg, mouseX, mouseY, partialTick);
    }

    private int colorForCell(int r, int c) {
        return switch (this.colorMode.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> this.colorFromGradient(this.lodAvgMs[r][c] / 20.0, this.lodMultiplier[r][c]);
            case 1 -> this.colorFromGradient(Math.min(1.0, this.lodAvgMem[r][c] / 256.0), this.lodMultiplier[r][c]);
            case 2 -> this.colorFromGradient(Math.min(1.0, (double)this.lodPlayerCount[r][c] / 10.0), this.lodMultiplier[r][c]);
            case 3 -> this.colorForPriority(this.lodPriority[r][c]);
        };
    }

    private int colorFromGradient(double tRaw, int mul) {
        double t = Math.min(1.0, Math.max(0.0, tRaw));
        int r = (int)Math.round(255.0 * t);
        int g = (int)Math.round(255.0 * (1.0 - Math.max(0.0, (t - 0.3) / 0.7)));
        int b = 32;
        if (mul >= 4) {
            r = 255;
            g = (int)((double)g * 0.5);
        } else if (mul >= 2) {
            r = Math.min(255, r + 40);
        }
        int a = 192;
        return a << 24 | r << 16 | g << 8 | b;
    }

    private int colorForPriority(RegionalTpsService.RegionStats.RegionPriority pr) {
        int a = 192;
        int r = 0;
        int g = 0;
        int b = 0;
        switch (pr) {
            case SPAWN: {
                r = 60;
                g = 180;
                b = 255;
                break;
            }
            case PLAYER_BASE: {
                r = 80;
                g = 220;
                b = 120;
                break;
            }
            case NORMAL: {
                r = 200;
                g = 200;
                b = 80;
                break;
            }
            case WILDERNESS: {
                r = 200;
                g = 120;
                b = 60;
                break;
            }
            case INACTIVE: {
                r = 150;
                g = 100;
                b = 150;
            }
        }
        return a << 24 | r << 16 | g << 8 | b;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.detailPanel.dragging || this.detailPanel.resizing) {
            this.detailPanel.stopDrag();
            this.currentResizeHandle = ResizeHandle.NONE;
            return true;
        }
        if (button == 0 && this.detailPanel.visible && this.detailPanel.isMouseInTitleBar(mouseX, mouseY)) {
            String closeX = "\u00d7";
            int closeX_width = this.field_22793.method_1727(closeX);
            int closeButtonX = this.detailPanel.x + this.detailPanel.width - closeX_width - 8;
            int closeButtonY = this.detailPanel.y + 6;
            if (mouseX >= (double)closeButtonX && mouseX <= (double)(closeButtonX + closeX_width) && mouseY >= (double)closeButtonY) {
                Objects.requireNonNull(this.field_22793);
                if (mouseY <= (double)(closeButtonY + 9)) {
                    this.detailPanel.visible = false;
                    this.selectedRx = Integer.MIN_VALUE;
                    this.selectedRz = Integer.MIN_VALUE;
                    this.detail = null;
                    this.mergedDetail = null;
                    return true;
                }
            }
        }
        if (this.dragging && button == 1) {
            this.dragging = false;
            int availW = this.field_22789 - this.padding * 2;
            int gridSize = this.hm.size;
            int availH = this.field_22790 - this.padding * 3 - 40;
            int cell = Math.max(2, Math.min(availW / gridSize, availH / gridSize));
            if (cell > 0) {
                int dxCells = (int)Math.round((mouseX - this.dragStartX) / (double)cell);
                int dyCells = (int)Math.round((mouseY - this.dragStartY) / (double)cell);
                int newOriginRx = this.dragStartOriginRx - dxCells;
                int newOriginRz = this.dragStartOriginRz - dyCells;
                WmbNetwork.requestHeatmap(this.hm.dim, newOriginRx, newOriginRz, this.hm.size);
            }
            return true;
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        int curr = this.hm.size;
        int newSize = curr + (delta > 0.0 ? -2 : 2);
        if ((newSize = Math.max(5, Math.min(this.originalHeatmapSize, newSize))) != curr) {
            int centerRx = this.hm.originRx + curr / 2;
            int centerRz = this.hm.originRz + curr / 2;
            int newOriginRx = centerRx - newSize / 2;
            int newOriginRz = centerRz - newSize / 2;
            WmbNetwork.requestHeatmap(this.hm.dim, newOriginRx, newOriginRz, newSize);
            return true;
        }
        return super.method_25401(mouseX, mouseY, delta);
    }

    private static enum ColorMode {
        AI_MS,
        MEM_MB,
        PLAYERS,
        PRIORITY;

    }

    private static enum ResizeHandle {
        NONE,
        N,
        S,
        E,
        W,
        NE,
        NW,
        SE,
        SW;

    }

    private static class ResizablePanel {
        public int x;
        public int y;
        public int width;
        public int height;
        public int minWidth;
        public int minHeight;
        public boolean dragging = false;
        public boolean resizing = false;
        public double dragStartX;
        public double dragStartY;
        public int dragStartPanelX;
        public int dragStartPanelY;
        public int dragStartWidth;
        public int dragStartHeight;
        public String title;
        public boolean visible = true;
        private static final int RESIZE_BORDER = 8;

        public ResizablePanel(String title, int x, int y, int width, int height, int minWidth, int minHeight) {
            this.title = title;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.minWidth = minWidth;
            this.minHeight = minHeight;
        }

        public boolean isMouseInTitleBar(double mouseX, double mouseY) {
            return mouseX >= (double)this.x && mouseX < (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY < (double)(this.y + 20);
        }

        public ResizeHandle getResizeHandle(double mouseX, double mouseY) {
            boolean nearBottom;
            if (!this.isMouseInPanel(mouseX, mouseY)) {
                return ResizeHandle.NONE;
            }
            boolean nearLeft = mouseX < (double)(this.x + 8);
            boolean nearRight = mouseX > (double)(this.x + this.width - 8);
            boolean nearTop = mouseY < (double)(this.y + 8);
            boolean bl = nearBottom = mouseY > (double)(this.y + this.height - 8);
            if (nearRight && nearBottom) {
                return ResizeHandle.SE;
            }
            if (nearLeft && nearBottom) {
                return ResizeHandle.SW;
            }
            if (nearRight && nearTop) {
                return ResizeHandle.NE;
            }
            if (nearLeft && nearTop) {
                return ResizeHandle.NW;
            }
            if (nearRight) {
                return ResizeHandle.E;
            }
            if (nearLeft) {
                return ResizeHandle.W;
            }
            if (nearBottom) {
                return ResizeHandle.S;
            }
            if (nearTop) {
                return ResizeHandle.N;
            }
            return ResizeHandle.NONE;
        }

        public boolean isMouseInPanel(double mouseX, double mouseY) {
            return this.visible && mouseX >= (double)this.x && mouseX < (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY < (double)(this.y + this.height);
        }

        public void startDrag(double mouseX, double mouseY) {
            this.dragging = true;
            this.dragStartX = mouseX;
            this.dragStartY = mouseY;
            this.dragStartPanelX = this.x;
            this.dragStartPanelY = this.y;
        }

        public void startResize(double mouseX, double mouseY) {
            this.resizing = true;
            this.dragStartX = mouseX;
            this.dragStartY = mouseY;
            this.dragStartPanelX = this.x;
            this.dragStartPanelY = this.y;
            this.dragStartWidth = this.width;
            this.dragStartHeight = this.height;
        }

        public void updateDrag(double mouseX, double mouseY, int screenWidth, int screenHeight) {
            if (this.dragging) {
                int newX = (int)((double)this.dragStartPanelX + (mouseX - this.dragStartX));
                int newY = (int)((double)this.dragStartPanelY + (mouseY - this.dragStartY));
                this.x = Math.max(0, Math.min(screenWidth - this.width, newX));
                this.y = Math.max(0, Math.min(screenHeight - this.height, newY));
            }
        }

        public void updateResize(double mouseX, double mouseY, ResizeHandle handle, int screenWidth, int screenHeight) {
            if (!this.resizing) {
                return;
            }
            int deltaX = (int)(mouseX - this.dragStartX);
            int deltaY = (int)(mouseY - this.dragStartY);
            switch (handle.ordinal()) {
                case 7: {
                    this.width = Math.max(this.minWidth, this.dragStartWidth + deltaX);
                    this.height = Math.max(this.minHeight, this.dragStartHeight + deltaY);
                    break;
                }
                case 8: {
                    int newWidth = Math.max(this.minWidth, this.dragStartWidth - deltaX);
                    this.x = this.dragStartPanelX + (this.dragStartWidth - newWidth);
                    this.width = newWidth;
                    this.height = Math.max(this.minHeight, this.dragStartHeight + deltaY);
                    break;
                }
                case 5: {
                    this.width = Math.max(this.minWidth, this.dragStartWidth + deltaX);
                    int newHeight = Math.max(this.minHeight, this.dragStartHeight - deltaY);
                    this.y = this.dragStartPanelY + (this.dragStartHeight - newHeight);
                    this.height = newHeight;
                    break;
                }
                case 6: {
                    int newW = Math.max(this.minWidth, this.dragStartWidth - deltaX);
                    int newH = Math.max(this.minHeight, this.dragStartHeight - deltaY);
                    this.x = this.dragStartPanelX + (this.dragStartWidth - newW);
                    this.y = this.dragStartPanelY + (this.dragStartHeight - newH);
                    this.width = newW;
                    this.height = newH;
                    break;
                }
                case 3: {
                    this.width = Math.max(this.minWidth, this.dragStartWidth + deltaX);
                    break;
                }
                case 4: {
                    int nW = Math.max(this.minWidth, this.dragStartWidth - deltaX);
                    this.x = this.dragStartPanelX + (this.dragStartWidth - nW);
                    this.width = nW;
                    break;
                }
                case 2: {
                    this.height = Math.max(this.minHeight, this.dragStartHeight + deltaY);
                    break;
                }
                case 1: {
                    int nH = Math.max(this.minHeight, this.dragStartHeight - deltaY);
                    this.y = this.dragStartPanelY + (this.dragStartHeight - nH);
                    this.height = nH;
                }
            }
            this.x = Math.max(0, Math.min(screenWidth - this.width, this.x));
            this.y = Math.max(0, Math.min(screenHeight - this.height, this.y));
        }

        public void stopDrag() {
            this.dragging = false;
            this.resizing = false;
        }
    }

    private static class MergedRegionDetail {
        public final String dim;
        public final int rx;
        public final int rz;
        public final double avgMs;
        public final int multiplier;
        public final int entityCount;
        public final int mobCount;
        public final int lastActiveTicks;
        public final int lastBeCount;
        public final int lastSchedTickCount;
        public final double[] msHistory;
        public final int regionCount;
        public final double avgMemMB;
        public final int totalPlayers;
        public final RegionalTpsService.RegionStats.RegionPriority priority;

        public MergedRegionDetail(String dim, int rx, int rz, double avgMs, int multiplier, int entityCount, int mobCount, int lastActiveTicks, int lastBeCount, int lastSchedTickCount, double[] msHistory, int regionCount, double avgMemMB, int totalPlayers, RegionalTpsService.RegionStats.RegionPriority priority) {
            this.dim = dim;
            this.rx = rx;
            this.rz = rz;
            this.avgMs = avgMs;
            this.multiplier = multiplier;
            this.entityCount = entityCount;
            this.mobCount = mobCount;
            this.lastActiveTicks = lastActiveTicks;
            this.lastBeCount = lastBeCount;
            this.lastSchedTickCount = lastSchedTickCount;
            this.msHistory = msHistory;
            this.regionCount = regionCount;
            this.avgMemMB = avgMemMB;
            this.totalPlayers = totalPlayers;
            this.priority = priority;
        }
    }
}

