/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.wmb.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2232;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import org.texboobcat.wmb.config.Presets;
import org.texboobcat.wmb.config.WmbConfig;
import org.texboobcat.wmb.dab.DabPolicy;
import org.texboobcat.wmb.metrics.Metrics;
import org.texboobcat.wmb.network.WmbNetwork;
import org.texboobcat.wmb.profile.Profiler;
import org.texboobcat.wmb.regional.RegionalTpsService;
import org.texboobcat.wmb.test.StressTestManager;
import org.texboobcat.wmb.tracking.AsyncEntityTracker;

public final class WmbCommands {
    private WmbCommands() {
    }

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder root = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"wmb").requires(src -> src.method_9259(2))).then(class_2170.method_9247((String)"reload").executes(ctx -> WmbCommands.reload((class_2168)ctx.getSource())))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"metrics").then(class_2170.method_9247((String)"on").executes(ctx -> WmbCommands.metricsToggle((class_2168)ctx.getSource(), true)))).then(class_2170.method_9247((String)"off").executes(ctx -> WmbCommands.metricsToggle((class_2168)ctx.getSource(), false))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"regions").then(class_2170.method_9247((String)"here").executes(ctx -> WmbCommands.regionsHere((class_2168)ctx.getSource())))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"top").then(class_2170.method_9244((String)"n", (ArgumentType)IntegerArgumentType.integer((int)1, (int)100)).executes(ctx -> WmbCommands.regionsTop((class_2168)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"n"))))).executes(ctx -> WmbCommands.regionsTop((class_2168)ctx.getSource(), 10))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"heatmap").then(class_2170.method_9244((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)1, (int)32)).executes(ctx -> WmbCommands.heatmap((class_2168)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"radius"))))).executes(ctx -> WmbCommands.heatmap((class_2168)ctx.getSource(), 8)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"tuning").then(class_2170.method_9247((String)"on").executes(ctx -> WmbCommands.tuningToggle((class_2168)ctx.getSource(), true)))).then(class_2170.method_9247((String)"off").executes(ctx -> WmbCommands.tuningToggle((class_2168)ctx.getSource(), false))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"preset").then(class_2170.method_9247((String)"vanilla").executes(ctx -> WmbCommands.applyPreset((class_2168)ctx.getSource(), "VANILLA")))).then(class_2170.method_9247((String)"balanced").executes(ctx -> WmbCommands.applyPreset((class_2168)ctx.getSource(), "BALANCED")))).then(class_2170.method_9247((String)"aggressive").executes(ctx -> WmbCommands.applyPreset((class_2168)ctx.getSource(), "AGGRESSIVE"))))).then(class_2170.method_9247((String)"stats").executes(ctx -> WmbCommands.stats((class_2168)ctx.getSource())))).then(class_2170.method_9247((String)"trackerstats").executes(ctx -> WmbCommands.trackerStats((class_2168)ctx.getSource())))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"debug").then(class_2170.method_9247((String)"entity").executes(ctx -> WmbCommands.debugEntity((class_2168)ctx.getSource())))).then(class_2170.method_9247((String)"chunk").executes(ctx -> WmbCommands.debugChunk((class_2168)ctx.getSource()))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"profile").then(class_2170.method_9247((String)"start").executes(ctx -> WmbCommands.profileStart((class_2168)ctx.getSource())))).then(class_2170.method_9247((String)"stop").executes(ctx -> WmbCommands.profileStop((class_2168)ctx.getSource()))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"stresstest").then(class_2170.method_9247((String)"start").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"entity", (ArgumentType)class_2232.method_9441()).executes(ctx -> WmbCommands.stressStart((class_2168)ctx.getSource(), class_2232.method_9443((CommandContext)ctx, (String)"entity"), 100, 32, 1200, 20, 8, true))).then(class_2170.method_9244((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1, (int)5000)).then(class_2170.method_9244((String)"radius", (ArgumentType)IntegerArgumentType.integer((int)4, (int)256)).then(class_2170.method_9244((String)"duration", (ArgumentType)IntegerArgumentType.integer((int)100, (int)72000)).then(class_2170.method_9244((String)"pathEvery", (ArgumentType)IntegerArgumentType.integer((int)0, (int)200)).then(class_2170.method_9244((String)"waypoints", (ArgumentType)IntegerArgumentType.integer((int)1, (int)64)).executes(ctx -> WmbCommands.stressStart((class_2168)ctx.getSource(), class_2232.method_9443((CommandContext)ctx, (String)"entity"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"count"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"radius"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"duration"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"pathEvery"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"waypoints"), true)))))))))).then(class_2170.method_9247((String)"stop").executes(ctx -> WmbCommands.stressStop((class_2168)ctx.getSource())))).then(class_2170.method_9247((String)"status").executes(ctx -> WmbCommands.stressStatus((class_2168)ctx.getSource())))).then(class_2170.method_9247((String)"report").executes(ctx -> WmbCommands.stressReport((class_2168)ctx.getSource()))));
        dispatcher.register(root);
    }

    private static int heatmap(class_2168 src, int radius) {
        try {
            class_3222 player = src.method_9207();
            class_1937 class_19372 = player.method_37908();
            if (!(class_19372 instanceof class_3218)) {
                src.method_9213((class_2561)class_2561.method_43470((String)"[WMB] Not on server level."));
                return 0;
            }
            class_3218 level = (class_3218)class_19372;
            int r = Math.max(1, Math.min(32, radius));
            RegionalTpsService.Heatmap hm = RegionalTpsService.exportHeatmap(level, player.method_24515(), r);
            WmbNetwork.sendHeatmap(player, hm);
            src.method_9226(() -> class_2561.method_43470((String)("[WMB] Sent heatmap (" + hm.size + "x" + hm.size + ") to client.")), false);
            return 1;
        }
        catch (Exception e) {
            src.method_9213((class_2561)class_2561.method_43470((String)("[WMB] heatmap failed: " + e.getMessage())));
            return 0;
        }
    }

    private static int regionsHere(class_2168 src) {
        try {
            class_3222 player = src.method_9207();
            class_1937 class_19372 = player.method_37908();
            if (!(class_19372 instanceof class_3218)) {
                src.method_9213((class_2561)class_2561.method_43470((String)"[WMB] Not on server level."));
                return 0;
            }
            class_3218 level = (class_3218)class_19372;
            String s = RegionalTpsService.regionInfo(level, player.method_24515());
            src.method_9226(() -> class_2561.method_43470((String)("[WMB] Region: " + s)), false);
            return 1;
        }
        catch (Exception e) {
            src.method_9213((class_2561)class_2561.method_43470((String)("[WMB] regions here failed: " + e.getMessage())));
            return 0;
        }
    }

    private static int regionsTop(class_2168 src, int n) {
        try {
            class_3222 player = src.method_9207();
            class_1937 class_19372 = player.method_37908();
            if (!(class_19372 instanceof class_3218)) {
                src.method_9213((class_2561)class_2561.method_43470((String)"[WMB] Not on server level."));
                return 0;
            }
            class_3218 level = (class_3218)class_19372;
            List<String> list = RegionalTpsService.topRegions(n);
            if (list.isEmpty()) {
                src.method_9226(() -> class_2561.method_43470((String)"[WMB] No active regions."), false);
                return 1;
            }
            src.method_9226(() -> class_2561.method_43470((String)"[WMB] Top Regions (by avg AI ms):"), false);
            for (String s : list) {
                src.method_9226(() -> class_2561.method_43470((String)(" - " + s)), false);
            }
            return 1;
        }
        catch (Exception e) {
            src.method_9213((class_2561)class_2561.method_43470((String)("[WMB] regions top failed: " + e.getMessage())));
            return 0;
        }
    }

    private static int reload(class_2168 src) {
        WmbConfig.reload();
        src.method_9226(() -> class_2561.method_43470((String)"[WMB] Config reloaded."), true);
        return 1;
    }

    private static int debugEntity(class_2168 src) {
        try {
            String typeStr;
            class_3222 player = src.method_9207();
            class_1937 class_19372 = player.method_37908();
            if (!(class_19372 instanceof class_3218)) {
                src.method_9213((class_2561)class_2561.method_43470((String)"[WMB] Not on server level."));
                return 0;
            }
            class_3218 level = (class_3218)class_19372;
            class_238 box = player.method_5829().method_1014(16.0);
            List list = level.method_18467(class_1308.class, box);
            class_1308 nearest = null;
            double nearestDist2 = Double.POSITIVE_INFINITY;
            for (class_1308 m : list) {
                double d2 = m.method_5858((class_1297)player);
                if (!(d2 < nearestDist2)) continue;
                nearestDist2 = d2;
                nearest = m;
            }
            if (nearest == null) {
                src.method_9226(() -> class_2561.method_43470((String)"[WMB] No mob within 16 blocks."), false);
                return 1;
            }
            double minDistSqr = Double.POSITIVE_INFINITY;
            for (class_3222 p : level.method_18456()) {
                double d2 = p.method_5858((class_1297)nearest);
                if (!(d2 < minDistSqr)) continue;
                minDistSqr = d2;
            }
            int interval = DabPolicy.computeInterval(nearest, minDistSqr);
            class_2960 key = class_7923.field_41177.method_10221((Object)nearest.method_5864());
            String typeStrF = typeStr = key != null ? key.toString() : nearest.method_5477().getString();
            double ex = nearest.method_23317();
            double ey = nearest.method_23318();
            double ez = nearest.method_23321();
            double dist = Math.sqrt(minDistSqr);
            int intervalF = interval;
            src.method_9226(() -> class_2561.method_43470((String)String.format("[WMB] Entity %s @ (%.1f, %.1f, %.1f) dist=%.2f interval=%d", typeStrF, ex, ey, ez, dist, intervalF)), false);
            return 1;
        }
        catch (Exception e) {
            src.method_9213((class_2561)class_2561.method_43470((String)("[WMB] debug entity failed: " + e.getMessage())));
            return 0;
        }
    }

    private static int debugChunk(class_2168 src) {
        try {
            class_3222 player = src.method_9207();
            class_1937 class_19372 = player.method_37908();
            if (!(class_19372 instanceof class_3218)) {
                src.method_9213((class_2561)class_2561.method_43470((String)"[WMB] Not on server level."));
                return 0;
            }
            class_3218 level = (class_3218)class_19372;
            class_1923 cp = new class_1923(player.method_24515());
            int x0 = cp.method_8326();
            int z0 = cp.method_8328();
            int x1 = x0 + 16;
            int z1 = z0 + 16;
            class_238 area = new class_238((double)x0, (double)level.method_31607(), (double)z0, (double)x1, (double)level.method_31600(), (double)z1);
            List list = level.method_18467(class_1308.class, area);
            int count = list.size();
            double avgInterval = 0.0;
            if (count > 0) {
                long sum = 0L;
                for (class_1308 m : list) {
                    double minDistSqr = Double.POSITIVE_INFINITY;
                    for (class_3222 p : level.method_18456()) {
                        double d2 = p.method_5858((class_1297)m);
                        if (!(d2 < minDistSqr)) continue;
                        minDistSqr = d2;
                    }
                    int iv = DabPolicy.computeInterval(m, minDistSqr);
                    sum += (long)iv;
                }
                avgInterval = (double)sum / (double)count;
            }
            int cx = cp.field_9181;
            int cz = cp.field_9180;
            int countF = count;
            double avgF = avgInterval;
            src.method_9226(() -> class_2561.method_43470((String)String.format("[WMB] Chunk %d,%d mobs=%d avgInterval=%.2f", cx, cz, countF, avgF)), false);
            return 1;
        }
        catch (Exception e) {
            src.method_9213((class_2561)class_2561.method_43470((String)("[WMB] debug chunk failed: " + e.getMessage())));
            return 0;
        }
    }

    private static int stats(class_2168 src) {
        WmbConfig c = WmbConfig.get();
        src.method_9226(() -> class_2561.method_43470((String)("[WMB] DAB: " + (c.dab.enabled ? "enabled" : "disabled") + String.format(" d0=%.1f d1=%.1f d2=%.1f", c.dab.d0, c.dab.d1, c.dab.d2) + String.format(" hysteresis=%.1f", c.dab.hysteresisBlocks) + String.format(" multipliers[n=%d,m=%d,f=%d,d=%d]", c.dab.nearMultiplier, c.dab.midMultiplier, c.dab.farMultiplier, c.dab.distantMultiplier) + String.format(" per-dimension=%d", c.dab.perDimension.size()))), false);
        src.method_9226(() -> class_2561.method_43470((String)("[WMB] Proximity: updateIntervalTicks=" + c.proximity.updateIntervalTicks)), false);
        src.method_9226(() -> class_2561.method_43470((String)("[WMB] AsyncSpawn: " + (c.asyncSpawn.enabled ? "enabled" : "disabled") + " threads=" + c.asyncSpawn.threadPoolSize)), false);
        src.method_9226(() -> class_2561.method_43470((String)("[WMB] AsyncTracker: " + (c.asyncTracker.enabled ? "enabled" : "disabled") + " threads=" + c.asyncTracker.threadPoolSize + " updateInterval=" + c.asyncTracker.updateInterval + " cacheDuration=" + c.asyncTracker.cacheDuration)), false);
        src.method_9226(() -> class_2561.method_43470((String)("[WMB] Checks: suffocationInterval=" + c.checks.suffocationInterval)), false);
        src.method_9226(() -> class_2561.method_43470((String)("[WMB] Metrics: " + (c.metrics.enabled ? "enabled" : "disabled"))), false);
        src.method_9226(() -> class_2561.method_43470((String)("[WMB] Tuning: " + (c.tuning.enabled ? "enabled" : "disabled") + String.format(" targetTickMs=%.1f window=%d cooldown=%d minRecalc[%d..%d]", c.tuning.targetTickMs, c.tuning.windowTicks, c.tuning.cooldownTicks, c.tuning.minRecalcMin, c.tuning.minRecalcMax) + String.format(" pid[kp=%.3f,ki=%.3f,kd=%.3f] maxStep=%d iMax=%.1f", c.tuning.kp, c.tuning.ki, c.tuning.kd, c.tuning.maxStepPerWindow, c.tuning.integralMaxAbs))), false);
        src.method_9226(() -> class_2561.method_43470((String)("[WMB] PathfindingCfg: enabled=" + c.pathfinding.enabled + " minRecalcInterval=" + c.pathfinding.minRecalcInterval + " groupWindowTicks=" + c.pathfinding.groupWindowTicks + " cacheTtlTicks=" + c.pathfinding.cacheTtlTicks + " share=" + (c.pathfinding.experimentalShareEnabled ? "on" : "off"))), false);
        if (c.metrics.enabled) {
            Metrics.Snapshot s = Metrics.snapshot();
            src.method_9226(() -> class_2561.method_43470((String)String.format("[WMB] Metrics: aiExecuted=%d aiSkipped=%d avgInterval=%.2f", s.aiStepsExecuted, s.aiStepsSkipped, s.avgInterval())), false);
            src.method_9226(() -> class_2561.method_43470((String)String.format("[WMB] Metrics: skippedBreakdown [dab=%d, regional=%d, entity=%d, visibility=%d]", s.aiStepsSkippedDab, s.aiStepsSkippedRegional, s.aiStepsSkippedEntity, s.aiStepsSkippedVisibility)), false);
            src.method_9226(() -> class_2561.method_43470((String)String.format("[WMB] Pathfinding: calls=%d avg=%.2f\u00b5s shared{pub=%d,claim=%d}", s.pathfindCount, s.avgPathfindMicros(), s.pathSharedPublished, s.pathSharedClaimed)), false);
            src.method_9226(() -> class_2561.method_43470((String)String.format("[WMB] AsyncSpawn: fillBatches=%d avgFill=%.2fms candidates=%d", s.spawnFillBatches, s.avgSpawnFillMillis(), s.spawnCandidateCount)), false);
            src.method_9226(() -> class_2561.method_43470((String)String.format("[WMB] Tick: avg=%.2fms TPS=%.2f", s.avgTickMillis(), s.tps())), false);
        }
        return 1;
    }

    private static int trackerStats(class_2168 src) {
        WmbConfig c = WmbConfig.get();
        src.method_9226(() -> class_2561.method_43470((String)AsyncEntityTracker.getStatusString()), false);
        if (c.metrics.enabled) {
            Metrics.Snapshot s = Metrics.snapshot();
            src.method_9226(() -> class_2561.method_43470((String)String.format("[WMB] TrackerMetrics: tasks=%d avg=%.3fms queue=%d", s.trackerTaskCount, s.avgTrackerTaskMillis(), s.trackerQueueSize)), false);
        }
        return 1;
    }

    private static int profileStart(class_2168 src) {
        Profiler.start();
        src.method_9226(() -> class_2561.method_43470((String)"[WMB] Profiling started."), true);
        return 1;
    }

    private static int profileStop(class_2168 src) {
        Profiler.ProfileSnapshot snap = Profiler.stop();
        double avgMicros = snap.avgAiMicros();
        double totalMillis = (double)snap.totalAiNanos / 1000000.0;
        src.method_9226(() -> class_2561.method_43470((String)String.format("[WMB] Profiling stopped. AI steps=%d total=%.2fms avg=%.2f\u00b5s", snap.totalAiCount, totalMillis, avgMicros)), true);
        return 1;
    }

    private static int stressStart(class_2168 src, class_2960 entityId, int count, int radius, int duration, int pathEvery, int waypoints, boolean cleanup) {
        try {
            class_3222 player = src.method_9207();
            class_1937 class_19372 = player.method_37908();
            if (!(class_19372 instanceof class_3218)) {
                src.method_9213((class_2561)class_2561.method_43470((String)"[WMB] Not on server level."));
                return 0;
            }
            class_3218 level = (class_3218)class_19372;
            class_1299 type = (class_1299)class_7923.field_41177.method_10223(entityId);
            if (type == null) {
                src.method_9213((class_2561)class_2561.method_43470((String)("[WMB] Unknown entity id: " + String.valueOf(entityId))));
                return 0;
            }
            if (!(type.method_5883((class_1937)level) instanceof class_1308)) {
                src.method_9213((class_2561)class_2561.method_43470((String)"[WMB] Entity must be a Mob type."));
                return 0;
            }
            class_1299 mobType = type;
            class_2338 center = player.method_24515();
            String dimId = level.method_27983().method_29177().toString();
            StressTestManager.ScenarioConfig cfg = new StressTestManager.ScenarioConfig((class_1299<? extends class_1308>)mobType, count, radius, duration, pathEvery, waypoints, cleanup, center, dimId);
            if (StressTestManager.isRunning()) {
                src.method_9213((class_2561)class_2561.method_43470((String)"[WMB] Stress test already running."));
                return 0;
            }
            boolean ok = StressTestManager.start(level, cfg);
            if (!ok) {
                src.method_9213((class_2561)class_2561.method_43470((String)"[WMB] Failed to start stress test."));
                return 0;
            }
            src.method_9226(() -> class_2561.method_43470((String)("[WMB] Stress test started: entity=" + String.valueOf(entityId) + " count=" + count + " radius=" + radius + " duration=" + duration + " pathEvery=" + pathEvery + " waypoints=" + waypoints)), true);
            return 1;
        }
        catch (Exception e) {
            src.method_9213((class_2561)class_2561.method_43470((String)("[WMB] stress start failed: " + e.getMessage())));
            return 0;
        }
    }

    private static int stressStop(class_2168 src) {
        try {
            class_3222 player = src.method_9207();
            class_1937 class_19372 = player.method_37908();
            if (!(class_19372 instanceof class_3218)) {
                src.method_9213((class_2561)class_2561.method_43470((String)"[WMB] Not on server level."));
                return 0;
            }
            class_3218 level = (class_3218)class_19372;
            if (!StressTestManager.isRunning()) {
                src.method_9213((class_2561)class_2561.method_43470((String)"[WMB] No stress test running."));
                return 0;
            }
            StressTestManager.stop(level);
            src.method_9226(() -> class_2561.method_43470((String)"[WMB] Stress test stopped. Report printed to console."), true);
            return 1;
        }
        catch (Exception e) {
            src.method_9213((class_2561)class_2561.method_43470((String)("[WMB] stress stop failed: " + e.getMessage())));
            return 0;
        }
    }

    private static int stressStatus(class_2168 src) {
        String s = StressTestManager.statusString();
        src.method_9226(() -> class_2561.method_43470((String)s), false);
        return 1;
    }

    private static int stressReport(class_2168 src) {
        String s = StressTestManager.liveReport();
        src.method_9226(() -> class_2561.method_43470((String)s), false);
        return 1;
    }

    private static int applyPreset(class_2168 src, String name) {
        WmbConfig cfg = WmbConfig.get();
        boolean ok = Presets.apply(cfg, name);
        if (!ok) {
            src.method_9213((class_2561)class_2561.method_43470((String)("[WMB] Unknown preset: " + name)));
            return 0;
        }
        src.method_9226(() -> class_2561.method_43470((String)("[WMB] Preset applied: " + name + " (runtime only). Use /wmb reload to revert from file.")), true);
        return 1;
    }

    private static int tuningToggle(class_2168 src, boolean on) {
        WmbConfig cfg = WmbConfig.get();
        cfg.tuning.enabled = on;
        src.method_9226(() -> class_2561.method_43470((String)("[WMB] Tuning " + (on ? "enabled" : "disabled"))), true);
        return 1;
    }

    private static int metricsToggle(class_2168 src, boolean on) {
        WmbConfig cfg = WmbConfig.get();
        cfg.metrics.enabled = on;
        src.method_9226(() -> class_2561.method_43470((String)("[WMB] Metrics " + (on ? "enabled" : "disabled"))), true);
        return 1;
    }
}

