/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.wmb.dab;

import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_2960;
import net.minecraft.class_6025;
import net.minecraft.class_7923;
import org.texboobcat.wmb.api.WmbApi;
import org.texboobcat.wmb.config.WmbConfig;

public final class DabPolicy {
    private DabPolicy() {
    }

    public static int computeInterval(class_1308 mob, double nearestPlayerDistSqr) {
        return DabPolicy.computeInterval(mob, nearestPlayerDistSqr, 0);
    }

    public static int computeInterval(class_1308 mob, double nearestPlayerDistSqr, int currentInterval) {
        int bucket;
        class_2960 key;
        WmbConfig.PerEntityPolicy p;
        WmbConfig c = WmbConfig.get();
        if (!c.dab.enabled) {
            return 1;
        }
        if (mob.method_5934() || mob.method_16914() || DabPolicy.isOwned(mob)) {
            return 1;
        }
        class_1299 type = mob.method_5864();
        if (WmbApi.isExempt(type) || WmbApi.isHighPriority(type)) {
            return 1;
        }
        String dimId = mob.method_37908().method_27983().method_29177().toString();
        double d0 = c.dab.d0;
        double d1 = c.dab.d1;
        double d2 = c.dab.d2;
        int nearMul = c.dab.nearMultiplier;
        int midMul = c.dab.midMultiplier;
        int farMul = c.dab.farMultiplier;
        int distantMul = c.dab.distantMultiplier;
        WmbConfig.DimensionOverrides dimOv = c.dab.perDimension.get(dimId);
        if (dimOv != null) {
            if (dimOv.d0 != null) {
                d0 = dimOv.d0;
            }
            if (dimOv.d1 != null) {
                d1 = dimOv.d1;
            }
            if (dimOv.d2 != null) {
                d2 = dimOv.d2;
            }
            if (dimOv.nearMultiplier != null) {
                nearMul = dimOv.nearMultiplier;
            }
            if (dimOv.midMultiplier != null) {
                midMul = dimOv.midMultiplier;
            }
            if (dimOv.farMultiplier != null) {
                farMul = dimOv.farMultiplier;
            }
            if (dimOv.distantMultiplier != null) {
                distantMul = dimOv.distantMultiplier;
            }
        }
        WmbConfig.PerEntityPolicy perEntityPolicy = p = (key = class_7923.field_41177.method_10221((Object)type)) != null ? c.dab.perEntityOverrides.get(key.toString()) : null;
        if (p != null) {
            if (p.exempt || p.highPriority) {
                return 1;
            }
            if (p.nearMultiplier != null) {
                nearMul = p.nearMultiplier;
            }
            if (p.midMultiplier != null) {
                midMul = p.midMultiplier;
            }
            if (p.farMultiplier != null) {
                farMul = p.farMultiplier;
            }
            if (p.distantMultiplier != null) {
                distantMul = p.distantMultiplier;
            }
        } else if (DabPolicy.isBoss(type)) {
            return 1;
        }
        double h = c.dab.hysteresisBlocks;
        double d0m = Math.max(0.0, d0 - h);
        double d0p = d0 + h;
        double d1m = Math.max(0.0, d1 - h);
        double d1p = d1 + h;
        double d2m = Math.max(0.0, d2 - h);
        double d2p = d2 + h;
        double d0_2 = d0 * d0;
        double d1_2 = d1 * d1;
        double d2_2 = d2 * d2;
        double d0m_2 = d0m * d0m;
        double d0p_2 = d0p * d0p;
        double d1m_2 = d1m * d1m;
        double d1p_2 = d1p * d1p;
        double d2m_2 = d2m * d2m;
        double d2p_2 = d2p * d2p;
        if (currentInterval <= 0 || h <= 0.0) {
            bucket = nearestPlayerDistSqr <= d0_2 ? 0 : (nearestPlayerDistSqr <= d1_2 ? 1 : (nearestPlayerDistSqr <= d2_2 ? 2 : 3));
        } else {
            int currentBucket = currentInterval <= Math.max(1, nearMul) ? 0 : (currentInterval <= Math.max(1, midMul) ? 1 : (currentInterval <= Math.max(1, farMul) ? 2 : 3));
            double d2s = nearestPlayerDistSqr;
            bucket = d2s <= d0m_2 ? 0 : (d2s < d0p_2 ? (currentBucket <= 0 ? 0 : 1) : (d2s <= d1m_2 ? 1 : (d2s < d1p_2 ? (currentBucket <= 1 ? 1 : 2) : (d2s <= d2m_2 ? 2 : (d2s < d2p_2 ? (currentBucket <= 2 ? 2 : 3) : 3)))));
        }
        return switch (bucket) {
            case 0 -> Math.max(1, nearMul);
            case 1 -> Math.max(1, midMul);
            case 2 -> Math.max(1, farMul);
            default -> Math.max(1, distantMul);
        };
    }

    private static boolean isOwned(class_1308 mob) {
        try {
            if (mob instanceof class_6025) {
                class_6025 own = (class_6025)mob;
                return own.method_35057() != null;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    private static boolean isBoss(class_1299<?> type) {
        return type == class_1299.field_6119 || type == class_1299.field_6116;
    }
}

