/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.wmb.mixin;

import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1408;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_6025;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.texboobcat.wmb.api.WmbApi;
import org.texboobcat.wmb.api.event.WMBEntityTickEvent;
import org.texboobcat.wmb.config.WmbConfig;
import org.texboobcat.wmb.dab.DabPolicy;
import org.texboobcat.wmb.metrics.Metrics;
import org.texboobcat.wmb.profile.Profiler;
import org.texboobcat.wmb.proximity.ProximityService;
import org.texboobcat.wmb.regional.RegionalTpsService;

@Mixin(value={class_1308.class})
public abstract class MobMixin {
    @Unique
    private int wmb$currentInterval = 1;
    @Unique
    private int wmb$counter = 0;
    @Unique
    private long wmb$profileStartNanos = 0L;
    @Unique
    private int wmb$cullCounter = 0;
    @Unique
    private int wmb$visCounter = 0;
    @Unique
    private boolean wmb$nextIntervalRegionalDominant = false;
    @Unique
    private boolean wmb$activeRegionalDominant = false;
    @Unique
    private WmbConfig wmb$cachedConfig = null;
    @Unique
    private int wmb$configCacheTick = Integer.MIN_VALUE;
    @Unique
    private static final int CONFIG_CACHE_INTERVAL = 100;
    @Unique
    private class_1923 wmb$tempMobChunk = null;
    @Unique
    private class_1923 wmb$tempPlayerChunk = null;
    @Unique
    private boolean wmb$isExempt = false;
    @Unique
    private int wmb$exemptCacheTick = Integer.MIN_VALUE;
    @Unique
    private static final int EXEMPT_CACHE_INTERVAL = 200;
    @Unique
    private double wmb$cachedMinDistSqr = Double.POSITIVE_INFINITY;
    @Unique
    private int wmb$distCacheTick = Integer.MIN_VALUE;

    @Inject(method={"serverAiStep"}, at={@At(value="HEAD")}, cancellable=true)
    private void wmb$throttleServerAiStep(CallbackInfo ci) {
        class_1308 self = (class_1308)this;
        class_1937 level = self.method_37908();
        if (!(level instanceof class_3218)) {
            return;
        }
        class_3218 serverLevel = (class_3218)level;
        int currentTick = self.field_6012;
        WmbConfig config = this.getCachedConfig(currentTick);
        boolean forceTick = WmbApi.consumeImmediateTick(self);
        if (forceTick) {
            this.wmb$counter = 0;
            this.executeAiStep(self, config, currentTick);
            return;
        }
        double minDistSqr = this.getCachedPlayerDistance(self, serverLevel, currentTick);
        if (config.culling.enabled && this.shouldCullByEntityCriteria(self, minDistSqr, config, currentTick)) {
            if (this.handleCullingCounter(this.wmb$cullCounter, config.culling.allowEveryNTicks, config.metrics.enabled, () -> Metrics.onAiStepSkippedEntity(), ci)) {
                ++this.wmb$cullCounter;
                return;
            }
            this.wmb$cullCounter = 0;
        } else {
            this.wmb$cullCounter = 0;
        }
        if (config.visibility.enabled && this.shouldCullByVisibility(self, (class_1937)serverLevel, config, currentTick)) {
            if (this.handleCullingCounter(this.wmb$visCounter, config.visibility.allowEveryNTicks, config.metrics.enabled, () -> Metrics.onAiStepSkippedVisibility(), ci)) {
                ++this.wmb$visCounter;
                return;
            }
            this.wmb$visCounter = 0;
        } else {
            this.wmb$visCounter = 0;
        }
        int dabInterval = DabPolicy.computeInterval(self, minDistSqr, this.wmb$currentInterval);
        int regionMul = 1;
        try {
            boolean exempt = false;
            try {
                class_1299 type = self.method_5864();
                if (WmbApi.isExempt(type)) {
                    exempt = true;
                }
                if (type == class_1299.field_6119 || type == class_1299.field_6116) {
                    exempt = true;
                }
            }
            catch (Throwable type) {
                // empty catch block
            }
            try {
                if (self.method_5934() || self.method_16914()) {
                    exempt = true;
                }
            }
            catch (Throwable type) {
                // empty catch block
            }
            try {
                class_6025 own;
                if (self instanceof class_6025 && (own = (class_6025)self).method_35057() != null) {
                    exempt = true;
                }
            }
            catch (Throwable own) {
                // empty catch block
            }
            regionMul = !exempt ? RegionalTpsService.currentRegionMultiplier(serverLevel, self.method_24515()) : 1;
        }
        catch (Throwable exempt) {
            // empty catch block
        }
        int targetInterval = dabInterval;
        boolean regionalDominant = false;
        if (regionMul > targetInterval) {
            targetInterval = regionMul;
            regionalDominant = true;
        }
        this.wmb$nextIntervalRegionalDominant = regionalDominant;
        this.updateInterval(targetInterval);
        if (this.wmb$counter > 0) {
            --this.wmb$counter;
            if (config.metrics.enabled) {
                if (this.wmb$activeRegionalDominant) {
                    Metrics.onAiStepSkippedRegional();
                } else {
                    Metrics.onAiStepSkippedDab();
                }
            }
            ci.cancel();
            return;
        }
        this.executeAiStep(self, config, currentTick);
    }

    @Inject(method={"serverAiStep"}, at={@At(value="TAIL")})
    private void wmb$profileServerAiStepTail(CallbackInfo ci) {
        class_1308 self = (class_1308)this;
        if (this.wmb$profileStartNanos != 0L) {
            class_1937 lvl;
            long duration = System.nanoTime() - this.wmb$profileStartNanos;
            this.wmb$profileStartNanos = 0L;
            if (Profiler.isActive()) {
                Profiler.recordAiDuration(duration);
            }
            if ((lvl = self.method_37908()) instanceof class_3218) {
                class_3218 sl = (class_3218)lvl;
                try {
                    RegionalTpsService.recordEntityAiDuration(sl, self.method_24515(), duration);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        WMBEntityTickEvent.firePost(self);
    }

    @Unique
    private void executeAiStep(class_1308 self, WmbConfig config, int currentTick) {
        WMBEntityTickEvent.firePre(self);
        this.wmb$counter = Math.max(0, this.wmb$currentInterval - 1);
        this.wmb$activeRegionalDominant = this.wmb$nextIntervalRegionalDominant;
        if (config.metrics.enabled) {
            Metrics.onAiStepExecuted(this.wmb$currentInterval);
        }
        this.wmb$profileStartNanos = System.nanoTime();
    }

    @Unique
    private void updateInterval(int targetInterval) {
        this.wmb$currentInterval = targetInterval < this.wmb$currentInterval ? Math.max(targetInterval, this.wmb$currentInterval - 1) : targetInterval;
    }

    @Unique
    private boolean handleCullingCounter(int counter, int allowEvery, boolean metricsEnabled, Runnable metricsCallback, CallbackInfo ci) {
        int every = Math.max(1, allowEvery);
        if (counter < every - 1) {
            if (metricsEnabled) {
                metricsCallback.run();
            }
            ci.cancel();
            return true;
        }
        return false;
    }

    @Unique
    private WmbConfig getCachedConfig(int currentTick) {
        if (this.wmb$cachedConfig == null || currentTick - this.wmb$configCacheTick >= 100) {
            this.wmb$cachedConfig = WmbConfig.get();
            this.wmb$configCacheTick = currentTick;
        }
        return this.wmb$cachedConfig;
    }

    @Unique
    private double getCachedPlayerDistance(class_1308 self, class_3218 level, int currentTick) {
        if (currentTick - this.wmb$distCacheTick >= 2) {
            class_243 mobPos = self.method_19538();
            this.wmb$cachedMinDistSqr = ProximityService.nearestPlayerDistSqr(level, mobPos.field_1352, mobPos.field_1351, mobPos.field_1350);
            this.wmb$distCacheTick = currentTick;
        }
        return this.wmb$cachedMinDistSqr;
    }

    @Unique
    private boolean getCachedExemption(class_1308 mob, boolean exemptNamed, boolean exemptLeashed, boolean exemptOwned, boolean exemptPersistent, int currentTick) {
        if (currentTick - this.wmb$exemptCacheTick >= 200) {
            this.wmb$isExempt = MobMixin.isExemptCommon(mob, exemptNamed, exemptLeashed, exemptOwned, exemptPersistent);
            this.wmb$exemptCacheTick = currentTick;
        }
        return this.wmb$isExempt;
    }

    @Unique
    private class_1923 getOrCreateMobChunk(class_1308 mob) {
        int x = mob.method_31477() >> 4;
        int z = mob.method_31479() >> 4;
        if (this.wmb$tempMobChunk == null || this.wmb$tempMobChunk.field_9181 != x || this.wmb$tempMobChunk.field_9180 != z) {
            this.wmb$tempMobChunk = new class_1923(x, z);
        }
        return this.wmb$tempMobChunk;
    }

    @Unique
    private class_1923 getOrCreatePlayerChunk(class_1657 player) {
        int x = player.method_31477() >> 4;
        int z = player.method_31479() >> 4;
        if (this.wmb$tempPlayerChunk == null || this.wmb$tempPlayerChunk.field_9181 != x || this.wmb$tempPlayerChunk.field_9180 != z) {
            this.wmb$tempPlayerChunk = new class_1923(x, z);
        }
        return this.wmb$tempPlayerChunk;
    }

    @Unique
    private static boolean isOwned(class_1308 mob) {
        class_6025 own;
        return mob instanceof class_6025 && (own = (class_6025)mob).method_35057() != null;
    }

    @Unique
    private static boolean isLowMotion(class_1308 mob, double speedThreshold) {
        double thresholdSqr;
        class_243 deltaMovement = mob.method_18798();
        double speedSqr = deltaMovement.method_1027();
        return speedSqr <= (thresholdSqr = speedThreshold * speedThreshold);
    }

    @Unique
    private static boolean noActivePath(class_1308 mob) {
        try {
            class_1408 navigation = mob.method_5942();
            return navigation == null || navigation.method_6357();
        }
        catch (Throwable ignored) {
            return true;
        }
    }

    @Unique
    private static boolean hasTarget(class_1308 mob) {
        try {
            return mob.method_5968() != null;
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    @Unique
    private static boolean isExemptCommon(class_1308 mob, boolean exemptNamed, boolean exemptLeashed, boolean exemptOwned, boolean exemptPersistent) {
        if (exemptLeashed && mob.method_5934()) {
            return true;
        }
        if (exemptNamed && mob.method_16914()) {
            return true;
        }
        if (exemptOwned && MobMixin.isOwned(mob)) {
            return true;
        }
        if (exemptPersistent) {
            try {
                if (mob.method_5947()) {
                    return true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        try {
            return WmbApi.isExempt(mob.method_5864()) || WmbApi.isHighPriority(mob.method_5864());
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    @Unique
    private boolean shouldCullByEntityCriteria(class_1308 mob, double nearestPlayerDistSqr, WmbConfig config, int currentTick) {
        WmbConfig.CullingCfg cullingCfg = config.culling;
        if (!cullingCfg.enabled) {
            return false;
        }
        if (this.getCachedExemption(mob, cullingCfg.exemptNamed, cullingCfg.exemptLeashed, cullingCfg.exemptOwned, cullingCfg.exemptPersistent, currentTick)) {
            return false;
        }
        double distance = Math.sqrt(nearestPlayerDistSqr);
        if (distance < cullingCfg.minDistance) {
            return false;
        }
        if (cullingCfg.requireNoTarget && MobMixin.hasTarget(mob)) {
            return false;
        }
        if (cullingCfg.requireNoPath && !MobMixin.noActivePath(mob)) {
            return false;
        }
        return !cullingCfg.requireLowMotion || MobMixin.isLowMotion(mob, cullingCfg.lowMotionSpeed);
    }

    @Unique
    private boolean shouldCullByVisibility(class_1308 mob, class_1937 level, WmbConfig config, int currentTick) {
        WmbConfig.VisibilityCfg visibilityCfg = config.visibility;
        if (!visibilityCfg.enabled) {
            return false;
        }
        if (this.getCachedExemption(mob, visibilityCfg.exemptNamed, visibilityCfg.exemptLeashed, visibilityCfg.exemptOwned, visibilityCfg.exemptPersistent, currentTick)) {
            return false;
        }
        class_1923 mobChunk = this.getOrCreateMobChunk(mob);
        int range = Math.max(0, visibilityCfg.playerChunkRange);
        boolean hasNearbyPlayer = false;
        for (class_1657 player : level.method_18456()) {
            class_1923 playerChunk = this.getOrCreatePlayerChunk(player);
            int chebDistance = Math.max(Math.abs(playerChunk.field_9181 - mobChunk.field_9181), Math.abs(playerChunk.field_9180 - mobChunk.field_9180));
            if (chebDistance > range) continue;
            hasNearbyPlayer = true;
            break;
        }
        if (hasNearbyPlayer) {
            return false;
        }
        if (visibilityCfg.requireNoTarget && MobMixin.hasTarget(mob)) {
            return false;
        }
        if (visibilityCfg.requireNoPath && !MobMixin.noActivePath(mob)) {
            return false;
        }
        return !visibilityCfg.requireLowMotion || MobMixin.isLowMotion(mob, visibilityCfg.lowMotionSpeed);
    }
}

