/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.wmb.mixin;

import net.minecraft.class_11;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1408;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.texboobcat.wmb.api.event.WMBPathfindRequestEvent;
import org.texboobcat.wmb.config.WmbConfig;
import org.texboobcat.wmb.metrics.Metrics;
import org.texboobcat.wmb.path.PathGroupManager;
import org.texboobcat.wmb.path.SharedPathRegistry;

@Mixin(value={class_1408.class})
public abstract class PathNavigationMixin {
    @Shadow
    protected class_1308 field_6684;
    @Unique
    private int wmb$lastPathTick = Integer.MIN_VALUE;
    @Unique
    private long wmb$lastTargetBucket = Long.MIN_VALUE;
    @Unique
    private int wmb$lastCacheTick = Integer.MIN_VALUE;
    @Unique
    private class_11 wmb$cachedPath = null;
    @Unique
    private long wmb$pfStartNanos = 0L;
    @Unique
    private WmbConfig wmb$cachedConfig = null;
    @Unique
    private int wmb$configCacheTick = Integer.MIN_VALUE;
    @Unique
    private static final int CONFIG_CACHE_INTERVAL = 100;
    @Unique
    private class_1923 wmb$tempOriginChunk = null;
    @Unique
    private class_1923 wmb$tempTargetChunk = null;

    @Shadow
    public abstract class_11 method_6345();

    @Inject(method={"createPath(Lnet/minecraft/core/BlockPos;I)Lnet/minecraft/world/level/pathfinder/Path;"}, at={@At(value="HEAD")}, cancellable=true)
    private void wmb$throttleCreatePathToPos(class_2338 target, int depth, CallbackInfoReturnable<class_11> cir) {
        class_1923 targetChunk;
        long bucket;
        WmbConfig config = this.getCachedConfig();
        if (!config.pathfinding.enabled) {
            return;
        }
        class_1923 origin = this.getOrCreateOriginChunk();
        if (this.handlePathfindingLogic(origin, bucket = PathGroupManager.bucketForTargetPos(targetChunk = this.getOrCreateTargetChunk(target)), target, null, config, cir)) {
            return;
        }
    }

    @Inject(method={"createPath(Lnet/minecraft/world/entity/Entity;I)Lnet/minecraft/world/level/pathfinder/Path;"}, at={@At(value="HEAD")}, cancellable=true)
    private void wmb$throttleCreatePathToEntity(class_1297 target, int depth, CallbackInfoReturnable<class_11> cir) {
        long bucket;
        WmbConfig config = this.getCachedConfig();
        if (!config.pathfinding.enabled) {
            return;
        }
        class_1923 origin = this.getOrCreateOriginChunk();
        if (this.handlePathfindingLogic(origin, bucket = PathGroupManager.bucketForTargetEntity(target.method_5628()), null, target, config, cir)) {
            return;
        }
    }

    @Inject(method={"createPath(Lnet/minecraft/core/BlockPos;I)Lnet/minecraft/world/level/pathfinder/Path;"}, at={@At(value="RETURN")})
    private void wmb$cacheOnReturnPos(class_2338 target, int depth, CallbackInfoReturnable<class_11> cir) {
        WmbConfig config = this.getCachedConfig();
        if (!config.pathfinding.enabled) {
            return;
        }
        class_1923 targetChunk = this.getOrCreateTargetChunk(target);
        this.handleCacheUpdate(PathGroupManager.bucketForTargetPos(targetChunk), (class_11)cir.getReturnValue(), config);
        this.recordMetrics(config);
    }

    @Inject(method={"createPath(Lnet/minecraft/world/entity/Entity;I)Lnet/minecraft/world/level/pathfinder/Path;"}, at={@At(value="RETURN")})
    private void wmb$cacheOnReturnEntity(class_1297 target, int depth, CallbackInfoReturnable<class_11> cir) {
        WmbConfig config = this.getCachedConfig();
        if (!config.pathfinding.enabled) {
            return;
        }
        this.handleCacheUpdate(PathGroupManager.bucketForTargetEntity(target.method_5628()), (class_11)cir.getReturnValue(), config);
        this.recordMetrics(config);
    }

    @Unique
    private boolean handlePathfindingLogic(class_1923 origin, long bucket, class_2338 targetPos, class_1297 targetEntity, WmbConfig config, CallbackInfoReturnable<class_11> cir) {
        class_1937 level = this.field_6684.method_37908();
        int now = this.field_6684.field_6012;
        String dim = level.method_27983().method_29177().toString();
        WMBPathfindRequestEvent.Context ctx = new WMBPathfindRequestEvent.Context(this.field_6684, dim, origin, bucket, now, targetPos, targetEntity);
        WMBPathfindRequestEvent.fire(ctx);
        if (ctx.getPath() != null) {
            cir.setReturnValue((Object)ctx.getPath());
            cir.cancel();
            return true;
        }
        if (ctx.isCancelled()) {
            cir.setReturnValue(null);
            cir.cancel();
            return true;
        }
        this.wmb$pfStartNanos = config.metrics.enabled ? System.nanoTime() : 0L;
        return this.handleThrottle(bucket, origin, dim, now, config, cir);
    }

    @Unique
    private boolean handleThrottle(long targetBucket, class_1923 origin, String dim, int now, WmbConfig config, CallbackInfoReturnable<class_11> cir) {
        class_11 claimed;
        class_11 reusedPath;
        int timeSinceLastPath;
        int minInterval = config.pathfinding.minRecalcInterval;
        if (targetBucket == this.wmb$lastTargetBucket && (timeSinceLastPath = now - this.wmb$lastPathTick) >= 0 && timeSinceLastPath < minInterval && (reusedPath = this.reusePathIfFresh(now, config.pathfinding.cacheTtlTicks)) != null) {
            cir.setReturnValue((Object)reusedPath);
            cir.cancel();
            return true;
        }
        if (config.pathfinding.experimentalShareEnabled && (claimed = SharedPathRegistry.tryClaim(dim, origin, targetBucket, now, config.pathfinding.shareTtlTicks)) != null) {
            cir.setReturnValue((Object)claimed);
            cir.cancel();
            return true;
        }
        if (PathGroupManager.shouldDefer(dim, origin, targetBucket, config.pathfinding.groupWindowTicks, now)) {
            class_11 reusedPath2 = this.reusePathIfFresh(now, config.pathfinding.cacheTtlTicks);
            if (reusedPath2 != null) {
                cir.setReturnValue((Object)reusedPath2);
                cir.cancel();
                return true;
            }
            if (now - this.wmb$lastPathTick < minInterval) {
                cir.setReturnValue(null);
                cir.cancel();
                return true;
            }
        }
        return false;
    }

    @Unique
    private void handleCacheUpdate(long targetBucket, class_11 result, WmbConfig config) {
        int now = this.field_6684.field_6012;
        this.wmb$lastTargetBucket = targetBucket;
        this.wmb$lastPathTick = now;
        if (result != null) {
            this.wmb$cachedPath = result;
            this.wmb$lastCacheTick = now;
            if (config.pathfinding.experimentalShareEnabled) {
                class_1937 level = this.field_6684.method_37908();
                String dim = level.method_27983().method_29177().toString();
                class_1923 origin = this.getOrCreateOriginChunk();
                SharedPathRegistry.publish(dim, origin, targetBucket, result, now);
            }
        }
    }

    @Unique
    private class_11 reusePathIfFresh(int now, int ttl) {
        int age;
        if (this.wmb$cachedPath != null && (age = now - this.wmb$lastCacheTick) >= 0 && age <= ttl) {
            return this.wmb$cachedPath;
        }
        class_11 current = this.method_6345();
        if (current != null) {
            this.wmb$cachedPath = current;
            this.wmb$lastCacheTick = now;
            return current;
        }
        return null;
    }

    @Unique
    private void recordMetrics(WmbConfig config) {
        if (config.metrics.enabled && this.wmb$pfStartNanos != 0L) {
            long nanos = System.nanoTime() - this.wmb$pfStartNanos;
            if (nanos > 0L) {
                Metrics.onPathfindDuration(nanos);
            }
            this.wmb$pfStartNanos = 0L;
        }
    }

    @Unique
    private WmbConfig getCachedConfig() {
        int now = this.field_6684.field_6012;
        if (this.wmb$cachedConfig == null || now - this.wmb$configCacheTick >= 100) {
            this.wmb$cachedConfig = WmbConfig.get();
            this.wmb$configCacheTick = now;
        }
        return this.wmb$cachedConfig;
    }

    @Unique
    private class_1923 getOrCreateOriginChunk() {
        class_2338 pos = this.field_6684.method_24515();
        if (this.wmb$tempOriginChunk == null) {
            this.wmb$tempOriginChunk = new class_1923(pos);
        } else {
            int currentX = pos.method_10263() >> 4;
            int currentZ = pos.method_10260() >> 4;
            if (this.wmb$tempOriginChunk.field_9181 != currentX || this.wmb$tempOriginChunk.field_9180 != currentZ) {
                this.wmb$tempOriginChunk = new class_1923(pos);
            }
        }
        return this.wmb$tempOriginChunk;
    }

    @Unique
    private class_1923 getOrCreateTargetChunk(class_2338 target) {
        if (this.wmb$tempTargetChunk == null) {
            this.wmb$tempTargetChunk = new class_1923(target);
        } else {
            int targetX = target.method_10263() >> 4;
            int targetZ = target.method_10260() >> 4;
            if (this.wmb$tempTargetChunk.field_9181 != targetX || this.wmb$tempTargetChunk.field_9180 != targetZ) {
                this.wmb$tempTargetChunk = new class_1923(target);
            }
        }
        return this.wmb$tempTargetChunk;
    }
}

