/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.wmb.network;

import dev.architectury.networking.NetworkManager;
import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_437;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.texboobcat.wmb.client.HeatmapScreen;
import org.texboobcat.wmb.client.WmbClient;
import org.texboobcat.wmb.regional.RegionalTpsService;

public final class WmbNetwork {
    public static final class_2960 HEATMAP_S2C = new class_2960("wmb", "heatmap");
    public static final class_2960 HEATMAP_REQ_C2S = new class_2960("wmb", "heatmap_req");
    public static final class_2960 REGION_DETAIL_C2S = new class_2960("wmb", "region_detail_req");
    public static final class_2960 REGION_DETAIL_S2C = new class_2960("wmb", "region_detail");

    private WmbNetwork() {
    }

    public static void init() {
        EnvExecutor.runInEnv((Env)Env.CLIENT, () -> () -> WmbNetwork.registerClientReceivers());
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (class_2960)REGION_DETAIL_C2S, (buf, ctx) -> {
            String dim = WmbNetwork.readString(buf);
            int rx = buf.method_10816();
            int rz = buf.method_10816();
            class_3222 sp = (class_3222)ctx.getPlayer();
            if (sp == null || sp.field_13995 == null) {
                return;
            }
            sp.field_13995.execute(() -> {
                class_3218 level = WmbNetwork.getServerLevelByDim(sp, dim);
                if (level != null) {
                    RegionalTpsService.RegionDetail detail = RegionalTpsService.exportRegionDetail(level, dim, rx, rz);
                    class_2540 out = new class_2540(Unpooled.buffer());
                    WmbNetwork.encodeRegionDetail(out, detail);
                    NetworkManager.sendToPlayer((class_3222)sp, (class_2960)REGION_DETAIL_S2C, (class_2540)out);
                }
            });
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (class_2960)HEATMAP_REQ_C2S, (buf, ctx) -> {
            String dim = WmbNetwork.readString(buf);
            int originRx = buf.method_10816();
            int originRz = buf.method_10816();
            int size = buf.method_10816();
            class_3222 sp = (class_3222)ctx.getPlayer();
            if (sp == null || sp.field_13995 == null) {
                return;
            }
            sp.field_13995.execute(() -> {
                class_3218 level = WmbNetwork.getServerLevelByDim(sp, dim);
                if (level != null) {
                    RegionalTpsService.Heatmap hm = RegionalTpsService.exportHeatmapByOrigin(level, dim, originRx, originRz, size);
                    class_2540 out = new class_2540(Unpooled.buffer());
                    WmbNetwork.encodeHeatmap(out, hm);
                    NetworkManager.sendToPlayer((class_3222)sp, (class_2960)HEATMAP_S2C, (class_2540)out);
                }
            });
        });
    }

    private static void registerClientReceivers() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (class_2960)HEATMAP_S2C, (buf, ctx) -> {
            RegionalTpsService.Heatmap hm = WmbNetwork.decodeHeatmap(buf);
            class_310.method_1551().execute(() -> {
                WmbClient.setLastHeatmap(hm);
                class_437 patt0$temp = class_310.method_1551().field_1755;
                if (patt0$temp instanceof HeatmapScreen) {
                    HeatmapScreen hs = (HeatmapScreen)patt0$temp;
                    hs.setHeatmap(hm);
                } else {
                    HeatmapScreen.open(hm);
                }
            });
        });
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (class_2960)REGION_DETAIL_S2C, (buf, ctx) -> {
            RegionalTpsService.RegionDetail detail = WmbNetwork.decodeRegionDetail(buf);
            class_310.method_1551().execute(() -> {
                class_437 patt0$temp = class_310.method_1551().field_1755;
                if (patt0$temp instanceof HeatmapScreen) {
                    HeatmapScreen hs = (HeatmapScreen)patt0$temp;
                    hs.onRegionDetail(detail);
                }
            });
        });
    }

    public static void sendHeatmap(class_3222 player, RegionalTpsService.Heatmap hm) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        WmbNetwork.encodeHeatmap(buf, hm);
        NetworkManager.sendToPlayer((class_3222)player, (class_2960)HEATMAP_S2C, (class_2540)buf);
    }

    public static void requestRegionDetail(String dim, int rx, int rz) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        WmbNetwork.writeString(buf, dim);
        buf.method_10804(rx);
        buf.method_10804(rz);
        NetworkManager.sendToServer((class_2960)REGION_DETAIL_C2S, (class_2540)buf);
    }

    public static void requestHeatmap(String dim, int originRx, int originRz, int size) {
        class_2540 buf = new class_2540(Unpooled.buffer());
        WmbNetwork.writeString(buf, dim);
        buf.method_10804(originRx);
        buf.method_10804(originRz);
        buf.method_10804(size);
        NetworkManager.sendToServer((class_2960)HEATMAP_REQ_C2S, (class_2540)buf);
    }

    private static void encodeHeatmap(class_2540 buf, RegionalTpsService.Heatmap hm) {
        WmbNetwork.writeString(buf, hm.dim);
        buf.method_10804(hm.originRx);
        buf.method_10804(hm.originRz);
        buf.method_10804(hm.size);
        buf.method_10791(hm.tick);
        buf.writeDouble(hm.globalTPS);
        for (int r = 0; r < hm.size; ++r) {
            for (int c = 0; c < hm.size; ++c) {
                buf.writeFloat((float)hm.avgMs[r][c]);
                buf.writeFloat((float)hm.avgMem[r][c]);
                buf.method_10804(hm.multiplier[r][c]);
                buf.method_10804(hm.playerCount[r][c]);
                int prioOrdinal = hm.priority[r][c].ordinal();
                buf.method_10804(prioOrdinal);
            }
        }
    }

    private static RegionalTpsService.Heatmap decodeHeatmap(class_2540 buf) {
        String dim = WmbNetwork.readString(buf);
        int originRx = buf.method_10816();
        int originRz = buf.method_10816();
        int size = buf.method_10816();
        long tick = buf.method_10792();
        double globalTPS = buf.readDouble();
        double[][] avgMs = new double[size][size];
        double[][] avgMem = new double[size][size];
        int[][] mul = new int[size][size];
        int[][] players = new int[size][size];
        RegionalTpsService.RegionStats.RegionPriority[][] priority = new RegionalTpsService.RegionStats.RegionPriority[size][size];
        for (int r = 0; r < size; ++r) {
            for (int c = 0; c < size; ++c) {
                avgMs[r][c] = buf.readFloat();
                avgMem[r][c] = buf.readFloat();
                mul[r][c] = buf.method_10816();
                players[r][c] = buf.method_10816();
                int prioOrdinal = buf.method_10816();
                RegionalTpsService.RegionStats.RegionPriority[] values = RegionalTpsService.RegionStats.RegionPriority.values();
                if (prioOrdinal < 0 || prioOrdinal >= values.length) {
                    prioOrdinal = 2;
                }
                priority[r][c] = values[prioOrdinal];
            }
        }
        return new RegionalTpsService.Heatmap(dim, originRx, originRz, size, avgMs, avgMem, mul, players, priority, tick, globalTPS);
    }

    private static void encodeRegionDetail(class_2540 buf, RegionalTpsService.RegionDetail d) {
        WmbNetwork.writeString(buf, d.dim);
        buf.method_10804(d.rx);
        buf.method_10804(d.rz);
        buf.writeFloat((float)d.avgMs);
        buf.writeFloat((float)d.avgMem);
        buf.method_10804(d.multiplier);
        buf.method_10804(d.targetMultiplier);
        buf.method_10804(d.lastActiveTicks);
        buf.method_10804(d.lastBeCount);
        buf.method_10804(d.lastSchedTickCount);
        buf.method_10804(d.lastRedstoneUpdates);
        buf.method_10791(d.tick);
        buf.method_10804(d.msHistory.length);
        for (double v : d.msHistory) {
            buf.writeFloat((float)v);
        }
        buf.method_10804(d.memHistory.length);
        for (double v : d.memHistory) {
            buf.writeFloat((float)v);
        }
        buf.method_10804(d.playerHistory.length);
        for (int v : d.playerHistory) {
            buf.method_10804(v);
        }
        buf.method_10804(d.entityCount);
        buf.method_10804(d.mobCount);
        buf.method_10804(d.priority.ordinal());
        buf.writeBoolean(d.emergencyMode);
        buf.method_10804(d.consecutiveGoodTicks);
        buf.method_10804(d.consecutiveBadTicks);
    }

    private static RegionalTpsService.RegionDetail decodeRegionDetail(class_2540 buf) {
        String dim = WmbNetwork.readString(buf);
        int rx = buf.method_10816();
        int rz = buf.method_10816();
        double avgMs = buf.readFloat();
        double avgMem = buf.readFloat();
        int mul = buf.method_10816();
        int targetMul = buf.method_10816();
        int active = buf.method_10816();
        int be = buf.method_10816();
        int sched = buf.method_10816();
        int red = buf.method_10816();
        long tick = buf.method_10792();
        int nMs = buf.method_10816();
        double[] msHist = new double[nMs];
        for (int i = 0; i < nMs; ++i) {
            msHist[i] = buf.readFloat();
        }
        int nMem = buf.method_10816();
        double[] memHist = new double[nMem];
        for (int i = 0; i < nMem; ++i) {
            memHist[i] = buf.readFloat();
        }
        int nPlayers = buf.method_10816();
        int[] playerHist = new int[nPlayers];
        for (int i = 0; i < nPlayers; ++i) {
            playerHist[i] = buf.method_10816();
        }
        int ent = buf.method_10816();
        int mob = buf.method_10816();
        int prioOrdinal = buf.method_10816();
        RegionalTpsService.RegionStats.RegionPriority[] values = RegionalTpsService.RegionStats.RegionPriority.values();
        if (prioOrdinal < 0 || prioOrdinal >= values.length) {
            prioOrdinal = 2;
        }
        RegionalTpsService.RegionStats.RegionPriority priority = values[prioOrdinal];
        boolean emergency = buf.readBoolean();
        int good = buf.method_10816();
        int bad = buf.method_10816();
        return new RegionalTpsService.RegionDetail(dim, rx, rz, avgMs, avgMem, mul, targetMul, active, be, sched, red, tick, msHist, memHist, playerHist, ent, mob, priority, emergency, good, bad);
    }

    private static void writeString(class_2540 buf, String s) {
        byte[] b = s.getBytes(StandardCharsets.UTF_8);
        buf.method_10804(b.length);
        buf.writeBytes(b);
    }

    private static String readString(class_2540 buf) {
        int len = buf.method_10816();
        byte[] b = new byte[len];
        buf.readBytes(b);
        return new String(b, StandardCharsets.UTF_8);
    }

    private static class_3218 getServerLevelByDim(class_3222 sp, String dim) {
        try {
            class_2960 rl = new class_2960(dim);
            class_5321 key = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)rl);
            return sp.field_13995.method_3847(key);
        }
        catch (Exception e) {
            return null;
        }
    }
}

