/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.wmb.proximity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public final class ProximityService {
    private static final int CELL_SIZE_BLOCKS = 128;
    private static final Map<class_2960, LevelState> STATES = new HashMap<class_2960, LevelState>();
    private static long UPDATE_SEQ = 0L;
    private static double lastCandidateBest = Double.POSITIVE_INFINITY;

    private ProximityService() {
    }

    public static void update(MinecraftServer server) {
        ++UPDATE_SEQ;
        for (class_3218 level : server.method_3738()) {
            ProximityService.updateLevel(level);
        }
    }

    private static void updateLevel(class_3218 level) {
        LevelState st = STATES.computeIfAbsent(level.method_27983().method_29177(), k -> new LevelState());
        st.clear();
        st.lastUpdateSeq = UPDATE_SEQ;
        for (class_3222 p : level.method_18456()) {
            double x = p.method_23317();
            double y = p.method_23318();
            double z = p.method_23321();
            st.allPlayers.add(new PlayerPos(x, y, z));
            int cx = Math.floorDiv((int)Math.floor(x), 128);
            int cz = Math.floorDiv((int)Math.floor(z), 128);
            long key = ProximityService.cellKey(cx, cz);
            st.grid.computeIfAbsent(key, k -> new ArrayList()).add(new PlayerPos(x, y, z));
        }
    }

    public static double nearestPlayerDistSqr(class_3218 level, double x, double y, double z) {
        LevelState st = STATES.get(level.method_27983().method_29177());
        if (st == null || st.allPlayers.isEmpty()) {
            return Double.POSITIVE_INFINITY;
        }
        int cx = Math.floorDiv((int)Math.floor(x), 128);
        int cz = Math.floorDiv((int)Math.floor(z), 128);
        double best = Double.POSITIVE_INFINITY;
        int MAX_RADIUS = 8;
        for (int r = 0; r <= 8; ++r) {
            long k2;
            long k1;
            lastCandidateBest = best;
            boolean foundAny = false;
            for (int dx = -r; dx <= r; ++dx) {
                int sx = cx + dx;
                int z1 = cz - r;
                int z2 = cz + r;
                k1 = ProximityService.cellKey(sx, z1);
                k2 = ProximityService.cellKey(sx, z2);
                foundAny |= ProximityService.accumulateBest(st.grid.get(k1), x, y, z);
                foundAny |= ProximityService.accumulateBest(st.grid.get(k2), x, y, z);
            }
            for (int dz = -r + 1; dz <= r - 1; ++dz) {
                int sz = cz + dz;
                int x1 = cx - r;
                int x2 = cx + r;
                k1 = ProximityService.cellKey(x1, sz);
                k2 = ProximityService.cellKey(x2, sz);
                foundAny |= ProximityService.accumulateBest(st.grid.get(k1), x, y, z);
                foundAny |= ProximityService.accumulateBest(st.grid.get(k2), x, y, z);
            }
            if (!(lastCandidateBest < best)) continue;
            best = lastCandidateBest;
        }
        if (best < Double.POSITIVE_INFINITY) {
            return best;
        }
        for (PlayerPos pp : st.allPlayers) {
            double dx = pp.x - x;
            double dy = pp.y - y;
            double dz = pp.z - z;
            double d2 = dx * dx + dy * dy + dz * dz;
            if (!(d2 < best)) continue;
            best = d2;
        }
        return best;
    }

    private static boolean accumulateBest(List<PlayerPos> list, double x, double y, double z) {
        if (list == null || list.isEmpty()) {
            return false;
        }
        boolean found = false;
        for (PlayerPos pp : list) {
            found = true;
            double dx = pp.x - x;
            double dy = pp.y - y;
            double dz = pp.z - z;
            double d2 = dx * dx + dy * dy + dz * dz;
            if (!(d2 < lastCandidateBest)) continue;
            lastCandidateBest = d2;
        }
        return found;
    }

    private static long cellKey(int cx, int cz) {
        return (long)cx << 32 ^ (long)cz & 0xFFFFFFFFL;
    }

    private static final class LevelState {
        final Map<Long, List<PlayerPos>> grid = new HashMap<Long, List<PlayerPos>>();
        final List<PlayerPos> allPlayers = new ArrayList<PlayerPos>();
        long lastUpdateSeq = 0L;

        private LevelState() {
        }

        void clear() {
            this.grid.clear();
            this.allPlayers.clear();
        }
    }

    private static final class PlayerPos {
        final double x;
        final double y;
        final double z;

        PlayerPos(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }
}

