/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.wmb.regional;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import org.texboobcat.wmb.config.WmbConfig;

public final class RegionalTpsService {
    private static final Logger LOGGER = Logger.getLogger(RegionalTpsService.class.getName());
    private static final Map<String, Map<RegionKey, RegionStats>> PER_DIM = new ConcurrentHashMap<String, Map<RegionKey, RegionStats>>();
    private static final Map<UUID, RegionKey> PLAYER_REGIONS = new ConcurrentHashMap<UUID, RegionKey>();
    private static final Map<RegionKey, Long> REGION_PRIORITIES = new ConcurrentHashMap<RegionKey, Long>();
    private static long GLOBAL_TICK = 0L;
    private static double globalTPS = 20.0;
    private static final Queue<Long> tickTimes = new ArrayDeque<Long>();
    private static long lastTickTime = 0L;
    private static long LAST_EMERGENCY_TICK = -1L;

    private RegionalTpsService() {
    }

    public static void onServerPreTick(MinecraftServer server) {
        ++GLOBAL_TICK;
        long currentTime = System.nanoTime();
        if (lastTickTime != 0L) {
            tickTimes.offer(currentTime - lastTickTime);
            if (tickTimes.size() > 100) {
                tickTimes.poll();
            }
            if (tickTimes.size() >= 5) {
                double avgTickTime = tickTimes.stream().mapToLong(Long::longValue).average().orElse(5.0E7);
                double computed = 1.0E9 / Math.max(1.0, avgTickTime);
                globalTPS = Math.max(0.0, Math.min(20.0, computed));
            } else {
                globalTPS = 20.0;
            }
        }
        lastTickTime = currentTime;
        RegionalTpsService.updatePlayerRegions(server);
        for (Map<RegionKey, RegionStats> map : PER_DIM.values()) {
            for (RegionStats s : map.values()) {
                s.tickAiNanos = 0L;
                s.aiStepCount = 0;
                s.beCountTick = 0;
                s.schedTickCountTick = 0;
                s.totalMemoryUsage = 0L;
                s.redstoneUpdates = 0;
                s.tileEntityUpdates = 0;
                s.chunkLoads = 0;
            }
        }
    }

    public static void onServerPostTick(MinecraftServer server) {
        WmbConfig cfg = WmbConfig.get();
        if (!cfg.hasRegionalTps() || !cfg.regionalTPS.enabled) {
            RegionalTpsService.decayAverages(0.05);
            return;
        }
        double alpha = 2.0 / Math.max(2.0, (double)cfg.regionalTPS.windowTicks + 1.0);
        for (class_3218 level : server.method_3738()) {
            String dim = level.method_27983().method_29177().toString();
            Map map = PER_DIM.computeIfAbsent(dim, d -> new HashMap());
            for (RegionStats s : map.values()) {
                RegionalTpsService.updateRegionMetrics(s, alpha, cfg, dim);
                RegionalTpsService.updateRegionPriority(s, level);
                s.targetMultiplier = RegionalTpsService.decideMultiplier(cfg, dim, s);
                if (s.multiplier < s.targetMultiplier) {
                    s.multiplier = Math.min(s.targetMultiplier, s.multiplier + 1);
                } else if (s.multiplier > s.targetMultiplier) {
                    s.multiplier = Math.max(s.targetMultiplier, s.multiplier - 1);
                }
                s.lastUpdatedTick = GLOBAL_TICK;
            }
        }
        if (GLOBAL_TICK >= 200L && tickTimes.size() >= 20 && globalTPS < 15.0 && (LAST_EMERGENCY_TICK < 0L || GLOBAL_TICK - LAST_EMERGENCY_TICK >= 100L)) {
            LAST_EMERGENCY_TICK = GLOBAL_TICK;
            RegionalTpsService.triggerEmergencyMeasures(cfg);
        }
        RegionalTpsService.evictStale(10000L);
        if (GLOBAL_TICK % 1200L == 0L) {
            RegionalTpsService.logPerformanceStats();
        }
    }

    private static void updatePlayerRegions(MinecraftServer server) {
        PLAYER_REGIONS.clear();
        for (class_3218 level : server.method_3738()) {
            for (class_1657 player : level.method_18456()) {
                RegionKey key = RegionalTpsService.regionKey(level, player.method_24515());
                PLAYER_REGIONS.put(player.method_5667(), key);
                RegionStats stats = RegionalTpsService.getOrCreate(level, player.method_24515());
                stats.playersInRegion.add(player.method_5667());
                stats.hasPlayers = true;
                stats.lastPlayerActivity = GLOBAL_TICK;
            }
        }
    }

    private static void updateRegionMetrics(RegionStats s, double alpha, WmbConfig cfg, String dim) {
        boolean isPerforming;
        double ms = (double)s.tickAiNanos / 1000000.0;
        double memMB = (double)s.totalMemoryUsage / 1048576.0;
        if (s.avgMs == 0.0) {
            s.avgMs = ms;
            s.avgMemoryMB = memMB;
        } else {
            s.avgMs = (1.0 - alpha) * s.avgMs + alpha * ms;
            s.avgMemoryMB = (1.0 - alpha) * s.avgMemoryMB + alpha * memMB;
        }
        int hi = s.histIndex % s.msHistory.length;
        s.msHistory[hi] = ms;
        s.memHistory[hi] = memMB;
        s.playerHistory[hi % s.playerHistory.length] = s.playersInRegion.size();
        ++s.histIndex;
        if (s.histSize < s.msHistory.length) {
            ++s.histSize;
        }
        s.lastActiveTicks = s.aiStepCount;
        s.lastBeCount = s.beCountTick;
        s.lastSchedTickCount = s.schedTickCountTick;
        s.lastRedstoneUpdates = s.redstoneUpdates;
        WmbConfig.RegionalTPS rt = cfg.regionalTPS;
        boolean bl = isPerforming = ms <= rt.thresholds.maxTickMs && s.lastActiveTicks <= rt.thresholds.maxEntities;
        if (isPerforming) {
            ++s.consecutiveGoodTicks;
            s.consecutiveBadTicks = 0;
        } else {
            ++s.consecutiveBadTicks;
            s.consecutiveGoodTicks = 0;
        }
        s.playersInRegion.clear();
        s.hasPlayers = false;
    }

    private static void updateRegionPriority(RegionStats s, class_3218 level) {
        s.priority = RegionalTpsService.isSpawnRegion(level, s.rx, s.rz) ? RegionStats.RegionPriority.SPAWN : (s.hasPlayers || GLOBAL_TICK - s.lastPlayerActivity < 6000L ? RegionStats.RegionPriority.PLAYER_BASE : (GLOBAL_TICK - s.lastPlayerActivity > 72000L ? RegionStats.RegionPriority.INACTIVE : (s.lastActiveTicks < 5 && s.lastBeCount < 10 ? RegionStats.RegionPriority.WILDERNESS : RegionStats.RegionPriority.NORMAL)));
    }

    private static boolean isSpawnRegion(class_3218 level, int rx, int rz) {
        class_2338 spawn = level.method_43126();
        int spawnRx = RegionalTpsService.toRegionIndex(spawn.method_10263() >> 4);
        int spawnRz = RegionalTpsService.toRegionIndex(spawn.method_10260() >> 4);
        return Math.abs(rx - spawnRx) <= 1 && Math.abs(rz - spawnRz) <= 1;
    }

    private static int decideMultiplier(WmbConfig cfg, String dim, RegionStats s) {
        int targetLevel;
        boolean warning;
        String fullPrefix = dim + ":";
        String pathOnly = dim;
        int colon = dim.indexOf(58);
        if (colon >= 0 && colon < dim.length() - 1) {
            pathOnly = dim.substring(colon + 1);
        }
        String pathPrefix = pathOnly + ":";
        for (Map.Entry<String, String> e : cfg.regionalTPS.staticRegions.entrySet()) {
            String[] parts;
            String key = e.getKey();
            String coordPart = null;
            if (key.startsWith(fullPrefix)) {
                coordPart = key.substring(fullPrefix.length());
            } else if (key.startsWith(pathPrefix)) {
                coordPart = key.substring(pathPrefix.length());
            }
            if (coordPart == null || (parts = coordPart.split(",")).length != 2) continue;
            try {
                int x = Integer.parseInt(parts[0].trim());
                int z = Integer.parseInt(parts[1].trim());
                if (x != s.rx || z != s.rz) continue;
                String lvl = e.getValue();
                s.levelIndex = RegionalTpsService.levelStringToIndex(lvl);
                return RegionalTpsService.levelToMultiplier(cfg, lvl);
            }
            catch (NumberFormatException x) {
            }
        }
        double ms = s.avgMs;
        int active = s.lastActiveTicks;
        double memMB = s.avgMemoryMB;
        WmbConfig.RegionalTPS rt = cfg.regionalTPS;
        double priorityBias = s.priority.multiplierBias;
        double adjustedMsThreshold = rt.thresholds.maxTickMs * priorityBias;
        double adjustedEntityThreshold = (double)rt.thresholds.maxEntities * priorityBias;
        double adjustedBeThreshold = (double)rt.thresholds.maxBlockEntities * priorityBias;
        boolean emergency = ms > adjustedMsThreshold * 3.0 || (double)active > adjustedEntityThreshold * 2.5 || s.consecutiveBadTicks > 100 || globalTPS < 10.0 && ms > adjustedMsThreshold;
        boolean critical = ms > adjustedMsThreshold * 2.0 || (double)active > adjustedEntityThreshold * 2.0 || (double)s.lastBeCount > adjustedBeThreshold * 2.0 || memMB > 100.0 && s.priority != RegionStats.RegionPriority.SPAWN;
        boolean bl = warning = ms > adjustedMsThreshold || (double)active > adjustedEntityThreshold || (double)s.lastBeCount > adjustedBeThreshold;
        if (emergency) {
            targetLevel = 3;
            s.emergencyMode = true;
        } else if (critical) {
            targetLevel = 2;
        } else if (warning) {
            targetLevel = 1;
        } else {
            targetLevel = 0;
            if (s.consecutiveGoodTicks > 200) {
                s.emergencyMode = false;
            }
        }
        double hPct = Math.max(0.0, Math.min(0.5, rt.hysteresisPct));
        int currentLevel = s.levelIndex;
        if (targetLevel < currentLevel && currentLevel > 0) {
            int requiredGoodTicks = currentLevel == 3 ? 300 : (currentLevel == 2 ? 200 : 100);
            targetLevel = s.consecutiveGoodTicks < requiredGoodTicks ? currentLevel : Math.max(0, currentLevel - 1);
        }
        s.levelIndex = targetLevel;
        String levelName = RegionalTpsService.indexToLevelString(targetLevel);
        int baseMultiplier = RegionalTpsService.levelToMultiplier(cfg, levelName);
        if (s.emergencyMode && targetLevel >= 2) {
            baseMultiplier = Math.min(32, baseMultiplier * 2);
        }
        return Math.max(1, baseMultiplier);
    }

    private static void triggerEmergencyMeasures(WmbConfig cfg) {
        LOGGER.warning("Global TPS emergency detected: " + String.format("%.2f", globalTPS));
        List worstRegions = PER_DIM.values().stream().flatMap(map -> map.values().stream()).sorted((a, b) -> Double.compare(b.avgMs, a.avgMs)).limit(10L).toList();
        for (RegionStats region : worstRegions) {
            if (region.priority == RegionStats.RegionPriority.SPAWN) continue;
            region.emergencyMode = true;
            region.levelIndex = Math.max(region.levelIndex, 2);
        }
    }

    private static void logPerformanceStats() {
        long totalRegions = PER_DIM.values().stream().mapToLong(Map::size).sum();
        long criticalRegions = PER_DIM.values().stream().flatMap(map -> map.values().stream()).mapToLong(s -> s.levelIndex >= 2 ? 1L : 0L).sum();
        LOGGER.info(String.format("Regional TPS Stats - Total regions: %d, Critical: %d, Global TPS: %.2f", totalRegions, criticalRegions, globalTPS));
    }

    private static int levelStringToIndex(String level) {
        return switch (level.toLowerCase()) {
            case "emergency" -> 3;
            case "critical" -> 2;
            case "warning" -> 1;
            default -> 0;
        };
    }

    private static String indexToLevelString(int index) {
        return switch (index) {
            case 3 -> "emergency";
            case 2 -> "critical";
            case 1 -> "warning";
            default -> "normal";
        };
    }

    private static int levelToMultiplier(WmbConfig cfg, String level) {
        Integer m = cfg.regionalTPS.scaling.levels.get(level);
        return m != null ? Math.max(1, m) : 1;
    }

    private static void decayAverages(double decay) {
        for (Map<RegionKey, RegionStats> map : PER_DIM.values()) {
            for (RegionStats s : map.values()) {
                s.avgMs *= 1.0 - decay;
                s.avgMemoryMB *= 1.0 - decay;
                if (s.avgMs < 0.001) {
                    s.avgMs = 0.0;
                }
                if (s.avgMemoryMB < 0.001) {
                    s.avgMemoryMB = 0.0;
                }
                s.multiplier = 1;
                s.targetMultiplier = 1;
            }
        }
    }

    private static void evictStale(long maxAgeTicks) {
        long cutoff = GLOBAL_TICK - maxAgeTicks;
        for (Map<RegionKey, RegionStats> map : PER_DIM.values()) {
            map.entrySet().removeIf(e -> ((RegionStats)e.getValue()).lastUpdatedTick < cutoff);
        }
    }

    public static void recordEntityAiDuration(class_3218 level, class_2338 pos, long nanos) {
        if (nanos <= 0L) {
            return;
        }
        WmbConfig cfg = WmbConfig.get();
        if (!cfg.hasRegionalTps() || !cfg.regionalTPS.enabled) {
            return;
        }
        RegionStats s = RegionalTpsService.getOrCreate(level, pos);
        s.tickAiNanos += nanos;
        ++s.aiStepCount;
    }

    public static void recordBlockEntityTick(class_3218 level, class_2338 pos) {
        WmbConfig cfg = WmbConfig.get();
        if (!cfg.hasRegionalTps() || !cfg.regionalTPS.enabled) {
            return;
        }
        RegionStats s = RegionalTpsService.getOrCreate(level, pos);
        ++s.beCountTick;
        ++s.tileEntityUpdates;
    }

    public static void recordScheduledTick(class_3218 level, class_2338 pos) {
        WmbConfig cfg = WmbConfig.get();
        if (!cfg.hasRegionalTps() || !cfg.regionalTPS.enabled) {
            return;
        }
        RegionStats s = RegionalTpsService.getOrCreate(level, pos);
        ++s.schedTickCountTick;
    }

    public static void recordRedstoneUpdate(class_3218 level, class_2338 pos) {
        WmbConfig cfg = WmbConfig.get();
        if (!cfg.hasRegionalTps() || !cfg.regionalTPS.enabled) {
            return;
        }
        RegionStats s = RegionalTpsService.getOrCreate(level, pos);
        ++s.redstoneUpdates;
    }

    public static void recordMemoryUsage(class_3218 level, class_2338 pos, long bytes) {
        WmbConfig cfg = WmbConfig.get();
        if (!cfg.hasRegionalTps() || !cfg.regionalTPS.enabled) {
            return;
        }
        RegionStats s = RegionalTpsService.getOrCreate(level, pos);
        s.totalMemoryUsage += bytes;
    }

    public static void addBlockEntityTicks(class_3218 level, class_2338 pos, int count) {
        if (count <= 0) {
            return;
        }
        WmbConfig cfg = WmbConfig.get();
        if (!cfg.hasRegionalTps() || !cfg.regionalTPS.enabled) {
            return;
        }
        RegionStats s = RegionalTpsService.getOrCreate(level, pos);
        s.beCountTick += count;
    }

    public static int currentRegionMultiplier(class_3218 level, class_2338 pos) {
        WmbConfig cfg = WmbConfig.get();
        if (!cfg.hasRegionalTps() || !cfg.regionalTPS.enabled) {
            return 1;
        }
        RegionStats s = RegionalTpsService.getOrCreate(level, pos);
        return Math.max(1, s.multiplier);
    }

    public static List<String> topRegions(int limit) {
        ArrayList<String> out = new ArrayList<String>();
        ArrayList<Map.Entry> all = new ArrayList<Map.Entry>();
        for (Map.Entry<String, Map<RegionKey, RegionStats>> dimEntry : PER_DIM.entrySet()) {
            for (Map.Entry<RegionKey, RegionStats> e2 : dimEntry.getValue().entrySet()) {
                all.add(e2);
            }
        }
        all.sort(Comparator.comparingDouble(e -> -((RegionStats)e.getValue()).avgMs));
        int n = Math.min(limit, all.size());
        for (int i = 0; i < n; ++i) {
            Map.Entry e3 = (Map.Entry)all.get(i);
            RegionStats s = (RegionStats)e3.getValue();
            out.add(String.format("%s avg=%.2fms mem=%.1fMB active=%d be=%d red=%d x=%d z=%d mult=%d pri=%s", new Object[]{((RegionKey)e3.getKey()).dim, s.avgMs, s.avgMemoryMB, s.lastActiveTicks, s.lastBeCount, s.lastRedstoneUpdates, ((RegionKey)e3.getKey()).rx, ((RegionKey)e3.getKey()).rz, s.multiplier, s.priority}));
        }
        return out;
    }

    public static String regionInfo(class_3218 level, class_2338 pos) {
        String dim = level.method_27983().method_29177().toString();
        int rx = RegionalTpsService.toRegionIndex(pos.method_10263() >> 4);
        int rz = RegionalTpsService.toRegionIndex(pos.method_10260() >> 4);
        Map<RegionKey, RegionStats> map = PER_DIM.get(dim);
        RegionStats s = null;
        if (map != null) {
            s = map.get(new RegionKey(dim, rx, rz));
        }
        if (s == null) {
            return String.format("%s x=%d z=%d avg=0.00ms mem=0.0MB active=0 be=0 mult=1 pri=NORMAL", dim, rx, rz);
        }
        return String.format("%s avg=%.2fms mem=%.1fMB active=%d be=%d red=%d x=%d z=%d mult=%d->%d pri=%s emer=%s", new Object[]{dim, s.avgMs, s.avgMemoryMB, s.lastActiveTicks, s.lastBeCount, s.lastRedstoneUpdates, rx, rz, s.multiplier, s.targetMultiplier, s.priority, s.emergencyMode});
    }

    private static RegionStats getOrCreate(class_3218 level, class_2338 pos) {
        RegionKey key;
        String dim = level.method_27983().method_29177().toString();
        int chunkX = pos.method_10263() >> 4;
        int chunkZ = pos.method_10260() >> 4;
        int rx = RegionalTpsService.toRegionIndex(chunkX);
        int rz = RegionalTpsService.toRegionIndex(chunkZ);
        Map map = PER_DIM.computeIfAbsent(dim, d -> new HashMap());
        RegionStats s = (RegionStats)map.get(key = new RegionKey(dim, rx, rz));
        if (s == null) {
            s = new RegionStats();
            s.rx = rx;
            s.rz = rz;
            map.put(key, s);
        }
        return s;
    }

    private static int toRegionIndex(int chunkCoord) {
        int size = Math.max(1, WmbConfig.get().regionalTPS.regionSize);
        return Math.floorDiv(chunkCoord, size);
    }

    public static RegionKey regionKey(class_3218 level, class_2338 pos) {
        String dim = level.method_27983().method_29177().toString();
        int rx = RegionalTpsService.toRegionIndex(pos.method_10263() >> 4);
        int rz = RegionalTpsService.toRegionIndex(pos.method_10260() >> 4);
        return new RegionKey(dim, rx, rz);
    }

    public static boolean isEdgeChunk(int chunkX, int chunkZ) {
        int size = Math.max(1, WmbConfig.get().regionalTPS.regionSize);
        int localX = Math.floorMod(chunkX, size);
        int localZ = Math.floorMod(chunkZ, size);
        return localX == 0 || localZ == 0 || localX == size - 1 || localZ == size - 1;
    }

    public static boolean allowRegionTick(class_3218 level, int chunkX, int chunkZ, boolean edgeSensitive) {
        WmbConfig cfg = WmbConfig.get();
        if (!cfg.hasRegionalTps() || !cfg.regionalTPS.enabled) {
            return true;
        }
        if (edgeSensitive && RegionalTpsService.isEdgeChunk(chunkX, chunkZ)) {
            return true;
        }
        class_2338 sample = new class_2338((chunkX << 4) + 8, level.method_31607() + 1, (chunkZ << 4) + 8);
        int mul = RegionalTpsService.currentRegionMultiplier(level, sample);
        if (mul <= 1) {
            return true;
        }
        return GLOBAL_TICK % (long)mul == 0L;
    }

    public static Heatmap exportHeatmap(class_3218 level, class_2338 center, int radiusRegions) {
        String dim = level.method_27983().method_29177().toString();
        int chunkX = center.method_10263() >> 4;
        int chunkZ = center.method_10260() >> 4;
        int centerRx = RegionalTpsService.toRegionIndex(chunkX);
        int centerRz = RegionalTpsService.toRegionIndex(chunkZ);
        int size = Math.max(1, radiusRegions * 2 + 1);
        int originRx = centerRx - radiusRegions;
        int originRz = centerRz - radiusRegions;
        double[][] avgMs = new double[size][size];
        double[][] avgMem = new double[size][size];
        int[][] mul = new int[size][size];
        int[][] players = new int[size][size];
        RegionStats.RegionPriority[][] priority = new RegionStats.RegionPriority[size][size];
        Map map = PER_DIM.getOrDefault(dim, Collections.emptyMap());
        for (int dz = 0; dz < size; ++dz) {
            for (int dx = 0; dx < size; ++dx) {
                int rx = originRx + dx;
                int rz = originRz + dz;
                RegionStats s = (RegionStats)map.get(new RegionKey(dim, rx, rz));
                avgMs[dz][dx] = s != null ? s.avgMs : 0.0;
                avgMem[dz][dx] = s != null ? s.avgMemoryMB : 0.0;
                mul[dz][dx] = s != null ? Math.max(1, s.multiplier) : 1;
                players[dz][dx] = s != null ? s.playersInRegion.size() : 0;
                priority[dz][dx] = s != null ? s.priority : RegionStats.RegionPriority.NORMAL;
            }
        }
        return new Heatmap(dim, originRx, originRz, size, avgMs, avgMem, mul, players, priority, GLOBAL_TICK, globalTPS);
    }

    public static Heatmap exportHeatmapByOrigin(class_3218 level, String dim, int originRx, int originRz, int size) {
        double[][] avgMs = new double[size][size];
        double[][] avgMem = new double[size][size];
        int[][] mul = new int[size][size];
        int[][] players = new int[size][size];
        RegionStats.RegionPriority[][] priority = new RegionStats.RegionPriority[size][size];
        Map map = PER_DIM.getOrDefault(dim, Collections.emptyMap());
        for (int dz = 0; dz < size; ++dz) {
            for (int dx = 0; dx < size; ++dx) {
                int rx = originRx + dx;
                int rz = originRz + dz;
                RegionStats s = (RegionStats)map.get(new RegionKey(dim, rx, rz));
                avgMs[dz][dx] = s != null ? s.avgMs : 0.0;
                avgMem[dz][dx] = s != null ? s.avgMemoryMB : 0.0;
                mul[dz][dx] = s != null ? Math.max(1, s.multiplier) : 1;
                players[dz][dx] = s != null ? s.playersInRegion.size() : 0;
                priority[dz][dx] = s != null ? s.priority : RegionStats.RegionPriority.NORMAL;
            }
        }
        return new Heatmap(dim, originRx, originRz, size, avgMs, avgMem, mul, players, priority, GLOBAL_TICK, globalTPS);
    }

    public static RegionDetail exportRegionDetail(class_3218 level, String dim, int rx, int rz) {
        Map map = PER_DIM.getOrDefault(dim, Collections.emptyMap());
        RegionStats s = (RegionStats)map.get(new RegionKey(dim, rx, rz));
        double avgMs = 0.0;
        double avgMem = 0.0;
        int mul = 1;
        int targetMul = 1;
        int active = 0;
        int be = 0;
        int sched = 0;
        int redstone = 0;
        long tick = GLOBAL_TICK;
        double[] msHist = new double[]{};
        double[] memHist = new double[]{};
        int[] playerHist = new int[]{};
        RegionStats.RegionPriority priority = RegionStats.RegionPriority.NORMAL;
        boolean emergency = false;
        int goodTicks = 0;
        int badTicks = 0;
        if (s != null) {
            avgMs = s.avgMs;
            avgMem = s.avgMemoryMB;
            mul = Math.max(1, s.multiplier);
            targetMul = Math.max(1, s.targetMultiplier);
            active = s.lastActiveTicks;
            be = s.lastBeCount;
            sched = s.lastSchedTickCount;
            redstone = s.lastRedstoneUpdates;
            tick = s.lastUpdatedTick;
            priority = s.priority;
            emergency = s.emergencyMode;
            goodTicks = s.consecutiveGoodTicks;
            badTicks = s.consecutiveBadTicks;
            msHist = new double[s.histSize];
            memHist = new double[s.histSize];
            playerHist = new int[Math.min(s.histSize, s.playerHistory.length)];
            int start = s.histIndex - s.histSize;
            for (int i = 0; i < s.histSize; ++i) {
                int idx = Math.floorMod(start + i, s.msHistory.length);
                msHist[i] = s.msHistory[idx];
                memHist[i] = s.memHistory[idx];
                if (i >= playerHist.length) continue;
                playerHist[i] = s.playerHistory[Math.floorMod(start + i, s.playerHistory.length)];
            }
        }
        int sizeChunks = Math.max(1, WmbConfig.get().regionalTPS.regionSize);
        int minChunkX = rx * sizeChunks;
        int minChunkZ = rz * sizeChunks;
        int minX = minChunkX << 4;
        int minZ = minChunkZ << 4;
        int maxX = minChunkX + sizeChunks << 4;
        int maxZ = minChunkZ + sizeChunks << 4;
        int minY = level.method_31607();
        int maxY = level.method_31600();
        class_238 box = new class_238((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
        int total = 0;
        int mobs = 0;
        try {
            for (class_1297 e : level.method_18467(class_1297.class, box)) {
                ++total;
                if (!(e instanceof class_1308)) continue;
                ++mobs;
            }
        }
        catch (Exception e) {
            LOGGER.warning("Failed to count entities in region " + rx + "," + rz + ": " + e.getMessage());
        }
        return new RegionDetail(dim, rx, rz, avgMs, avgMem, mul, targetMul, active, be, sched, redstone, tick, msHist, memHist, playerHist, total, mobs, priority, emergency, goodTicks, badTicks);
    }

    public static String getPlayerRegionSummary(class_1657 player) {
        class_3218 level = (class_3218)player.method_37908();
        class_2338 pos = player.method_24515();
        RegionKey key = RegionalTpsService.regionKey(level, pos);
        RegionStats stats = RegionalTpsService.getOrCreate(level, pos);
        String status = "NORMAL";
        if (stats.emergencyMode) {
            status = "EMERGENCY";
        } else if (stats.levelIndex >= 2) {
            status = "CRITICAL";
        } else if (stats.levelIndex >= 1) {
            status = "WARNING";
        }
        return String.format("Region %s - Status: %s, Multiplier: %d->%d, Avg: %.2fms, Priority: %s", new Object[]{key, status, stats.multiplier, stats.targetMultiplier, stats.avgMs, stats.priority});
    }

    public static boolean forceRegionLevel(class_3218 level, int rx, int rz, String levelName, int duration) {
        String dim = level.method_27983().method_29177().toString();
        RegionKey key = new RegionKey(dim, rx, rz);
        Map map = PER_DIM.computeIfAbsent(dim, d -> new HashMap());
        RegionStats stats = map.computeIfAbsent(key, k -> {
            RegionStats s = new RegionStats();
            s.rx = rx;
            s.rz = rz;
            return s;
        });
        stats.levelIndex = RegionalTpsService.levelStringToIndex(levelName);
        REGION_PRIORITIES.put(key, GLOBAL_TICK + (long)duration);
        LOGGER.info(String.format("Forced region %s to level %s for %d ticks", key, levelName, duration));
        return true;
    }

    public static List<RegionKey> getProblematicRegions() {
        return PER_DIM.values().stream().flatMap(map -> map.entrySet().stream()).filter(e -> ((RegionStats)e.getValue()).levelIndex >= 2 || ((RegionStats)e.getValue()).emergencyMode).map(Map.Entry::getKey).sorted((a, b) -> {
            RegionStats sa = PER_DIM.get(a.dim).get(a);
            RegionStats sb = PER_DIM.get(b.dim).get(b);
            return Double.compare(sb.avgMs, sa.avgMs);
        }).toList();
    }

    public static Map<String, Object> getGlobalMetrics() {
        HashMap<String, Object> metrics = new HashMap<String, Object>();
        long totalRegions = PER_DIM.values().stream().mapToLong(Map::size).sum();
        long normalRegions = 0L;
        long warningRegions = 0L;
        long criticalRegions = 0L;
        long emergencyRegions = 0L;
        double totalAvgMs = 0.0;
        for (Map<RegionKey, RegionStats> map : PER_DIM.values()) {
            for (RegionStats s : map.values()) {
                totalAvgMs += s.avgMs;
                switch (s.levelIndex) {
                    case 0: {
                        ++normalRegions;
                        break;
                    }
                    case 1: {
                        ++warningRegions;
                        break;
                    }
                    case 2: {
                        ++criticalRegions;
                        break;
                    }
                    case 3: {
                        ++emergencyRegions;
                    }
                }
            }
        }
        metrics.put("totalRegions", totalRegions);
        metrics.put("normalRegions", normalRegions);
        metrics.put("warningRegions", warningRegions);
        metrics.put("criticalRegions", criticalRegions);
        metrics.put("emergencyRegions", emergencyRegions);
        metrics.put("avgRegionMs", totalRegions > 0L ? totalAvgMs / (double)totalRegions : 0.0);
        metrics.put("globalTPS", globalTPS);
        metrics.put("currentTick", GLOBAL_TICK);
        return metrics;
    }

    public static final class RegionStats {
        long tickAiNanos;
        int aiStepCount;
        int beCountTick;
        int schedTickCountTick;
        long totalMemoryUsage;
        int redstoneUpdates;
        int tileEntityUpdates;
        int chunkLoads;
        double avgMs;
        double avgMemoryMB;
        int lastActiveTicks;
        int lastBeCount;
        int lastSchedTickCount;
        int lastRedstoneUpdates;
        Set<UUID> playersInRegion = new HashSet<UUID>();
        boolean hasPlayers = false;
        long lastPlayerActivity = 0L;
        int multiplier = 1;
        int targetMultiplier = 1;
        int levelIndex = 0;
        long lastUpdatedTick;
        int rx;
        int rz;
        final double[] msHistory = new double[300];
        final double[] memHistory = new double[300];
        final int[] playerHistory = new int[60];
        int histSize = 0;
        int histIndex = 0;
        int consecutiveGoodTicks = 0;
        int consecutiveBadTicks = 0;
        boolean emergencyMode = false;
        RegionPriority priority = RegionPriority.NORMAL;

        public static enum RegionPriority {
            SPAWN(0.5),
            PLAYER_BASE(0.7),
            NORMAL(1.0),
            WILDERNESS(1.5),
            INACTIVE(2.0);

            public final double multiplierBias;

            private RegionPriority(double multiplierBias) {
                this.multiplierBias = multiplierBias;
            }
        }
    }

    public static final class RegionKey {
        public final String dim;
        public final int rx;
        public final int rz;
        private final int hash;

        public RegionKey(String dim, int rx, int rz) {
            this.dim = dim;
            this.rx = rx;
            this.rz = rz;
            this.hash = Objects.hash(dim, rx, rz);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RegionKey)) {
                return false;
            }
            RegionKey k = (RegionKey)o;
            return this.rx == k.rx && this.rz == k.rz && Objects.equals(this.dim, k.dim);
        }

        public int hashCode() {
            return this.hash;
        }

        public String toString() {
            return this.dim + ":" + this.rx + "," + this.rz;
        }
    }

    public static final class Heatmap {
        public final String dim;
        public final int originRx;
        public final int originRz;
        public final int size;
        public final double[][] avgMs;
        public final double[][] avgMem;
        public final int[][] multiplier;
        public final int[][] playerCount;
        public final RegionStats.RegionPriority[][] priority;
        public final long tick;
        public final double globalTPS;

        public Heatmap(String dim, int originRx, int originRz, int size, double[][] avgMs, double[][] avgMem, int[][] multiplier, int[][] playerCount, RegionStats.RegionPriority[][] priority, long tick, double globalTPS) {
            this.dim = dim;
            this.originRx = originRx;
            this.originRz = originRz;
            this.size = size;
            this.avgMs = avgMs;
            this.avgMem = avgMem;
            this.multiplier = multiplier;
            this.playerCount = playerCount;
            this.priority = priority;
            this.tick = tick;
            this.globalTPS = globalTPS;
        }
    }

    public static final class RegionDetail {
        public final String dim;
        public final int rx;
        public final int rz;
        public final double avgMs;
        public final double avgMem;
        public final int multiplier;
        public final int targetMultiplier;
        public final int lastActiveTicks;
        public final int lastBeCount;
        public final int lastSchedTickCount;
        public final int lastRedstoneUpdates;
        public final long tick;
        public final double[] msHistory;
        public final double[] memHistory;
        public final int[] playerHistory;
        public final int entityCount;
        public final int mobCount;
        public final RegionStats.RegionPriority priority;
        public final boolean emergencyMode;
        public final int consecutiveGoodTicks;
        public final int consecutiveBadTicks;

        public RegionDetail(String dim, int rx, int rz, double avgMs, double avgMem, int multiplier, int targetMultiplier, int lastActiveTicks, int lastBeCount, int lastSchedTickCount, int lastRedstoneUpdates, long tick, double[] msHistory, double[] memHistory, int[] playerHistory, int entityCount, int mobCount, RegionStats.RegionPriority priority, boolean emergencyMode, int consecutiveGoodTicks, int consecutiveBadTicks) {
            this.dim = dim;
            this.rx = rx;
            this.rz = rz;
            this.avgMs = avgMs;
            this.avgMem = avgMem;
            this.multiplier = multiplier;
            this.targetMultiplier = targetMultiplier;
            this.lastActiveTicks = lastActiveTicks;
            this.lastBeCount = lastBeCount;
            this.lastSchedTickCount = lastSchedTickCount;
            this.lastRedstoneUpdates = lastRedstoneUpdates;
            this.tick = tick;
            this.msHistory = msHistory;
            this.memHistory = memHistory;
            this.playerHistory = playerHistory;
            this.entityCount = entityCount;
            this.mobCount = mobCount;
            this.priority = priority;
            this.emergencyMode = emergencyMode;
            this.consecutiveGoodTicks = consecutiveGoodTicks;
            this.consecutiveBadTicks = consecutiveBadTicks;
        }
    }
}

