/*
 * Decompiled with CFR 0.152.
 */
package org.texboobcat.wmb.api;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7923;
import org.texboobcat.wmb.dab.DabPolicy;

public final class WmbApi {
    private static final Set<String> EXEMPT_TYPES = ConcurrentHashMap.newKeySet();
    private static final Set<String> HIGH_PRIORITY_TYPES = ConcurrentHashMap.newKeySet();
    private static final Map<class_1308, Boolean> FORCE_TICK = Collections.synchronizedMap(new WeakHashMap());

    private WmbApi() {
    }

    private static String keyOf(class_1299<?> type) {
        class_2960 key = class_7923.field_41177.method_10221(type);
        return key != null ? key.toString() : String.valueOf(type);
    }

    public static void markExempt(class_1299<?> type) {
        EXEMPT_TYPES.add(WmbApi.keyOf(type));
    }

    public static void unmarkExempt(class_1299<?> type) {
        EXEMPT_TYPES.remove(WmbApi.keyOf(type));
    }

    public static boolean isExempt(class_1299<?> type) {
        return EXEMPT_TYPES.contains(WmbApi.keyOf(type));
    }

    public static void markHighPriority(class_1299<?> type) {
        HIGH_PRIORITY_TYPES.add(WmbApi.keyOf(type));
    }

    public static void unmarkHighPriority(class_1299<?> type) {
        HIGH_PRIORITY_TYPES.remove(WmbApi.keyOf(type));
    }

    public static boolean isHighPriority(class_1299<?> type) {
        return HIGH_PRIORITY_TYPES.contains(WmbApi.keyOf(type));
    }

    public static void requestImmediateTick(class_1308 mob) {
        if (mob != null) {
            FORCE_TICK.put(mob, Boolean.TRUE);
        }
    }

    public static boolean consumeImmediateTick(class_1308 mob) {
        if (mob == null) {
            return false;
        }
        return FORCE_TICK.remove(mob) != null;
    }

    public static int getDabInterval(class_1308 mob) {
        class_1937 class_19372 = mob.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return 1;
        }
        class_3218 level = (class_3218)class_19372;
        double minDistSqr = Double.POSITIVE_INFINITY;
        for (class_3222 p : level.method_18456()) {
            double d2 = p.method_5858((class_1297)mob);
            if (!(d2 < minDistSqr)) continue;
            minDistSqr = d2;
        }
        return DabPolicy.computeInterval(mob, minDistSqr);
    }
}

